/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.SearchRequest;
import com.openexchange.ajax.appointment.action.SearchResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import org.json.JSONArray;

public class Bug16476Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private AJAXClient clientA;
    private AJAXClient clientB;
    private FolderObject folder;

    public Bug16476Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.folder = Create.folder(1, "Folder to test bug 16476", 2, 1, Create.ocl(this.clientA.getValues().getUserId(), false, true, 128, 128, 128, 128), Create.ocl(this.clientB.getValues().getUserId(), false, false, 128, 128, 128, 128));
        CommonInsertResponse response = this.clientA.execute(new InsertRequest(EnumAPI.OX_OLD, this.folder));
        response.fillObject((DataObject)this.folder);
        this.appointment = new Appointment();
        this.appointment.setStartDate(TimeTools.D("01.06.2010 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.06.2010 09:00"));
        this.appointment.setTitle("Bug 16476 Test");
        this.appointment.setParentFolderID(this.folder.getObjectID());
        this.appointment.setPrivateFlag(true);
        this.appointment.setIgnoreConflicts(true);
    }

    public void testBug16476() throws Exception {
        com.openexchange.ajax.appointment.action.InsertRequest insert = new com.openexchange.ajax.appointment.action.InsertRequest(this.appointment, this.clientA.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.clientA.execute(insert);
        insertResponse.fillAppointment(this.appointment);
        SearchRequest search = new SearchRequest("*", this.folder.getObjectID(), new int[]{1});
        SearchResponse searchResponse = this.clientB.execute(search);
        JSONArray jsonArray = (JSONArray)searchResponse.getResponse().getData();
        Bug16476Test.assertTrue((String)"No results expected", (jsonArray.length() == 0 ? 1 : 0) != 0);
    }

    @Override
    protected void tearDown() throws Exception {
        this.clientA.execute(new com.openexchange.ajax.appointment.action.DeleteRequest(this.appointment));
        this.clientA.execute(new DeleteRequest((API)EnumAPI.OX_OLD, this.folder));
        super.tearDown();
    }
}

