/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import java.util.Calendar;
import java.util.Date;
import java.util.Random;

class AppointmentRangeGenerator {
    private final Random random = new Random();
    private final Calendar calendar;

    public AppointmentRangeGenerator(Calendar calendar) {
        this.calendar = calendar;
    }

    public AppointmentRange getDateRange() {
        this.calendar.set(7, this.getRandomWorkDay());
        this.calendar.set(11, this.getRandomAMTime());
        Date startDate = this.calendar.getTime();
        this.calendar.set(11, this.getRandomPMTime());
        Date endDate = this.calendar.getTime();
        return new AppointmentRange(startDate, endDate);
    }

    private int getRandomWorkDay() {
        return 2 + this.random.nextInt(5);
    }

    private int getRandomAMTime() {
        return this.random.nextInt(12);
    }

    private int getRandomPMTime() {
        return 12 + this.random.nextInt(12);
    }

    public class AppointmentRange {
        public Date startDate;
        public Date endDate;

        public AppointmentRange(Date startDate, Date endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }
    }
}

