/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.AppointmentRangeGenerator;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.AppointmentUpdatesResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.appointment.action.UpdatesRequest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractUpdatesRequest;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.groupware.container.Appointment;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONObject;

public class AbstractAppointmentTest
extends AbstractAJAXSession {
    protected int appointmentFolderId = -1;
    protected long dateTime = 0L;
    protected int userId = 0;
    protected AJAXClient client;
    protected TimeZone timezone;
    protected AppointmentRangeGenerator appointmentRangeGenerator;

    protected AbstractAppointmentTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.appointmentFolderId = this.client.getValues().getPrivateAppointmentFolder();
        this.userId = this.client.getValues().getUserId();
        this.timezone = this.client.getValues().getTimeZone();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.dateTime = calendar.getTimeInMillis();
        this.appointmentRangeGenerator = new AppointmentRangeGenerator(calendar);
    }

    protected List<Appointment> createAndPersistSeveral(String title, int amount) throws Exception {
        List<Appointment> severalAppointments = this.createSeveral(title, amount);
        severalAppointments = this.persistSeveral(severalAppointments);
        return severalAppointments;
    }

    protected List<Appointment> createSeveral(String title, int amount) {
        ArrayList<Appointment> newAppointments = new ArrayList<Appointment>(amount);
        for (int i = 0; i < amount; ++i) {
            String serialTitle = title + "-" + i;
            AppointmentRangeGenerator.AppointmentRange dateRange = this.appointmentRangeGenerator.getDateRange();
            Appointment newAppointment = this.createSingle(dateRange.startDate, dateRange.endDate, serialTitle);
            newAppointments.add(newAppointment);
        }
        return newAppointments;
    }

    protected Appointment createSingle(Date startDate, Date endDate, String title) {
        Appointment newAppointment = new Appointment();
        newAppointment.setParentFolderID(this.appointmentFolderId);
        newAppointment.setShownAs(4);
        newAppointment.setIgnoreConflicts(true);
        newAppointment.setTitle(title);
        newAppointment.setStartDate(startDate);
        newAppointment.setEndDate(endDate);
        return newAppointment;
    }

    public List<Appointment> persistSeveral(List<Appointment> newAppointments) throws Exception {
        int numberOfAppointments = newAppointments.size();
        ArrayList<InsertRequest> insertAppointmentRequests = new ArrayList<InsertRequest>(numberOfAppointments);
        for (Appointment appointment : newAppointments) {
            insertAppointmentRequests.add(new InsertRequest(appointment, this.timezone));
        }
        MultipleRequest multipleRequest = MultipleRequest.create(insertAppointmentRequests.toArray(new InsertRequest[numberOfAppointments]));
        MultipleResponse multipleResponse = (MultipleResponse)this.client.execute(multipleRequest);
        return this.updateAppointmentsWithTimeAndId(newAppointments, multipleResponse);
    }

    public void updateAppointments(List<Appointment> appointments) {
        this.updateAppointments(appointments.toArray(new Appointment[appointments.size()]));
    }

    public void updateAppointments(Appointment ... appointments) {
        int numAppointments = appointments.length;
        UpdateRequest[] updateRequests = new UpdateRequest[numAppointments];
        for (int i = 0; i < numAppointments; ++i) {
            Appointment appointment = appointments[i];
            appointment.setTitle(appointment.getTitle() + " was updated");
            updateRequests[i] = new UpdateRequest(appointment, this.timezone);
        }
        MultipleRequest multipleUpdate = MultipleRequest.create(updateRequests);
        MultipleResponse multipleResponse = (MultipleResponse)this.client.executeSafe(multipleUpdate);
        for (int i = 0; i < numAppointments; ++i) {
            appointments[i].setLastModified(((UpdateResponse)((Object)multipleResponse.getResponse(i))).getTimestamp());
        }
    }

    public void deleteAppointments(List<Appointment> appointments) {
        this.deleteAppointments(appointments.toArray(new Appointment[appointments.size()]));
    }

    public void deleteAppointments(Appointment ... appointments) {
        int numContacts = appointments.length;
        DeleteRequest[] deleteRequests = new DeleteRequest[numContacts];
        for (int i = 0; i < numContacts; ++i) {
            Appointment appointment = appointments[i];
            deleteRequests[i] = new DeleteRequest(appointment);
        }
        MultipleRequest multipleDelete = MultipleRequest.create(deleteRequests);
        this.client.executeSafe(multipleDelete);
    }

    private List<Appointment> updateAppointmentsWithTimeAndId(List<Appointment> appointments, MultipleResponse<AppointmentInsertResponse> insertResponses) throws Exception {
        for (int i = 0; i < appointments.size(); ++i) {
            Appointment currentAppointment = appointments.get(i);
            Response currentResponse = insertResponses.getResponse(i).getResponse();
            Date timestamp = currentResponse.getTimestamp();
            JSONObject responseData = (JSONObject)currentResponse.getData();
            currentAppointment.setLastModified(timestamp);
            currentAppointment.setObjectID(responseData.getInt("id"));
        }
        return appointments;
    }

    public AppointmentUpdatesResponse listModifiedAppointments(int inFolder, int[] cols, Date lastModified, AbstractUpdatesRequest.Ignore ignore, boolean showPrivate) throws Exception {
        UpdatesRequest request = new UpdatesRequest(inFolder, cols, lastModified, false, showPrivate, AbstractUpdatesRequest.Ignore.NONE);
        AppointmentUpdatesResponse response = this.client.execute(request);
        return response;
    }
}

