/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.config.ConfigTools;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.parser.AppointmentParser;
import com.openexchange.ajax.parser.ResponseParser;
import com.openexchange.ajax.writer.AppointmentWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceGroupParticipant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.java.Charsets;
import com.openexchange.java.util.TimeZones;
import com.openexchange.test.OXTestToolkit;
import com.openexchange.test.TestException;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AppointmentTest
extends AbstractAJAXTest {
    public static final int[] APPOINTMENT_FIELDS = new int[]{1, 2, 4, 5, 3, 20, 101, 100, 200, 201, 202, 400, 203, 209, 220, 221, 402, 206, 207, 401, 102, 211, 210, 410, 224, 223, 225};
    protected static final String APPOINTMENT_URL = "/ajax/calendar";
    protected static int appointmentFolderId = -1;
    protected static long startTime = 0L;
    protected static long endTime = 0L;
    protected static final long dayInMillis = 86400000L;
    protected String userParticipant2 = null;
    protected String userParticipant3 = null;
    protected String groupParticipant = null;
    protected String resourceParticipant = null;
    protected int userId = 0;
    protected TimeZone timeZone = null;
    private static final Logger LOG = LoggerFactory.getLogger(AppointmentTest.class);
    private final List<Appointment> clean = new ArrayList<Appointment>();

    public AppointmentTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            FolderObject folderObj = FolderTest.getStandardCalendarFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
            appointmentFolderId = folderObj.getObjectID();
            this.userId = folderObj.getCreatedBy();
            this.timeZone = ConfigTools.getTimeZone(this.getWebConversation(), this.getHostName(), this.getSessionId());
            LOG.debug("use timezone: " + this.timeZone);
            Calendar c = Calendar.getInstance();
            c.setTimeZone(this.timeZone);
            c.set(11, 8);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            startTime = c.getTimeInMillis();
            startTime += (long)this.timeZone.getOffset(startTime);
            endTime = startTime + 3600000L;
            this.userParticipant2 = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"user_participant2", (String)"");
            this.userParticipant3 = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"user_participant3", (String)"");
            this.groupParticipant = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"group_participant", (String)"");
            this.resourceParticipant = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"resource_participant", (String)"");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception(ex);
        }
    }

    protected void compareObject(Appointment appointmentObj1, Appointment appointmentObj2) throws Exception {
        this.compareObject(appointmentObj1, appointmentObj2, appointmentObj1.getStartDate().getTime(), appointmentObj1.getEndDate().getTime());
    }

    protected void compareObject(Appointment appointmentObj1, Appointment appointmentObj2, long newStartTime, long newEndTime) throws Exception {
        AppointmentTest.assertEquals((String)"id", (int)appointmentObj1.getObjectID(), (int)appointmentObj2.getObjectID());
        OXTestToolkit.assertEqualsAndNotNull("title", appointmentObj1.getTitle(), appointmentObj2.getTitle());
        AppointmentTest.assertEquals((String)"start", (long)newStartTime, (long)appointmentObj2.getStartDate().getTime());
        AppointmentTest.assertEquals((String)"end", (long)newEndTime, (long)appointmentObj2.getEndDate().getTime());
        OXTestToolkit.assertEqualsAndNotNull("location", appointmentObj1.getLocation(), appointmentObj2.getLocation());
        AppointmentTest.assertEquals((String)"shown_as", (int)appointmentObj1.getShownAs(), (int)appointmentObj2.getShownAs());
        AppointmentTest.assertEquals((String)"folder id", (int)appointmentObj1.getParentFolderID(), (int)appointmentObj2.getParentFolderID());
        AppointmentTest.assertEquals((String)"private flag", (boolean)appointmentObj1.getPrivateFlag(), (boolean)appointmentObj2.getPrivateFlag());
        AppointmentTest.assertEquals((String)"full time", (boolean)appointmentObj1.getFullTime(), (boolean)appointmentObj2.getFullTime());
        AppointmentTest.assertEquals((String)"label", (int)appointmentObj1.getLabel(), (int)appointmentObj2.getLabel());
        AppointmentTest.assertEquals((String)"recurrence_type", (int)appointmentObj1.getRecurrenceType(), (int)appointmentObj2.getRecurrenceType());
        AppointmentTest.assertEquals((String)"interval", (int)appointmentObj1.getInterval(), (int)appointmentObj2.getInterval());
        AppointmentTest.assertEquals((String)"days", (int)appointmentObj1.getDays(), (int)appointmentObj2.getDays());
        AppointmentTest.assertEquals((String)"month", (int)appointmentObj1.getMonth(), (int)appointmentObj2.getMonth());
        AppointmentTest.assertEquals((String)"day_in_month", (int)appointmentObj1.getDayInMonth(), (int)appointmentObj2.getDayInMonth());
        AppointmentTest.assertEquals((String)"until", (Object)appointmentObj1.getUntil(), (Object)appointmentObj2.getUntil());
        if (appointmentObj1.getOrganizer() != null && appointmentObj2.getOrganizer() != null) {
            AppointmentTest.assertEquals((String)"organizer", (String)appointmentObj1.getOrganizer(), (String)appointmentObj2.getOrganizer());
        }
        if (appointmentObj1.containsUid()) {
            AppointmentTest.assertEquals((String)"uid", (String)appointmentObj1.getUid(), (String)appointmentObj2.getUid());
        }
        OXTestToolkit.assertEqualsAndNotNull("note", appointmentObj1.getNote(), appointmentObj2.getNote());
        OXTestToolkit.assertEqualsAndNotNull("categories", appointmentObj1.getCategories(), appointmentObj2.getCategories());
        OXTestToolkit.assertEqualsAndNotNull("delete_exceptions", appointmentObj1.getDeleteException(), appointmentObj2.getDeleteException());
        OXTestToolkit.assertEqualsAndNotNull("participants are not equals", this.participants2String(appointmentObj1.getParticipants()), this.participants2String(appointmentObj2.getParticipants()));
    }

    protected Appointment createAppointmentObject(String title) {
        Appointment appointmentobject = new Appointment();
        appointmentobject.setTitle(title);
        appointmentobject.setStartDate(new Date(startTime));
        appointmentobject.setEndDate(new Date(endTime));
        appointmentobject.setLocation("Location");
        appointmentobject.setShownAs(3);
        appointmentobject.setParentFolderID(appointmentFolderId);
        appointmentobject.setIgnoreConflicts(true);
        return appointmentobject;
    }

    public static int insertAppointment(WebConversation webCon, Appointment appointmentObj, TimeZone userTimeZone, String host, String session) throws OXException, Exception {
        host = AppointmentTest.appendPrefix(host);
        int objectId = 0;
        StringWriter stringWriter = new StringWriter();
        JSONObject jsonObj = new JSONObject();
        AppointmentWriter appointmentwriter = new AppointmentWriter(userTimeZone);
        appointmentwriter.writeAppointment(appointmentObj, jsonObj);
        stringWriter.write(jsonObj.toString());
        stringWriter.flush();
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "new");
        ByteArrayInputStream bais = new ByteArrayInputStream(stringWriter.toString().getBytes(Charsets.UTF_8));
        PutMethodWebRequest req = new PutMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            throw new TestException("json error: " + response.getErrorMessage());
        }
        JSONObject data = (JSONObject)response.getData();
        if (data.has("id")) {
            objectId = data.getInt("id");
        }
        if (data.has("conflicts")) {
            throw new OXException().setLogMessage("conflicts found!");
        }
        return objectId;
    }

    public static int updateAppointment(WebConversation webCon, Appointment appointmentObj, int objectId, int inFolder, TimeZone userTimeZone, String host, String session) throws Exception {
        return AppointmentTest.updateAppointment(webCon, appointmentObj, objectId, inFolder, new Date(System.currentTimeMillis() + 1000000L), userTimeZone, host, session);
    }

    public static int updateAppointment(WebConversation webCon, Appointment appointmentObj, int objectId, int inFolder, Date modified, TimeZone userTimeZone, String host, String session) throws Exception {
        host = AppointmentTest.appendPrefix(host);
        StringWriter stringWriter = new StringWriter();
        JSONObject jsonObj = new JSONObject();
        AppointmentWriter appointmentwriter = new AppointmentWriter(userTimeZone);
        appointmentwriter.writeAppointment(appointmentObj, jsonObj);
        stringWriter.write(jsonObj.toString());
        stringWriter.flush();
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "update");
        parameter.setParameter("id", Integer.toString(objectId));
        parameter.setParameter("folder", Integer.toString(inFolder));
        parameter.setParameter("timestamp", modified);
        ByteArrayInputStream bais = new ByteArrayInputStream(stringWriter.toString().getBytes(Charsets.UTF_8));
        PutMethodWebRequest req = new PutMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            throw new TestException("json error: " + response.getErrorMessage());
        }
        JSONObject data = (JSONObject)response.getData();
        if (data.has("id")) {
            objectId = data.getInt("id");
        }
        if (data.has("conflicts")) {
            throw new OXException().setLogMessage("conflicts found!");
        }
        return objectId;
    }

    public static void deleteAppointment(WebConversation webCon, int id, int inFolder, String host, String session, boolean ignoreFailure) throws Exception {
        AppointmentTest.deleteAppointment(webCon, id, inFolder, new Date(System.currentTimeMillis() + 1000000L), host, session, ignoreFailure);
    }

    public static void deleteAppointment(WebConversation webCon, int id, int inFolder, Date modified, String host, String session, boolean ignoreFailure) throws Exception {
        AppointmentTest.deleteAppointment(webCon, id, inFolder, 0, modified, host, session, ignoreFailure);
    }

    public static void deleteAppointment(WebConversation webCon, int id, int inFolder, int recurrencePosition, String host, String session, boolean ignoreFailure) throws Exception {
        AppointmentTest.deleteAppointment(webCon, id, inFolder, recurrencePosition, new Date(System.currentTimeMillis() + 1000000L), host, session, ignoreFailure);
    }

    public static void deleteAppointment(WebConversation webCon, int id, int inFolder, int recurrencePosition, Date modified, String host, String session, boolean ignoreFailure) throws OXException, IOException, JSONException {
        AJAXSession ajaxSession = new AJAXSession(webCon, host, session);
        DeleteRequest deleteRequest = new DeleteRequest(id, inFolder, recurrencePosition, modified);
        deleteRequest.setFailOnError(false);
        CommonDeleteResponse response = Executor.execute(ajaxSession, deleteRequest);
        if (!ignoreFailure && response.hasError()) {
            throw new TestException("json error: " + response.getResponse().getErrorMessage());
        }
    }

    public static void deleteAppointment(WebConversation webCon, int id, int inFolder, Date recurrenceDatePosition, Date modified, String host, String session, boolean ignoreFailure) throws Exception, OXException, IOException, SAXException {
        AJAXSession ajaxSession = new AJAXSession(webCon, host, session);
        DeleteRequest deleteRequest = new DeleteRequest(id, inFolder, recurrenceDatePosition, modified);
        deleteRequest.setFailOnError(false);
        CommonDeleteResponse response = Executor.execute(ajaxSession, deleteRequest);
        if (!ignoreFailure && response.hasError()) {
            throw new Exception("json error: " + response.getResponse().getErrorMessage());
        }
    }

    public static void confirmAppointment(WebConversation webCon, int objectId, int folderId, int confirm, String confirmMessage, String host, String session) throws Exception {
        host = AppointmentTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "confirm");
        parameter.setParameter("id", objectId);
        parameter.setParameter("folder", folderId);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("confirmation", confirm);
        jsonObj.put("confirmmessage", (Object)confirmMessage);
        ByteArrayInputStream bais = new ByteArrayInputStream(jsonObj.toString().getBytes());
        PutMethodWebRequest req = new PutMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            AppointmentTest.fail((String)("json error: " + response.getErrorMessage()));
        }
    }

    public static Appointment[] listAppointment(WebConversation webCon, int inFolder, int[] cols, Date start, Date end, TimeZone userTimeZone, boolean showAll, String host, String session) throws JSONException, OXException, IOException, SAXException {
        return AppointmentTest.listAppointment(webCon, inFolder, cols, start, end, userTimeZone, showAll, false, host, session);
    }

    public static Appointment[] listAppointment(WebConversation webCon, int inFolder, int[] cols, Date start, Date end, TimeZone userTimeZone, boolean showAll, boolean recurrenceMaster, String host, String session) throws JSONException, OXException, IOException, SAXException {
        return AppointmentTest.listAppointment(webCon, inFolder, cols, start, end, userTimeZone, showAll, recurrenceMaster, -1, -1, host, session);
    }

    public static Appointment[] listAppointment(WebConversation webCon, int inFolder, int[] cols, Date start, Date end, TimeZone userTimeZone, boolean showAll, boolean recurrenceMaster, int leftHandLimit, int rightHandLimit, String host, String session) throws JSONException, OXException, IOException, SAXException {
        host = AppointmentTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "all");
        parameter.setParameter("start", start);
        parameter.setParameter("end", end);
        parameter.setParameter("columns", URLParameter.colsArray2String(cols));
        if (recurrenceMaster) {
            parameter.setParameter("recurrence_master", recurrenceMaster);
        }
        if (!showAll) {
            parameter.setParameter("folder", inFolder);
        }
        if (leftHandLimit > -1) {
            parameter.setParameter("left_hand_limit", leftHandLimit);
        }
        if (rightHandLimit > -1) {
            parameter.setParameter("right_hand_limit", rightHandLimit);
        }
        return AppointmentTest.listAppointment(webCon, cols, parameter, userTimeZone, host, session);
    }

    public static Appointment[] listAppointment(WebConversation webCon, int[] cols, URLParameter parameter, TimeZone userTimeZone, String host, String session) throws JSONException, OXException, IOException, SAXException {
        host = AppointmentTest.appendPrefix(host);
        GetMethodWebRequest req = new GetMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            AppointmentTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        AppointmentTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        return AppointmentTest.jsonArray2AppointmentArray((JSONArray)response.getData(), cols, userTimeZone);
    }

    public static int resolveUid(WebConversation webCon, String host, String session, String uid) throws IOException, SAXException, JSONException {
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "resolveuid");
        parameter.setParameter("uid", uid);
        GetMethodWebRequest req = new GetMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            AppointmentTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        JSONObject jsonResponse = (JSONObject)response.getData();
        AppointmentTest.assertTrue((boolean)jsonResponse.has("id"));
        return jsonResponse.getInt("id");
    }

    public static Appointment[] listAppointment(WebConversation webCon, int[][] objectIdAndFolderId, int[] cols, TimeZone userTimeZone, String host, String session) throws Exception {
        Appointment[] appointmentArray = new Appointment[objectIdAndFolderId.length];
        for (int a = 0; a < appointmentArray.length; ++a) {
            appointmentArray[a] = new Appointment();
            appointmentArray[a].setObjectID(objectIdAndFolderId[a][0]);
            appointmentArray[a].setParentFolderID(objectIdAndFolderId[a][1]);
        }
        return AppointmentTest.listAppointment(webCon, appointmentArray, cols, userTimeZone, host, session);
    }

    public static Appointment[] listAppointment(WebConversation webCon, Appointment[] appointmentArray, int[] cols, TimeZone userTimeZone, String host, String session) throws Exception {
        host = AppointmentTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "list");
        parameter.setParameter("columns", URLParameter.colsArray2String(cols));
        JSONArray jsonArray = new JSONArray();
        for (int a = 0; a < appointmentArray.length; ++a) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("id", appointmentArray[a].getObjectID());
            jsonObj.put("folder", appointmentArray[a].getParentFolderID());
            if (appointmentArray[a].containsRecurrencePosition()) {
                jsonObj.put("recurrence_position", appointmentArray[a].getRecurrencePosition());
            }
            jsonArray.put((Object)jsonObj);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(jsonArray.toString().getBytes());
        PutMethodWebRequest req = new PutMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        Response response = ResponseParser.parse((String)resp.getText());
        if (response.hasError()) {
            throw new TestException("json error: " + response.getErrorMessage());
        }
        AppointmentTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        return AppointmentTest.jsonArray2AppointmentArray((JSONArray)response.getData(), cols, userTimeZone);
    }

    public static Appointment loadAppointment(WebConversation webCon, int objectId, int inFolder, TimeZone userTimeZone, String host, String session) throws Exception {
        return AppointmentTest.loadAppointment(webCon, objectId, 0, inFolder, userTimeZone, host, session);
    }

    public static Appointment loadAppointment(WebConversation webCon, int objectId, int recurrencePosition, int inFolder, TimeZone userTimeZone, String host, String session) throws Exception {
        host = AppointmentTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "get");
        parameter.setParameter("id", objectId);
        parameter.setParameter("folder", inFolder);
        if (recurrencePosition > 0) {
            parameter.setParameter("recurrence_position", recurrencePosition);
        }
        GetMethodWebRequest req = new GetMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            AppointmentTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        AppointmentTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        Appointment appointmentObj = new Appointment();
        AppointmentParser appointmentParser = new AppointmentParser(true, userTimeZone);
        appointmentParser.parse(appointmentObj, (JSONObject)response.getData());
        return appointmentObj;
    }

    public static Appointment loadAppointment(WebConversation webCon, int objectId, Date start, Date end, int[] cols, TimeZone userTimeZone, String host, String session) throws Exception {
        return AppointmentTest.loadAppointment(webCon, objectId, 0, start, end, cols, userTimeZone, host, session);
    }

    public static Appointment loadAppointment(WebConversation webCon, int objectId, Date start, Date end, Date modified, int[] cols, TimeZone userTimeZone, String host, String session) throws Exception {
        return AppointmentTest.loadAppointment(webCon, objectId, 0, start, end, modified, cols, userTimeZone, host, session);
    }

    public static Appointment loadAppointment(WebConversation webCon, int objectId, Date start, Date end, Date modified, int recurrencePosition, int[] cols, TimeZone userTimeZone, String host, String session) throws Exception {
        return AppointmentTest.loadAppointment(webCon, objectId, 0, start, end, modified, recurrencePosition, cols, userTimeZone, host, session);
    }

    public static Appointment loadAppointment(WebConversation webCon, int objectId, int inFolder, Date start, Date end, int[] cols, TimeZone userTimeZone, String host, String session) throws JSONException, OXException, IOException, SAXException, OXException {
        boolean showAll = inFolder == 0;
        Appointment[] appointmentArray = AppointmentTest.listAppointment(webCon, inFolder, cols, start, end, userTimeZone, showAll, host, session);
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            return appointmentArray[a];
        }
        throw new TestException("object not found");
    }

    public static Appointment loadAppointment(WebConversation webCon, int objectId, int inFolder, Date start, Date end, Date modified, int[] cols, TimeZone userTimeZone, String host, String session) throws Exception {
        Appointment[] appointmentArray = AppointmentTest.listModifiedAppointment(webCon, inFolder, start, end, modified, cols, userTimeZone, host, session);
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            return appointmentArray[a];
        }
        return null;
    }

    public static Appointment loadAppointment(WebConversation webCon, int objectId, int inFolder, Date start, Date end, Date modified, int recurrencePosition, int[] cols, TimeZone userTimeZone, String host, String session) throws Exception {
        Appointment[] appointmentArray = AppointmentTest.listModifiedAppointment(webCon, inFolder, start, end, modified, cols, userTimeZone, host, session);
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId || appointmentArray[a].getRecurrencePosition() != recurrencePosition) continue;
            return appointmentArray[a];
        }
        throw new TestException("object not found");
    }

    public static Appointment[] listModifiedAppointment(WebConversation webCon, Date start, Date end, Date modified, int[] cols, TimeZone userTimeZone, String host, String session) throws Exception {
        return AppointmentTest.listModifiedAppointment(webCon, 0, start, end, modified, cols, userTimeZone, host, session);
    }

    public static Appointment[] listModifiedAppointment(WebConversation webCon, int inFolder, Date start, Date end, Date modified, int[] cols, TimeZone userTimeZone, String host, String session) throws Exception {
        return AppointmentTest.listModifiedAppointment(webCon, inFolder, start, end, modified, cols, userTimeZone, false, host, session);
    }

    public static Appointment[] listModifiedAppointment(WebConversation webCon, int inFolder, Date start, Date end, Date modified, int[] cols, TimeZone userTimeZone, boolean bRecurrenceMaster, String host, String session) throws Exception {
        host = AppointmentTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "updates");
        if (inFolder != 0) {
            parameter.setParameter("folder", inFolder);
        }
        parameter.setParameter("ignore", "deleted");
        parameter.setParameter("timestamp", modified);
        parameter.setParameter("start", start);
        parameter.setParameter("end", end);
        parameter.setParameter("columns", URLParameter.colsArray2String(cols));
        if (bRecurrenceMaster) {
            parameter.setParameter("recurrence_master", true);
        }
        GetMethodWebRequest req = new GetMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            AppointmentTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        AppointmentTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        AppointmentTest.assertTrue((String)"requested timestamp bigger then timestamp in response", (response.getTimestamp().getTime() >= modified.getTime() ? 1 : 0) != 0);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        return AppointmentTest.jsonArray2AppointmentArray((JSONArray)response.getData(), cols, userTimeZone);
    }

    public static Appointment[] listDeleteAppointment(WebConversation webCon, int inFolder, Date start, Date end, Date modified, TimeZone userTimeZone, String host, String session) throws OXException, Exception {
        host = AppointmentTest.appendPrefix(host);
        int[] cols = new int[]{1};
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "updates");
        if (inFolder != 0) {
            parameter.setParameter("folder", inFolder);
        }
        parameter.setParameter("ignore", "changed");
        parameter.setParameter("timestamp", modified);
        parameter.setParameter("start", start);
        parameter.setParameter("end", end);
        parameter.setParameter("columns", URLParameter.colsArray2String(cols));
        GetMethodWebRequest req = new GetMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            throw new TestException(response.getErrorMessage());
        }
        AppointmentTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        JSONArray jsonArray = (JSONArray)response.getData();
        Appointment[] appointmentArray = new Appointment[jsonArray.length()];
        for (int a = 0; a < jsonArray.length(); ++a) {
            appointmentArray[a] = new Appointment();
            appointmentArray[a].setObjectID(jsonArray.getInt(a));
        }
        return appointmentArray;
    }

    public static Appointment[] searchAppointment(WebConversation webCon, String searchpattern, int inFolder, int[] cols, TimeZone userTimeZone, String host, String session) throws Exception {
        return AppointmentTest.searchAppointment(webCon, searchpattern, inFolder, null, null, cols, userTimeZone, host, session);
    }

    public static Appointment[] searchAppointment(WebConversation webCon, String searchpattern, int inFolder, Date start, Date end, int[] cols, TimeZone userTimeZone, String host, String session) throws Exception {
        host = AppointmentTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "search");
        parameter.setParameter("columns", URLParameter.colsArray2String(cols));
        if (start != null) {
            parameter.setParameter("start", start);
        }
        if (end != null) {
            parameter.setParameter("end", end);
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("pattern", (Object)searchpattern);
        jsonObj.put("folder", inFolder);
        PutMethodWebRequest req = new PutMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters(), (InputStream)new ByteArrayInputStream(jsonObj.toString().getBytes()), "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            AppointmentTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        AppointmentTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        return AppointmentTest.jsonArray2AppointmentArray((JSONArray)response.getData(), cols, userTimeZone);
    }

    public static boolean[] hasAppointments(WebConversation webCon, Date start, Date end, String host, String session) throws Exception {
        host = AppointmentTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "has");
        parameter.setParameter("start", start);
        parameter.setParameter("end", end);
        GetMethodWebRequest req = new GetMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            AppointmentTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        boolean isArray = (JSONArray)response.getData() instanceof JSONArray;
        AppointmentTest.assertTrue((String)"response object is not an array", (boolean)isArray);
        JSONArray jsonArray = (JSONArray)response.getData();
        boolean[] hasAppointments = new boolean[jsonArray.length()];
        for (int a = 0; a < hasAppointments.length; ++a) {
            hasAppointments[a] = jsonArray.getBoolean(a);
        }
        return hasAppointments;
    }

    public static Appointment[] getFreeBusy(WebConversation webCon, int particiantId, int type, Date start, Date end, TimeZone userTimeZone, String host, String session) throws Exception {
        host = AppointmentTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("id", particiantId);
        parameter.setParameter("type", type);
        parameter.setParameter("action", "freebusy");
        parameter.setParameter("start", start);
        parameter.setParameter("end", end);
        GetMethodWebRequest req = new GetMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AppointmentTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = ResponseParser.parse((String)resp.getText());
        if (response.hasError()) {
            AppointmentTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        boolean isArray = response.getData() instanceof JSONArray;
        AppointmentTest.assertTrue((String)"response object is not an array", (boolean)isArray);
        JSONArray jsonArray = (JSONArray)response.getData();
        return AppointmentTest.jsonArray2AppointmentArray(jsonArray, userTimeZone);
    }

    private static Appointment[] jsonArray2AppointmentArray(JSONArray jsonArray, TimeZone userTimeZone) throws Exception {
        Appointment[] appointmentArray = new Appointment[jsonArray.length()];
        AppointmentParser appointmentParser = new AppointmentParser(userTimeZone);
        for (int a = 0; a < appointmentArray.length; ++a) {
            appointmentArray[a] = new Appointment();
            JSONObject jObj = jsonArray.getJSONObject(a);
            appointmentParser.parse(appointmentArray[a], jObj);
        }
        return appointmentArray;
    }

    public static Appointment[] jsonArray2AppointmentArray(JSONArray jsonArray, int[] cols, TimeZone userTimeZone) throws JSONException, OXException {
        Appointment[] appointmentArray = new Appointment[jsonArray.length()];
        for (int a = 0; a < appointmentArray.length; ++a) {
            appointmentArray[a] = new Appointment();
            AppointmentTest.parseCols(cols, jsonArray.getJSONArray(a), appointmentArray[a], userTimeZone);
            if (appointmentArray[a].getFullTime()) continue;
            Date startDate = appointmentArray[a].getStartDate();
            Date endDate = appointmentArray[a].getEndDate();
            if (startDate == null || endDate == null) continue;
            int startOffset = userTimeZone.getOffset(startDate.getTime());
            int endOffset = userTimeZone.getOffset(endDate.getTime());
            appointmentArray[a].setStartDate(new Date(startDate.getTime() - (long)startOffset));
            appointmentArray[a].setEndDate(new Date(endDate.getTime() - (long)endOffset));
        }
        return appointmentArray;
    }

    private static void parseCols(int[] cols, JSONArray jsonArray, Appointment appointmentObj, TimeZone userTimeZone) throws JSONException, OXException {
        if (cols.length != jsonArray.length()) {
            LOG.debug("expected cols: " + StringCollection.convertArray2String((int[])cols) + " recieved cols: " + jsonArray.toString());
        }
        AppointmentTest.assertEquals((String)"compare array size with cols size", (int)cols.length, (int)jsonArray.length());
        for (int a = 0; a < cols.length; ++a) {
            AppointmentTest.parse(a, cols[a], jsonArray, appointmentObj, userTimeZone);
        }
    }

    private static void parse(int pos, int field, JSONArray jsonArray, Appointment appointmentObj, TimeZone userTimeZone) throws JSONException, OXException {
        switch (field) {
            case 1: {
                appointmentObj.setObjectID(jsonArray.getInt(pos));
                break;
            }
            case 20: {
                appointmentObj.setParentFolderID(jsonArray.getInt(pos));
                break;
            }
            case 200: {
                appointmentObj.setTitle(jsonArray.getString(pos));
                break;
            }
            case 4: {
                appointmentObj.setCreationDate(new Date(jsonArray.getLong(pos)));
                break;
            }
            case 5: {
                appointmentObj.setLastModified(new Date(jsonArray.getLong(pos)));
                break;
            }
            case 201: {
                appointmentObj.setStartDate(new Date(jsonArray.getLong(pos)));
                break;
            }
            case 202: {
                appointmentObj.setEndDate(new Date(jsonArray.getLong(pos)));
                break;
            }
            case 402: {
                appointmentObj.setShownAs(jsonArray.getInt(pos));
                break;
            }
            case 400: {
                appointmentObj.setLocation(jsonArray.getString(pos));
                break;
            }
            case 401: {
                appointmentObj.setFullTime(jsonArray.getBoolean(pos));
                break;
            }
            case 101: {
                appointmentObj.setPrivateFlag(jsonArray.getBoolean(pos));
                break;
            }
            case 100: {
                appointmentObj.setCategories(jsonArray.getString(pos));
                break;
            }
            case 102: {
                appointmentObj.setLabel(jsonArray.getInt(pos));
                break;
            }
            case 203: {
                appointmentObj.setNote(jsonArray.getString(pos));
                break;
            }
            case 207: {
                if (jsonArray.isNull(pos)) break;
                appointmentObj.setRecurrencePosition(jsonArray.getInt(pos));
                break;
            }
            case 209: {
                if (jsonArray.isNull(pos)) break;
                appointmentObj.setRecurrenceType(jsonArray.getInt(pos));
                break;
            }
            case 206: {
                if (jsonArray.isNull(pos)) break;
                appointmentObj.setRecurrenceID(jsonArray.getInt(pos));
                break;
            }
            case 215: {
                if (jsonArray.isNull(pos)) break;
                appointmentObj.setInterval(jsonArray.getInt(pos));
                break;
            }
            case 212: {
                if (jsonArray.isNull(pos)) break;
                appointmentObj.setDays(jsonArray.getInt(pos));
                break;
            }
            case 213: {
                if (jsonArray.isNull(pos)) break;
                appointmentObj.setDayInMonth(jsonArray.getInt(pos));
                break;
            }
            case 214: {
                if (jsonArray.isNull(pos)) break;
                appointmentObj.setMonth(jsonArray.getInt(pos));
                break;
            }
            case 216: {
                if (jsonArray.isNull(pos)) break;
                appointmentObj.setUntil(new Date(jsonArray.getLong(pos)));
                break;
            }
            case 222: {
                if (jsonArray.isNull(pos)) break;
                appointmentObj.setOccurrence(jsonArray.getInt(pos));
                break;
            }
            case 408: {
                if (jsonArray.isNull(pos)) break;
                appointmentObj.setTimezone(jsonArray.getString(pos));
                break;
            }
            case 410: {
                if (jsonArray.isNull(pos)) break;
                appointmentObj.setRecurringStart(jsonArray.getLong(pos));
                break;
            }
            case 220: {
                appointmentObj.setParticipants(AppointmentTest.parseParticipants(jsonArray.getJSONArray(pos)));
                break;
            }
            case 221: {
                appointmentObj.setUsers(AppointmentTest.parseUserParticipants(jsonArray.getJSONArray(pos)));
                break;
            }
            case 210: {
                if (jsonArray.isNull(pos)) break;
                JSONArray changeExceptions = jsonArray.getJSONArray(pos);
                appointmentObj.setChangeExceptions(AppointmentTest.parseExceptions(changeExceptions));
                break;
            }
            case 211: {
                if (jsonArray.isNull(pos)) break;
                JSONArray deleteExceptions = jsonArray.getJSONArray(pos);
                appointmentObj.setDeleteExceptions(AppointmentTest.parseExceptions(deleteExceptions));
                break;
            }
            case 224: {
                appointmentObj.setOrganizer(jsonArray.getString(pos));
                break;
            }
            case 223: {
                appointmentObj.setUid(jsonArray.getString(pos));
                break;
            }
            case 225: {
                appointmentObj.setSequence(jsonArray.getInt(pos));
            }
        }
    }

    private static Date[] parseExceptions(JSONArray jsonArray) throws JSONException {
        Date[] exceptions = new Date[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            exceptions[i] = new Date(jsonArray.getLong(i));
        }
        return exceptions;
    }

    private static UserParticipant[] parseUserParticipants(JSONArray userParticipantArr) throws JSONException {
        LinkedList<UserParticipant> userParticipants = new LinkedList<UserParticipant>();
        int size = userParticipantArr.length();
        for (int i = 0; i < size; ++i) {
            JSONObject participantObj = userParticipantArr.getJSONObject(i);
            userParticipants.add(new UserParticipant(participantObj.getInt("id")));
        }
        return userParticipants.toArray(new UserParticipant[userParticipants.size()]);
    }

    private static Participant[] parseParticipants(JSONArray jsonArray) throws JSONException, OXException {
        Participant[] participant = new Participant[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jparticipant = jsonArray.getJSONObject(i);
            int type = jparticipant.getInt("type");
            int id = jparticipant.has("id") ? jparticipant.getInt("id") : -1;
            String mail = jparticipant.optString("mail");
            GroupParticipant p = null;
            switch (type) {
                case 1: {
                    if (-1 == id) {
                        throw new JSONException("JSONObject[id] not found.");
                    }
                    UserParticipant user = new UserParticipant(id);
                    p = user;
                    break;
                }
                case 2: {
                    if (-1 == id) {
                        throw new JSONException("JSONObject[id] not found.");
                    }
                    p = new GroupParticipant(id);
                    break;
                }
                case 3: {
                    if (-1 == id) {
                        throw new JSONException("JSONObject[id] not found.");
                    }
                    p = new ResourceParticipant(id);
                    break;
                }
                case 4: {
                    if (-1 == id) {
                        throw new JSONException("JSONObject[id] not found.");
                    }
                    p = new ResourceGroupParticipant(id);
                    break;
                }
                case 5: {
                    if (null == mail) {
                        throw new JSONException("JSONObject[mail] not found.");
                    }
                    p = new ExternalUserParticipant(mail);
                    break;
                }
                default: {
                    throw new OXException().setLogMessage("invalidType");
                }
            }
            participant[i] = p;
        }
        return participant;
    }

    private HashSet participants2String(Participant[] participant) throws Exception {
        if (participant == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        for (int a = 0; a < participant.length; ++a) {
            hs.add(this.participant2String(participant[a]));
        }
        return hs;
    }

    private String participant2String(Participant p) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("T" + p.getType());
        sb.append("ID" + p.getIdentifier());
        sb.append("E" + p.getEmailAddress());
        sb.append("D" + p.getDisplayName());
        return sb.toString();
    }

    protected void create(Appointment appointment) throws JSONException, IOException, SAXException, OXException {
        InsertRequest insert = new InsertRequest(appointment, TimeZones.UTC, true);
        this.getClient().execute(insert).fillAppointment(appointment);
        this.clean.add(appointment);
    }

    protected void clean() throws JSONException, IOException, SAXException, OXException {
        AJAXClient client = this.getClient();
        for (Appointment appointment : this.clean) {
            DeleteRequest delete = new DeleteRequest(appointment);
            client.execute(delete);
        }
    }

    protected AJAXClient getClient() throws JSONException, IOException, OXException {
        return new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()), false);
    }

    protected Appointment link(Appointment base, Appointment update) {
        update.setLastModified(base.getLastModified());
        update.setParentFolderID(base.getParentFolderID());
        update.setObjectID(base.getObjectID());
        return update;
    }
}

