/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import com.openexchange.user.json.actions.AbstractUserAction;
import com.openexchange.user.json.services.ServiceRegistry;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="setAttribute", description="Set user attribute (available with v6.20).", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="ID of the user."), @Parameter(name="setIfAbsent", description="Set to \"true\" to put the value only if the specified name is not already associated with a value, otherwise \"false\" to put value in any case.")}, requestBody="A JSON object providing name and value of the attribute. If the \"value\" field id missing or NULL, the attribute is removed.", responseDescription="The boolean value \"true\" if PUT was successful; otherwise \"false\".")
public final class SetAttributeAction
extends AbstractUserAction {
    public static final String ACTION = "setAttribute";

    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        try {
            String prevValue;
            int id = SetAttributeAction.checkIntParameter("id", request);
            boolean setIfAbsent = Boolean.parseBoolean(request.getParameter("setIfAbsent"));
            UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
            JSONObject jData = (JSONObject)request.requireData();
            String name = jData.getString("name");
            Context context = session.getContext();
            if (setIfAbsent && null != (prevValue = userService.getUserAttribute(name, id, context))) {
                return new AJAXRequestResult((Object)Boolean.FALSE);
            }
            Object tmp = jData.opt("value");
            String value = null == tmp ? null : (JSONObject.NULL.equals(tmp) ? null : tmp.toString());
            userService.setUserAttribute(name, value, id, context);
            return new AJAXRequestResult((Object)Boolean.TRUE);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

