/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.contact.ContactService;
import com.openexchange.contact.SortOptions;
import com.openexchange.contact.SortOrder;
import com.openexchange.contacts.json.mapping.ContactMapper;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.Type;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.groupware.search.Order;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import com.openexchange.user.json.UserContact;
import com.openexchange.user.json.actions.AbstractUserAction;
import com.openexchange.user.json.field.UserField;
import com.openexchange.user.json.filter.UserCensorship;
import com.openexchange.user.json.mapping.UserMapper;
import com.openexchange.user.json.services.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

@Action(method=RequestMethod.GET, name="all", description="Get all users.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for users are defined in Common object data, Detailed contact data and Detailed user data."), @Parameter(name="sort", optional=true, type=Type.NUMBER, description="The identifier of a column which determines the sort order of the response. If this parameter is specified, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified.")}, responseDescription="Response with timestamp: An array with user data. Each array element describes one user and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public final class AllAction
extends AbstractUserAction {
    public static final String ACTION = "all";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        ContactField orderByContactField;
        int[] columns = AllAction.parseIntArrayParameter("columns", request);
        int orderBy = AllAction.parseIntParameter("sort", request);
        Order order = OrderFields.parse((String)request.getParameter("order"));
        int leftHandLimit = AllAction.parseIntParameter("left_hand_limit", request);
        int rightHandLimit = AllAction.parseIntParameter("right_hand_limit", request);
        int lhl = leftHandLimit < 0 ? 0 : leftHandLimit;
        int rhl = rightHandLimit <= 0 ? 50000 : rightHandLimit;
        SortOptions sortOptions = new SortOptions(lhl, rhl - lhl);
        UserField orderByUserField = (UserField)UserMapper.getInstance().getMappedField(orderBy);
        if (null == orderByUserField && null != (orderByContactField = (ContactField)ContactMapper.getInstance().getMappedField(orderBy))) {
            sortOptions.setOrderBy(new SortOrder[]{SortOptions.Order((ContactField)orderByContactField, (Order)order)});
        }
        Date lastModified = new Date(0L);
        ArrayList<UserContact> userContacts = new ArrayList<UserContact>();
        ContactService contactService = (ContactService)ServiceRegistry.getInstance().getService(ContactService.class);
        ContactField[] contactFields = (ContactField[])ContactMapper.getInstance().getFields(columns, (Enum[])new ContactField[]{ContactField.INTERNAL_USERID, ContactField.LAST_MODIFIED});
        UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
        UserField[] userFields = (UserField[])UserMapper.getInstance().getFields(columns);
        boolean needsUserData = null != userFields && 0 < userFields.length;
        UserCensorship censorship = needsUserData ? AllAction.getUserCensorship(session) : null;
        SearchIterator searchIterator = null;
        try {
            searchIterator = contactService.getAllUsers((Session)session, contactFields, sortOptions);
            while (searchIterator.hasNext()) {
                User user;
                Contact contact = (Contact)searchIterator.next();
                if (contact.getLastModified().after(lastModified)) {
                    lastModified = contact.getLastModified();
                }
                if (needsUserData) {
                    user = userService.getUser(contact.getInternalUserId(), session.getContext());
                    if (null != censorship && session.getUserId() != user.getId()) {
                        user = censorship.censor(user);
                    }
                } else {
                    UserImpl placeholder = new UserImpl();
                    placeholder.setId(contact.getInternalUserId());
                    user = placeholder;
                }
                userContacts.add(new UserContact(contact, user));
            }
        }
        finally {
            if (null != searchIterator) {
                searchIterator.close();
            }
        }
        if (1 < userContacts.size() && null != orderByUserField) {
            Collections.sort(userContacts, UserContact.getComparator(orderByUserField, session.getUser().getLocale(), Order.DESCENDING.equals((Object)order)));
        }
        return new AJAXRequestResult(userContacts, lastModified, "usercontact");
    }
}

