/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.osgi;

import com.openexchange.management.ManagementService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.internal.ThreadPoolInformation;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagementServiceTrackerCustomizer
implements ServiceTrackerCustomizer<ManagementService, ManagementService> {
    private final BundleContext context;
    private final ThreadPoolService threadPoolService;
    private ObjectName objectName;

    public ManagementServiceTrackerCustomizer(BundleContext context, ThreadPoolService threadPoolService) {
        this.context = context;
        this.threadPoolService = threadPoolService;
    }

    public ManagementService addingService(ServiceReference<ManagementService> reference) {
        ManagementService service = (ManagementService)this.context.getService(reference);
        this.registerCacheMBean(service);
        return service;
    }

    public void modifiedService(ServiceReference<ManagementService> reference, ManagementService service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<ManagementService> reference, ManagementService service) {
        if (null != service) {
            try {
                this.unregisterCacheMBean(service);
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }

    void registerCacheMBean(ManagementService management) {
        if (this.objectName == null) {
            Logger LOG = LoggerFactory.getLogger(ManagementServiceTrackerCustomizer.class);
            try {
                this.objectName = ManagementServiceTrackerCustomizer.getObjectName(ThreadPoolInformation.class.getName(), "com.openexchange.threadpool");
                management.registerMBean(this.objectName, (Object)new ThreadPoolInformation(this.threadPoolService));
            }
            catch (MalformedObjectNameException e) {
                LOG.error("", (Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                LOG.error("", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterCacheMBean(ManagementService management) {
        if (this.objectName != null) {
            try {
                management.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ManagementServiceTrackerCustomizer.class).error("", (Throwable)e);
            }
            finally {
                this.objectName = null;
            }
        }
    }

    private static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }
}

