/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.java.StringAllocator;
import com.openexchange.threadpool.internal.CustomThread;
import com.openexchange.threadpool.internal.MasterThreadFactory;
import com.openexchange.threadpool.internal.ThreadCreateCallable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomThreadFactory
implements ThreadFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CustomThreadFactory.class);
    private final AtomicInteger threadNumber = new AtomicInteger();
    private final String namePrefix;
    private final ExecutorService threadCreatorService;

    public CustomThreadFactory(String namePrefix) {
        this.namePrefix = namePrefix;
        this.threadCreatorService = Executors.newSingleThreadExecutor(new MasterThreadFactory(namePrefix));
    }

    @Override
    public CustomThread newThread(Runnable r) {
        int threadNum = this.threadNumber.incrementAndGet();
        if (threadNum <= 0) {
            boolean check = false;
            do {
                if (this.threadNumber.compareAndSet(threadNum, 1)) {
                    threadNum = 1;
                    continue;
                }
                threadNum = this.threadNumber.get();
                check = true;
            } while (threadNum <= 0);
            if (check && 1 == threadNum) {
                threadNum = this.threadNumber.incrementAndGet();
            }
        }
        try {
            return this.createThreadWithMaster(r, threadNum);
        }
        catch (InterruptedException e) {
            LOG.error("Single thread pool for creating threads was interrupted.", (Throwable)e);
            return null;
        }
        catch (ExecutionException e) {
            LOG.error("Single thread pool for creating threads catched an exception while creating one.", (Throwable)e);
            return null;
        }
    }

    private static String getThreadName(int threadNumber, String namePrefix) {
        StringAllocator retval = new StringAllocator(namePrefix.length() + 7);
        retval.append(namePrefix);
        for (int i = threadNumber; i < 1000000; i *= 10) {
            retval.append('0');
        }
        retval.append(threadNumber);
        return retval.toString();
    }

    private CustomThread createThreadWithMaster(Runnable r, int threadNum) throws InterruptedException, ExecutionException {
        ThreadCreateCallable callable = new ThreadCreateCallable(r, CustomThreadFactory.getThreadName(threadNum, this.namePrefix));
        Future<CustomThread> future = this.threadCreatorService.submit(callable);
        return future.get();
    }
}

