/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderChildObject;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.webdav.xml.DataWriter;
import java.io.OutputStream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderChildWriter
extends DataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(FolderChildWriter.class);

    protected void writeFolderChildElements(FolderChildObject folderchildobject, Element e_prop) {
        this.writeDataElements(folderchildobject, e_prop);
        if (folderchildobject.containsParentFolderID()) {
            FolderChildWriter.addElement("folder_id", folderchildobject.getParentFolderID(), e_prop);
        }
    }

    public void writeList(SearchIterator<? extends DataObject> searchIterator, XMLOutputter xo, OutputStream os) throws Exception {
        int status = 200;
        String description = "OK";
        int object_id = 0;
        Element eProp = new Element("prop", "D", "DAV:");
        try {
            FolderChildWriter.addElement("object_status", "LIST", eProp);
            Element eIds = new Element("object_list", namespace);
            while (searchIterator.hasNext()) {
                FolderChildWriter.addElement("id", ((DataObject)searchIterator.next()).getObjectID(), eIds);
            }
            eProp.addContent((Content)eIds);
        }
        catch (Exception exc) {
            LOG.error("writeList", (Throwable)exc);
            status = 500;
            description = "Server Error: " + exc.getMessage();
            object_id = 0;
        }
        this.writeResponseElement(eProp, object_id, status, description, xo, os);
    }
}

