/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.impl;

import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.impl.DummyCollection;
import com.openexchange.webdav.protocol.impl.DummyLockNull;
import com.openexchange.webdav.protocol.impl.DummyResource;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DummyResourceManager
implements WebdavFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DummyResourceManager.class);
    private static final DummyResourceManager INSTANCE = new DummyResourceManager();
    private static final Protocol PROTOCOL = new Protocol();
    private final Map<WebdavPath, WebdavResource> resources = new HashMap<WebdavPath, WebdavResource>();
    private final Map<WebdavPath, DummyLockNull> lockNullResources = new HashMap<WebdavPath, DummyLockNull>();

    public static DummyResourceManager getInstance() {
        return INSTANCE;
    }

    private DummyResourceManager() {
        try {
            this.resolveCollection("/").create();
        }
        catch (WebdavProtocolException e) {
            LOG.error("Can't resolve root", (Throwable)((Object)e));
        }
    }

    @Override
    public WebdavResource resolveResource(WebdavPath url) {
        if (!this.resources.containsKey(url)) {
            if (this.lockNullResources.containsKey(url)) {
                DummyLockNull lockNull = this.lockNullResources.get(url);
                lockNull.setRealResource(new DummyResource(this, url));
                return lockNull;
            }
            return new DummyResource(this, url);
        }
        return this.resources.get(url);
    }

    @Override
    public WebdavCollection resolveCollection(WebdavPath url) {
        if (!this.resources.containsKey(url)) {
            if (this.lockNullResources.containsKey(url)) {
                DummyLockNull lockNull = this.lockNullResources.get(url);
                lockNull.setRealResource(new DummyCollection(this, url));
                return lockNull;
            }
            return new DummyCollection(this, url);
        }
        return (WebdavCollection)this.resources.get(url);
    }

    @Override
    public WebdavResource resolveResource(String url) {
        return this.resolveResource(new WebdavPath((CharSequence)url));
    }

    @Override
    public WebdavCollection resolveCollection(String url) {
        return this.resolveCollection(new WebdavPath((CharSequence)url));
    }

    public synchronized void save(WebdavPath url, DummyResource res) {
        this.getParent(url).addChild(res);
        this.resources.put(url, res);
    }

    public void remove(WebdavPath url, DummyResource res) {
        this.getParent(url).removeChild(res);
        this.resources.remove(url);
    }

    private DummyCollection getParent(WebdavPath url) {
        return (DummyCollection)this.resolveCollection(url.parent());
    }

    private String normalize(String url) {
        while (url.contains("//")) {
            url = url.replaceAll("//", "/");
        }
        return url;
    }

    @Override
    public Protocol getProtocol() {
        return PROTOCOL;
    }

    public WebdavResource addLockNullResource(DummyResource resource) {
        DummyLockNull lockNull = new DummyLockNull(this, resource.getUrl());
        lockNull.setExists(true);
        this.lockNullResources.put(lockNull.getUrl(), lockNull);
        return lockNull;
    }

    public void removeLockNull(WebdavPath url) {
        this.lockNullResources.remove(url);
    }

    @Override
    public void beginRequest() {
    }

    @Override
    public void endRequest(int status) {
    }
}

