/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.data.conversion.ical.ICalEmitter;
import com.openexchange.data.conversion.ical.ICalItem;
import com.openexchange.data.conversion.ical.ICalSession;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.login.Interface;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.webdav.PermissionServlet;
import com.openexchange.webdav.WebdavExceptionCode;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ical
extends PermissionServlet {
    private static final long serialVersionUID = 8198514314235297665L;
    private static final transient Logger LOG = LoggerFactory.getLogger(ical.class);
    private static final int[] APPOINTMENT_FIELDS = new int[]{1, 2, 3, 4, 5, 20, 100, 101, 102, 200, 201, 202, 203, 206, 209, 220, 221, 400, 401, 402, 408};
    private static final int[] TASK_FIELDS = new int[]{1, 2, 4, 5, 3, 20, 101, 100, 200, 201, 202, 203, 209, 222, 216, 220, 302, 303, 204, 305, 100, 314, 312, 315, 2, 301, 309, 300, 307, 308, 313, 102};
    private static final String CALENDARFOLDER = "calendarfolder";
    private static final String TASKFOLDER = "taskfolder";
    private static final String SQL_PRINCIPAL_SELECT = "SELECT object_id, calendarfolder, taskfolder FROM ical_principal WHERE cid = ? AND principal = ?";
    private static final String SQL_PRINCIPAL_INSERT = "INSERT INTO ical_principal (object_id,cid,principal,calendarfolder,taskfolder) VALUES (?,?,?,?,?)";
    private static final String SQL_PRINCIPAL_UPDATE = "UPDATE ical_principal SET calendarfolder=?,taskfolder=? WHERE cid=? AND object_id=?";
    private static final TObjectProcedure<SeriesUIDPatcher> PATCH_PROCEDURE = new TObjectProcedure<SeriesUIDPatcher>(){

        public boolean execute(SeriesUIDPatcher patcher) {
            patcher.patchUIDs();
            return true;
        }
    };

    @Override
    protected Interface getInterface() {
        return Interface.WEBDAV_ICAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOG.debug("GET");
        Session sessionObj = ical.getSession(req);
        try {
            Context context = ContextStorage.getInstance().getContext(sessionObj.getContextId());
            User user = UserStorage.getInstance().getUser(sessionObj.getUserId(), context);
            int calendarfolderId = this.getCalendarFolderID(req);
            int taskfolderId = this.getTaskFolderID(req);
            if (calendarfolderId == 0 && taskfolderId == 0) {
                OXFolderAccess oAccess = new OXFolderAccess(context);
                calendarfolderId = oAccess.getDefaultFolder(user.getId(), 2).getObjectID();
                taskfolderId = oAccess.getDefaultFolder(user.getId(), 1).getObjectID();
            }
            String user_agent = this.getUserAgent(req);
            String principalS = user_agent + '_' + sessionObj.getUserId();
            Principal principal = this.loadPrincipal(context, principalS);
            ICalEmitter emitter = ServerServiceRegistry.getInstance().getService(ICalEmitter.class);
            if (null == emitter) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ICalEmitter.class.getName()});
            }
            ICalSession iSession = emitter.createSession();
            LinkedList<ConversionWarning> warnings = new LinkedList<ConversionWarning>();
            LinkedList<ConversionError> errors = new LinkedList<ConversionError>();
            AppointmentSQLInterface appointmentSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(sessionObj);
            CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
            SearchIterator<Appointment> iter = null;
            try {
                TIntObjectHashMap patchers = new TIntObjectHashMap();
                iter = appointmentSql.getModifiedAppointmentsInFolder(calendarfolderId, APPOINTMENT_FIELDS, new Date(0L));
                while (iter.hasNext()) {
                    Appointment appointment = (Appointment)iter.next();
                    if (0 != appointment.getRecurrenceType()) {
                        if (!appointment.containsTimezone()) {
                            appointment.setTimezone(user.getTimeZone());
                        }
                        recColl.replaceDatesWithFirstOccurence(appointment);
                    }
                    ICalItem item = emitter.writeAppointment(iSession, appointment, context, errors, warnings);
                    if (!appointment.isMaster() && !appointment.isException()) continue;
                    int recurrenceId = appointment.getRecurrenceID();
                    SeriesUIDPatcher patcher = (SeriesUIDPatcher)patchers.get(recurrenceId);
                    if (null == patcher) {
                        patcher = new SeriesUIDPatcher();
                        patchers.put(recurrenceId, (Object)patcher);
                    }
                    if (appointment.isMaster()) {
                        patcher.setSeries(item);
                        continue;
                    }
                    if (!appointment.isException()) continue;
                    patcher.addChangeException(item);
                }
                patchers.forEachValue(PATCH_PROCEDURE);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            finally {
                if (null != iter) {
                    try {
                        iter.close();
                    }
                    catch (OXException e) {
                        LOG.error("", (Throwable)e);
                    }
                }
            }
            TasksSQLImpl taskInterface = new TasksSQLImpl(sessionObj);
            SearchIterator<Task> itTask = null;
            try {
                itTask = taskInterface.getModifiedTasksInFolder(taskfolderId, TASK_FIELDS, new Date(0L));
                while (itTask.hasNext()) {
                    Task task = (Task)itTask.next();
                    emitter.writeTask(iSession, task, context, errors, warnings);
                }
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            finally {
                if (null != itTask) {
                    try {
                        itTask.close();
                    }
                    catch (OXException e) {
                        LOG.error("", (Throwable)e);
                    }
                }
            }
            resp.setStatus(200);
            resp.setContentType("text/calendar");
            try {
                emitter.writeSession(iSession, (OutputStream)resp.getOutputStream());
            }
            catch (ConversionError e) {
                LOG.error("", (Throwable)((Object)e));
            }
            if (null == principal) {
                principal = new Principal(0, principalS, calendarfolderId, taskfolderId);
                this.insertPrincipal(context, principal);
            } else if (principal.getCalendarFolder() != calendarfolderId || principal.getTaskFolder() != taskfolderId) {
                principal.setCalendarFolder(calendarfolderId);
                principal.setTaskFolder(taskfolderId);
                this.updatePrincipal(context, principal);
            }
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            this.doError(resp, 500, e.getMessage());
        }
        catch (ServiceException e) {
            LOG.error("", (Throwable)e);
            this.doError(resp, 500, e.getMessage());
        }
    }

    private void doError(HttpServletResponse resp, int code, String msg) throws IOException {
        resp.setStatus(code);
        resp.setContentType("text/html; ; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write("<html><body>" + msg + "</body></html>");
    }

    private String getUserAgent(HttpServletRequest req) throws OXException {
        Enumeration e = req.getHeaderNames();
        String userAgent = "user-agent";
        while (e.hasMoreElements()) {
            if (!"user-agent".equals(e.nextElement().toString().toLowerCase())) continue;
            return req.getHeader("user-agent");
        }
        throw WebdavExceptionCode.MISSING_HEADER_FIELD.create("user-agent");
    }

    private int getCalendarFolderID(HttpServletRequest req) throws OXException {
        if (req.getParameter(CALENDARFOLDER) != null) {
            try {
                return Integer.parseInt(req.getParameter(CALENDARFOLDER));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.NOT_A_NUMBER.create(exc, CALENDARFOLDER);
            }
        }
        return 0;
    }

    private int getTaskFolderID(HttpServletRequest req) throws OXException {
        if (req.getParameter(TASKFOLDER) != null) {
            try {
                return Integer.parseInt(req.getParameter(TASKFOLDER));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.NOT_A_NUMBER.create(exc, TASKFOLDER);
            }
        }
        return 0;
    }

    private Principal loadPrincipal(Context ctx, String userAgent) throws OXException {
        Principal retval;
        Connection con = DBPool.pickup(ctx);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(SQL_PRINCIPAL_SELECT);
            ps.setLong(1, ctx.getContextId());
            ps.setString(2, userAgent);
            rs = ps.executeQuery();
            retval = rs.next() ? new Principal(rs.getInt(1), userAgent, rs.getInt(2), rs.getInt(3)) : null;
        }
        catch (SQLException e) {
            try {
                throw WebdavExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, ps);
                DBPool.closeReaderSilent(ctx, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, ps);
        DBPool.closeReaderSilent(ctx, con);
        return retval;
    }

    private void insertPrincipal(Context ctx, Principal principal) throws OXException {
        Connection con = DBPool.pickupWriteable(ctx);
        PreparedStatement ps = null;
        try {
            con.setAutoCommit(false);
            principal.setId(IDGenerator.getId(ctx, 75, con));
            ps = con.prepareStatement(SQL_PRINCIPAL_INSERT);
            ps.setInt(1, principal.getId());
            ps.setLong(2, ctx.getContextId());
            ps.setString(3, principal.getUserAgent());
            ps.setInt(4, principal.getCalendarFolder());
            ps.setInt(5, principal.getTaskFolder());
            ps.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw WebdavExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, ps);
                DBUtils.autocommit(con);
                DBPool.closeWriterSilent(ctx, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, ps);
        DBUtils.autocommit(con);
        DBPool.closeWriterSilent(ctx, con);
    }

    private void updatePrincipal(Context ctx, Principal principal) throws OXException {
        Connection con = DBPool.pickupWriteable(ctx);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(SQL_PRINCIPAL_UPDATE);
            ps.setInt(1, principal.getCalendarFolder());
            ps.setInt(2, principal.getTaskFolder());
            ps.setInt(3, ctx.getContextId());
            ps.setInt(4, principal.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw WebdavExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, ps);
            DBPool.closeWriterSilent(ctx, con);
        }
    }

    @Override
    protected boolean hasModulePermission(Session sessionObj, Context ctx) {
        UserConfiguration uc = UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx);
        return uc.hasICal() && uc.hasCalendar() && uc.hasTask();
    }

    @Override
    protected void decrementRequests() {
    }

    @Override
    protected void incrementRequests() {
    }

    private static final class Principal {
        private int id;
        private final String userAgent;
        private int calendarFolder;
        private int taskFolder;

        public Principal(int id, String userAgent, int calendarFolder, int taskFolder) {
            this.id = id;
            this.userAgent = userAgent;
            this.calendarFolder = calendarFolder;
            this.taskFolder = taskFolder;
        }

        int getId() {
            return this.id;
        }

        void setId(int id) {
            this.id = id;
        }

        String getUserAgent() {
            return this.userAgent;
        }

        int getCalendarFolder() {
            return this.calendarFolder;
        }

        void setCalendarFolder(int calendarFolder) {
            this.calendarFolder = calendarFolder;
        }

        int getTaskFolder() {
            return this.taskFolder;
        }

        void setTaskFolder(int taskFolder) {
            this.taskFolder = taskFolder;
        }
    }

    private static final class SeriesUIDPatcher {
        private ICalItem series;
        private final List<ICalItem> changeExceptions = new ArrayList<ICalItem>();

        public void setSeries(ICalItem series) {
            this.series = series;
        }

        public void addChangeException(ICalItem changeException) {
            this.changeExceptions.add(changeException);
        }

        public void patchUIDs() {
            if (null == this.series) {
                return;
            }
            String uid = this.series.getUID();
            if (null == uid) {
                uid = UUID.randomUUID().toString();
                this.series.setUID(uid);
            }
            for (ICalItem changeException : this.changeExceptions) {
                changeException.setUID(uid);
            }
        }
    }
}

