/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.Attachments;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.login.Interface;
import com.openexchange.monitoring.MonitoringInfo;
import com.openexchange.session.Session;
import com.openexchange.tools.webdav.OXServlet;
import com.openexchange.tx.TransactionException;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.DataWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Date;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class attachments
extends OXServlet {
    private static final long serialVersionUID = -7811800176537415542L;
    public static final String LAST_MODIFIED = "last_modified";
    public static final String MODULE = "module";
    public static final String FILENAME = "filename";
    public static final String MIME_TYPE = "mimetype";
    public static final String TARGET_ID = "target_id";
    public static final String TARGET_FOLDER_ID = "target_folder_id";
    public static final String RTF_FLAG = "rtf_flag";
    private static final String DAV = "DAV:";
    public static final String NAMESPACE = "http://www.open-xchange.org";
    public static final String PREFIX = "ox";
    private static final transient AttachmentBase ATTACHMENT_BASE = Attachments.getInstance();
    private static final transient Logger LOG;

    @Override
    protected Interface getInterface() {
        return Interface.WEBDAV_XML;
    }

    @Override
    protected boolean isServletDisabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPut(HttpServletRequest req, HttpServletResponse resp) {
        String client_id = null;
        int objectId = 0;
        XMLOutputter xo = new XMLOutputter();
        Session sessionObj = null;
        try {
            sessionObj = attachments.getSession(req);
            client_id = req.getHeader("client_id");
            String filename = req.getHeader(FILENAME);
            if (filename != null) {
                filename = URLDecoder.decode(filename, "UTF-8");
            }
            int module = req.getIntHeader(MODULE);
            int targetId = req.getIntHeader(TARGET_ID);
            objectId = req.getIntHeader("object_id");
            int target_folder_id = req.getIntHeader(TARGET_FOLDER_ID);
            String sRtfFlag = req.getHeader(RTF_FLAG);
            boolean rtfFlag = sRtfFlag == null ? false : Boolean.parseBoolean(sRtfFlag);
            int fileSize = req.getContentLength();
            String mimeType = req.getContentType();
            ServletInputStream is = req.getInputStream();
            AttachmentImpl attachmentMeta = new AttachmentImpl();
            attachmentMeta.setAttachedId(targetId);
            attachmentMeta.setFolderId(target_folder_id);
            attachmentMeta.setRtfFlag(rtfFlag);
            attachmentMeta.setModuleId(module);
            attachmentMeta.setFilename(filename);
            attachmentMeta.setFileMIMEType(mimeType);
            attachmentMeta.setFilesize(fileSize);
            attachmentMeta.setId(req.getHeader("object_id") == null ? 0 : objectId);
            Context ctx = ContextStorage.getInstance().getContext(sessionObj.getContextId());
            ATTACHMENT_BASE.startTransaction();
            ATTACHMENT_BASE.attachToObject(attachmentMeta, (InputStream)is, sessionObj, ctx, UserStorage.getInstance().getUser(sessionObj.getUserId(), ctx), UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx));
            ATTACHMENT_BASE.commit();
            objectId = attachmentMeta.getId();
            Date lastModified = attachmentMeta.getCreationDate();
            Element e_multistatus = new Element("multistatus", "D", DAV);
            Document output_doc = new Document(e_multistatus);
            Element e_response = new Element("response", "D", DAV);
            e_response.addNamespaceDeclaration(Namespace.getNamespace((String)PREFIX, (String)NAMESPACE));
            Element e_href = new Element("href", "D", DAV);
            e_href.addContent(Integer.toString(objectId));
            e_response.addContent((Content)e_href);
            Element e_prop = new Element("prop", Namespace.getNamespace((String)"D", (String)DAV));
            Element e_propstat = new Element("propstat", "D", DAV);
            Element e_object_id = new Element("object_id", PREFIX, NAMESPACE);
            e_object_id.addContent(Integer.toString(objectId));
            e_prop.addContent((Content)e_object_id);
            Element e_lastmodified = new Element(LAST_MODIFIED, PREFIX, NAMESPACE);
            e_lastmodified.addContent(Long.toString(lastModified.getTime()));
            e_prop.addContent((Content)e_lastmodified);
            if (client_id != null && client_id.length() > 0) {
                Element e_client_id = new Element("client_id", PREFIX, NAMESPACE);
                e_client_id.addContent(DataWriter.correctCharacterData(client_id));
                e_prop.addContent((Content)e_client_id);
            }
            e_propstat.addContent((Content)e_prop);
            Element e_status = new Element("status", "D", DAV);
            e_status.addContent(Integer.toString(200));
            e_propstat.addContent((Content)e_status);
            Element e_descr = new Element("responsedescription", "D", DAV);
            e_descr.addContent("[1200] OK");
            e_propstat.addContent((Content)e_descr);
            e_response.addContent((Content)e_propstat);
            e_multistatus.addContent((Content)e_response);
            resp.setStatus(207);
            resp.setContentType("text/xml; charset=UTF-8");
            xo.output(output_doc, (OutputStream)resp.getOutputStream());
        }
        catch (TransactionException exc) {
            this.doError(resp, 500, exc.toString());
            LOG.error("", (Throwable)exc);
            exc.printStarterTrace();
            this.rollbackTransaction();
        }
        catch (OXException exc) {
            if (exc.getCategory() == Category.CATEGORY_PERMISSION_DENIED) {
                LOG.debug("", (Throwable)exc);
            } else {
                LOG.error("", (Throwable)exc);
            }
            this.doError(resp, 500, exc.toString());
            this.rollbackTransaction();
        }
        catch (Exception exc) {
            this.doError(resp, 500, exc.toString());
            LOG.error("doPut", (Throwable)exc);
            this.rollbackTransaction();
        }
        finally {
            this.finishTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        int target_id = 0;
        int object_id = 0;
        int folder_id = 0;
        int module = 0;
        ServletOutputStream os = null;
        Session sessionObj = null;
        try {
            sessionObj = attachments.getSession(req);
            os = resp.getOutputStream();
            if (req.getHeader(MODULE) == null) {
                throw WebdavExceptionCode.MISSING_FIELD.create(MODULE);
            }
            try {
                module = Integer.parseInt(req.getHeader(MODULE));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.NOT_A_NUMBER.create(exc, MODULE);
            }
            if (req.getHeader(TARGET_ID) == null) {
                throw WebdavExceptionCode.MISSING_FIELD.create(TARGET_ID);
            }
            try {
                target_id = Integer.parseInt(req.getHeader(TARGET_ID));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.NOT_A_NUMBER.create(exc, TARGET_ID);
            }
            if (req.getHeader("object_id") == null) {
                throw WebdavExceptionCode.MISSING_FIELD.create("object_id");
            }
            try {
                object_id = Integer.parseInt(req.getHeader("object_id"));
            }
            catch (NumberFormatException exc) {
                throw WebdavExceptionCode.NOT_A_NUMBER.create(exc, "object_id");
            }
            if (req.getHeader(TARGET_FOLDER_ID) != null) {
                try {
                    folder_id = Integer.parseInt(req.getHeader(TARGET_FOLDER_ID));
                }
                catch (NumberFormatException exc) {
                    throw WebdavExceptionCode.NOT_A_NUMBER.create(exc, TARGET_FOLDER_ID);
                }
            }
            ATTACHMENT_BASE.startTransaction();
            Context ctx = ContextStorage.getInstance().getContext(sessionObj.getContextId());
            User u = UserStorage.getInstance().getUser(sessionObj.getUserId(), ctx);
            AttachmentMetadata attachmentMeta = ATTACHMENT_BASE.getAttachment(sessionObj, folder_id, target_id, module, object_id, ctx, u, UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx));
            InputStream is = ATTACHMENT_BASE.getAttachedFile(sessionObj, folder_id, target_id, module, object_id, ctx, u, UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx));
            ATTACHMENT_BASE.commit();
            resp.setContentType(attachmentMeta.getFileMIMEType());
            byte[] b = new byte[8192];
            int i = is.read(b);
            while (i > 0) {
                os.write(b, 0, i);
                i = is.read(b);
            }
        }
        catch (OXException exc) {
            if (exc.isGeneric(OXException.Generic.CONFLICT)) {
                LOG.error("doGet", (Throwable)exc);
                this.doError(resp, 409, exc.toString());
            } else {
                LOG.error("doGet", (Throwable)exc);
                this.doError(resp, 500, "Server Error: " + exc.toString());
            }
            this.rollbackTransaction();
        }
        catch (Exception exc) {
            LOG.error("doGet", (Throwable)exc);
            this.doError(resp, 500, "Server Error: " + exc.toString());
            this.rollbackTransaction();
        }
        finally {
            this.finishTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(HttpServletRequest req, HttpServletResponse resp) {
        this.log("DELETE");
        Session sessionObj = null;
        try {
            sessionObj = attachments.getSession(req);
            Context ctx = ContextStorage.getInstance().getContext(sessionObj.getContextId());
            int objectId = req.getIntHeader("object_id");
            int module = req.getIntHeader(MODULE);
            int targetId = req.getIntHeader(TARGET_ID);
            int folderId = req.getIntHeader(TARGET_FOLDER_ID);
            ATTACHMENT_BASE.startTransaction();
            ATTACHMENT_BASE.detachFromObject(folderId, targetId, module, new int[]{objectId}, sessionObj, ctx, UserStorage.getInstance().getUser(sessionObj.getUserId(), ctx), UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx));
            ATTACHMENT_BASE.commit();
            resp.setStatus(200);
        }
        catch (OXException e) {
            if (e.isGeneric(OXException.Generic.CONFLICT)) {
                this.doError(resp, 409, e.toString());
                LOG.error("doDelete", (Throwable)e);
                this.rollbackTransaction();
            } else if (e.isGeneric(OXException.Generic.NOT_FOUND)) {
                this.doError(resp, 404, e.toString());
                this.rollbackTransaction();
            } else {
                this.doError(resp, 500, "Server Error: " + e.toString());
                LOG.error("doDelete", (Throwable)e);
                this.rollbackTransaction();
            }
        }
        catch (Exception exc) {
            this.doError(resp, 500, "Server Error: " + exc.toString());
            LOG.error("doDelete", (Throwable)exc);
            this.rollbackTransaction();
        }
        finally {
            this.finishTransaction();
        }
    }

    protected void doError(HttpServletResponse resp, int errorcode, String errormessage) {
        resp.setStatus(errorcode);
        this.log(errorcode + ": " + errormessage);
    }

    private void finishTransaction() {
        try {
            ATTACHMENT_BASE.finish();
        }
        catch (OXException exc) {
            LOG.error("finishTransaction", (Throwable)exc);
        }
    }

    private void rollbackTransaction() {
        try {
            ATTACHMENT_BASE.rollback();
        }
        catch (OXException exc) {
            LOG.error("finishTransaction", (Throwable)exc);
        }
    }

    @Override
    protected void decrementRequests() {
        MonitoringInfo.decrementNumberOfConnections((int)2);
    }

    @Override
    protected void incrementRequests() {
        MonitoringInfo.incrementNumberOfConnections((int)2);
    }

    static {
        ATTACHMENT_BASE.setTransactional(true);
        LOG = LoggerFactory.getLogger(attachments.class);
    }
}

