/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.webdav.action.AbstractWebdavRequest;
import com.openexchange.webdav.action.ApacheURLDecoder;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletWebdavRequest
extends AbstractWebdavRequest
implements WebdavRequest {
    private final HttpServletRequest req;
    private String urlPrefix;
    private final WebdavPath url;
    private WebdavPath destUrl;
    private final ApacheURLDecoder decoder = new ApacheURLDecoder();
    private static final Logger LOG = LoggerFactory.getLogger(ServletWebdavRequest.class);

    public ServletWebdavRequest(WebdavFactory factory, HttpServletRequest req) {
        super(factory);
        this.req = req;
        StringBuilder builder = new StringBuilder();
        builder.append(req.getServletPath());
        builder.append('/');
        this.urlPrefix = builder.toString();
        LOG.debug("WEBDAV URL PREFIX FROM CONTAINER: {}", (Object)this.urlPrefix);
        this.url = this.toWebdavURL(req.getRequestURI());
    }

    @Override
    public InputStream getBody() throws IOException {
        return this.req.getInputStream();
    }

    @Override
    public String getHeader(String header) {
        return this.req.getHeader(header);
    }

    @Override
    public List<String> getHeaderNames() {
        ArrayList<String> headers = new ArrayList<String>();
        Enumeration enumeration = this.req.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            headers.add(enumeration.nextElement().toString());
        }
        return headers;
    }

    @Override
    public String getURLPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    @Override
    public WebdavPath getUrl() {
        return this.url;
    }

    @Override
    public WebdavPath getDestinationUrl() {
        if (this.destUrl != null) {
            return this.destUrl;
        }
        this.destUrl = this.toWebdavURL(this.req.getHeader("destination"));
        return this.destUrl;
    }

    protected WebdavPath toWebdavURL(String url) {
        if (url == null) {
            return null;
        }
        if (!url.startsWith("/")) {
            try {
                URL urlO = new URL(url);
                url = urlO.getPath();
            }
            catch (MalformedURLException x) {
                LOG.debug("", (Throwable)x);
            }
        }
        if (url.startsWith(this.req.getServletPath())) {
            url = url.substring(this.req.getServletPath().length());
        }
        try {
            String encoding = this.req.getCharacterEncoding();
            if (encoding == null) {
                encoding = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding);
            }
            WebdavPath path = new WebdavPath(new String[0]);
            for (String component : url.split("/+")) {
                if (component.equals("")) continue;
                path.append(this.decode(component, encoding));
            }
            return path;
        }
        catch (UnsupportedEncodingException e) {
            return new WebdavPath((CharSequence)url);
        }
    }

    public String decode(String component, String encoding) throws UnsupportedEncodingException {
        return this.decoder.decode(component, encoding);
    }

    @Override
    public String getCharset() {
        return this.req.getCharacterEncoding() == null ? ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding) : this.req.getCharacterEncoding();
    }
}

