/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.ifheader.IfHeader;
import com.openexchange.webdav.action.ifheader.IfHeaderParseException;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ReplayWebdavRequest
implements WebdavRequest {
    private final WebdavRequest delegate;
    private byte[] body;

    public ReplayWebdavRequest(WebdavRequest req) {
        this.delegate = req;
    }

    @Override
    public InputStream getBody() throws IOException {
        if (this.body != null) {
            return new ByteArrayInputStream(this.body);
        }
        UnsynchronizedByteArrayOutputStream bout = new UnsynchronizedByteArrayOutputStream();
        InputStream in = null;
        in = this.delegate.getBody();
        byte[] buffer = new byte[200];
        int b = 0;
        while ((b = in.read(buffer)) > 0) {
            bout.write(buffer, 0, b);
        }
        this.body = bout.toByteArray();
        return new ByteArrayInputStream(this.body);
    }

    @Override
    public Document getBodyAsDocument() throws JDOMException, IOException {
        return new SAXBuilder().build(this.getBody());
    }

    @Override
    public WebdavCollection getCollection() throws WebdavProtocolException {
        return this.delegate.getCollection();
    }

    @Override
    public WebdavResource getDestination() throws WebdavProtocolException {
        return this.delegate.getDestination();
    }

    @Override
    public WebdavPath getDestinationUrl() {
        return this.delegate.getDestinationUrl();
    }

    @Override
    public String getHeader(String header) {
        return this.delegate.getHeader(header);
    }

    @Override
    public List<String> getHeaderNames() {
        return this.delegate.getHeaderNames();
    }

    @Override
    public IfHeader getIfHeader() throws IfHeaderParseException {
        return this.delegate.getIfHeader();
    }

    @Override
    public WebdavResource getResource() throws WebdavProtocolException {
        return this.delegate.getResource();
    }

    @Override
    public WebdavPath getUrl() {
        return this.delegate.getUrl();
    }

    @Override
    public String getURLPrefix() {
        return this.delegate.getURLPrefix();
    }

    @Override
    public int getDepth(int depth) {
        return this.delegate.getDepth(depth);
    }

    @Override
    public WebdavFactory getFactory() throws WebdavProtocolException {
        return this.delegate.getFactory();
    }

    @Override
    public String getCharset() {
        return this.delegate.getCharset();
    }

    @Override
    public boolean hasBody() {
        return this.delegate.hasBody();
    }

    @Override
    public Map<String, Object> getUserInfo() {
        return this.delegate.getUserInfo();
    }

    @Override
    public boolean isBrief() {
        return this.delegate.isBrief();
    }
}

