/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.groupware.EnumComponent;

public enum WebdavExceptionCode implements OXExceptionCode
{
    INVALID_VALUE("Invalid value in element \"%1$s\": %2$s.", CATEGORY_ERROR, 1),
    IO_ERROR("An I/O error occurred.", CATEGORY_ERROR, 2),
    MISSING_FIELD("Missing field %1$s.", CATEGORY_ERROR, 3),
    MISSING_HEADER_FIELD("Missing header field %1$s.", CATEGORY_ERROR, 4),
    INVALID_ACTION("Invalid action %1$s.", CATEGORY_ERROR, 5),
    NOT_A_NUMBER("%1$s is not a number.", CATEGORY_ERROR, 6),
    NO_PRINCIPAL("No principal found: %1$s.", CATEGORY_ERROR, 7),
    EMPTY_PASSWORD("Empty passwords are not allowed.", CATEGORY_USER_INPUT, 8),
    UNSUPPORTED_AUTH_MECH("Unsupported authorization mechanism in \"Authorization\" header: %1$s.", CATEGORY_ERROR, 9),
    RESOLVING_USER_NAME_FAILED("Resolving user name \"%1$s\" failed.", CATEGORY_ERROR, 10),
    AUTH_FAILED("Authentication failed for user name: %1$s", CATEGORY_ERROR, 11),
    UNEXPECTED_ERROR("Unexpected error: %1$s", CATEGORY_ERROR, 11);

    public static final String INVALID_VALUE_MSG = "Invalid value in element \"%1$s\": %2$s.";
    public static final String IO_ERROR_MSG = "An I/O error occurred.";
    public static final String MISSING_FIELD_MSG = "Missing field %1$s.";
    public static final String MISSING_HEADER_FIELD_MSG = "Missing header field %1$s.";
    public static final String INVALID_ACTION_MSG = "Invalid action %1$s.";
    public static final String NOT_A_NUMBER_MSG = "%1$s is not a number.";
    public static final String NO_PRINCIPAL_MSG = "No principal found: %1$s.";
    public static final String EMPTY_PASSWORD_MSG = "Empty passwords are not allowed.";
    public static final String UNSUPPORTED_AUTH_MECH_MSG = "Unsupported authorization mechanism in \"Authorization\" header: %1$s.";
    public static final String RESOLVING_USER_NAME_FAILED_MSG = "Resolving user name \"%1$s\" failed.";
    public static final String AUTH_FAILED_MSG = "Authentication failed for user name: %1$s";
    public static final String UNEXPECTED_ERROR_MSG = "Unexpected error: %1$s";
    private final String message;
    private final int detailNumber;
    private final Category category;

    private WebdavExceptionCode(String message, Category category, int detailNumber) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
    }

    public String getPrefix() {
        return EnumComponent.WEBDAV.getAbbreviation();
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

