/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.webdav;

import com.openexchange.config.ConfigurationService;
import com.openexchange.monitoring.MonitoringInfo;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.CountingHttpServletRequest;
import com.openexchange.tools.servlet.RateLimitedException;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class WebDavServlet
extends HttpServlet {
    private static final long serialVersionUID = 4869234414872430531L;
    public static final int SC_MULTISTATUS = 207;
    public static final int SC_LOCKED = 423;

    protected WebDavServlet() {
    }

    protected int getDavClass() {
        return 1;
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Method[] methods = ((Object)((Object)this)).getClass().getMethods();
        Class<WebDavServlet> clazz = WebDavServlet.class;
        Class superClazz = WebDavServlet.class.getSuperclass();
        StringBuilder allow = new StringBuilder(64);
        for (int i = 0; i < methods.length; ++i) {
            if ("doGet".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass()) && !superClazz.equals(methods[i].getDeclaringClass())) {
                allow.append("GET,HEAD,");
                continue;
            }
            if ("doDelete".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass())) {
                allow.append("DELETE,");
                continue;
            }
            if ("doPut".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass()) && !superClazz.equals(methods[i].getDeclaringClass())) {
                allow.append("PUT,");
                continue;
            }
            if ("doPost".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass()) && !superClazz.equals(methods[i].getDeclaringClass())) {
                allow.append("POST,");
                continue;
            }
            if ("doPropFind".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass())) {
                allow.append("PROPFIND,");
                continue;
            }
            if ("doPropPatch".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass())) {
                allow.append("PROPPATCH,");
                continue;
            }
            if ("doMkCol".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass())) {
                allow.append("MKCOL,");
                continue;
            }
            if ("doCopy".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass())) {
                allow.append("COPY,");
                continue;
            }
            if ("doMove".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass())) {
                allow.append("MOVE,");
                continue;
            }
            if ("doLock".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass())) {
                allow.append("LOCK,");
                continue;
            }
            if ("doUnLock".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass())) {
                allow.append("UNLOCK,");
                continue;
            }
            if ("doReport".equals(methods[i].getName()) && !clazz.equals(methods[i].getDeclaringClass())) {
                allow.append("REPORT,");
                continue;
            }
            if (!"doMkCalendar".equals(methods[i].getName()) || clazz.equals(methods[i].getDeclaringClass())) continue;
            allow.append("MKCALENDAR,");
        }
        allow.append("TRACE,OPTIONS");
        if (1 == this.getDavClass()) {
            resp.setHeader("DAV", "1");
        } else if (this.getDavClass() == 2) {
            resp.setHeader("DAV", "1,2");
        }
        resp.setHeader("Allow", allow.toString());
    }

    protected void doPropFind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(400, "Method \"PROPFIND\" is not supported by this servlet");
    }

    protected void doPropPatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(400, "Method \"PROPPATCH\" is not supported by this servlet");
    }

    protected void doMkCol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(400, "Method \"PROPPATCH\" is not supported by this servlet");
    }

    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(400, "Method \"COPY\" is not supported by this servlet");
    }

    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(400, "Method \"MOVE\" is not supported by this servlet");
    }

    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(400, "Method \"LOCK\" is not supported by this servlet");
    }

    protected void doUnLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(400, "Method \"UNLOCK\" is not supported by this servlet");
    }

    protected void doReport(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(400, "Method \"REPORT\" is not supported by this servlet");
    }

    protected void doMkCalendar(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(400, "Method \"MKCALENDAR\" is not supported by this servlet");
    }

    protected boolean isDisabledByProperty() {
        ConfigurationService config = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        return config.getBoolProperty("com.openexchange.webdav.disabled", true);
    }

    protected String getDisabledMessage() {
        ConfigurationService config = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        String text = config.getText("webdav-disabled-message.txt");
        return text;
    }

    protected boolean isServletDisabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isServletDisabled() && this.isDisabledByProperty()) {
            resp.setContentType("text/html; charset=UTF-8");
            resp.sendError(503, this.getDisabledMessage());
            return;
        }
        this.incrementRequests();
        try {
            CountingHttpServletRequest req = new CountingHttpServletRequest(request);
            String method = req.getMethod();
            if ("PROPFIND".equals(method)) {
                this.doPropFind(req, resp);
            } else if ("PROPPATCH".equals(method)) {
                this.doPropPatch(req, resp);
            } else if ("MKCOL".equals(method)) {
                this.doMkCol(req, resp);
            } else if ("COPY".equals(method)) {
                this.doCopy(req, resp);
            } else if ("MOVE".equals(method)) {
                this.doMove(req, resp);
            } else if ("LOCK".equals(method)) {
                this.doLock(req, resp);
            } else if ("UNLOCK".equals(method)) {
                this.doUnLock(req, resp);
            } else if ("REPORT".equals(method)) {
                this.doReport(req, resp);
            } else if ("MKCALENDAR".equals(method)) {
                this.doMkCalendar(req, resp);
            } else {
                super.service((HttpServletRequest)req, resp);
            }
        }
        catch (RateLimitedException e) {
            resp.setContentType("text/plain; charset=UTF-8");
            resp.sendError(429, "Too Many Requests - Your request is being rate limited.");
        }
        finally {
            this.decrementRequests();
        }
    }

    protected void incrementRequests() {
        MonitoringInfo.incrementNumberOfConnections((int)4);
    }

    protected void decrementRequests() {
        MonitoringInfo.decrementNumberOfConnections((int)4);
    }
}

