/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.old;

import com.openexchange.tools.versit.VersitDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class OldFoldingWriter
implements VersitDefinition.Writer {
    public final String charset;
    public final CharsetEncoder encoder;
    private final OutputStream w;
    private final StringBuilder sb = new StringBuilder();
    int Break = 0;
    private static final byte[] SoftBreak = new byte[]{13, 10, 32};
    private static final byte[] HardBreak = new byte[]{13, 10};

    public OldFoldingWriter(OutputStream stream, String charset) {
        this.w = stream;
        this.charset = charset;
        this.encoder = Charset.forName(this.charset).newEncoder();
    }

    public int lineLength() {
        return this.sb.length();
    }

    public void write(String s) throws IOException {
        this.sb.append(s);
        if (this.sb.length() > 76 && this.Break > 0) {
            this.w.write(this.sb.toString().getBytes(this.charset), 0, this.Break);
            this.w.write(SoftBreak);
            this.sb.delete(0, this.Break);
        }
        this.Break = this.sb.length();
    }

    public void rawStart() throws IOException {
        this.w.write(this.sb.toString().getBytes(this.charset));
        this.sb.setLength(0);
        this.Break = 0;
    }

    public void writeRaw(byte[] data) throws IOException {
        this.w.write(data);
    }

    public void rawEnd() throws IOException {
        this.w.write(HardBreak);
    }

    public void writeln(byte[] value) throws IOException {
        this.rawStart();
        this.writeRaw(value);
        this.rawEnd();
    }

    @Override
    public void flush() throws IOException {
        this.w.flush();
    }

    @Override
    public void close() throws IOException {
        this.w.close();
    }
}

