/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.old;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.Scanner;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.old.OldParamDefinition;
import com.openexchange.tools.versit.old.OldShortPropertyDefinition;
import com.openexchange.tools.versit.values.DurationValue;
import java.io.IOException;

public class OldDurationPropertyDefinition
extends OldShortPropertyDefinition {
    public OldDurationPropertyDefinition(String[] paramNames, OldParamDefinition[] params) {
        super(paramNames, params);
    }

    @Override
    protected Object parseValue(Property property, StringScanner ss) throws IOException {
        DurationValue dur = new DurationValue();
        if (ss.peek != 80) {
            throw new VersitException(ss, "Duration expected");
        }
        ss.read();
        if (ss.peek == 84) {
            this.parseTime(ss, dur);
        } else {
            int num = ss.parseNumber();
            if (ss.peek == 89) {
                dur.Years = num;
                ss.read();
                num = ss.parseNumber();
            }
            if (ss.peek == 77) {
                dur.Months = num;
                ss.read();
                num = ss.parseNumber();
            }
            if (ss.peek == 87) {
                dur.Weeks = num;
                ss.read();
                num = ss.parseNumber();
            }
            if (ss.peek == 68) {
                dur.Days = num;
                ss.read();
            }
            if (ss.peek == 84) {
                this.parseTime(ss, dur);
            }
        }
        return dur;
    }

    void parseTime(Scanner s, DurationValue dur) throws IOException {
        s.read();
        int num = s.parseNumber();
        if (s.peek == 72) {
            dur.Hours = num;
            s.read();
            num = s.parseNumber();
        }
        if (s.peek == 77) {
            dur.Hours = num;
            s.read();
            num = s.parseNumber();
        }
        if (s.peek == 83) {
            dur.Hours = num;
            s.read();
        }
    }

    @Override
    protected String writeValue(Property property, Object value) {
        DurationValue dur = (DurationValue)value;
        StringBuilder sb = new StringBuilder();
        sb.append('P');
        if (dur.Years != 0) {
            sb.append(dur.Years);
            sb.append('Y');
        }
        if (dur.Months != 0) {
            sb.append(dur.Months);
            sb.append('M');
        }
        if (dur.Weeks != 0) {
            sb.append(dur.Weeks);
            sb.append('W');
        }
        if (dur.Days != 0) {
            sb.append(dur.Days);
            sb.append('D');
        }
        if (dur.Hours != 0 || dur.Minutes != 0 || dur.Seconds != 0) {
            sb.append('T');
            if (dur.Hours != 0) {
                sb.append(dur.Hours);
                sb.append('H');
                if (dur.Minutes != 0 || dur.Seconds != 0) {
                    sb.append(dur.Minutes);
                    sb.append('M');
                    if (dur.Seconds != 0) {
                        sb.append(dur.Seconds);
                        sb.append('S');
                    }
                }
            } else {
                if (dur.Minutes != 0) {
                    sb.append(dur.Minutes);
                    sb.append('M');
                }
                if (dur.Seconds != 0) {
                    sb.append(dur.Seconds);
                    sb.append('S');
                }
            }
        }
        return sb.toString();
    }
}

