/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.old;

import com.openexchange.tools.versit.Parameter;
import com.openexchange.tools.versit.ParameterValue;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.old.OldFoldingWriter;
import com.openexchange.tools.versit.old.OldObjectDefinition;
import com.openexchange.tools.versit.old.OldPropertyDefinition;
import com.openexchange.tools.versit.old.OldScanner;
import java.io.IOException;
import java.util.ArrayList;

public class OldAlarmObjectDefinition
extends OldObjectDefinition {
    public OldAlarmObjectDefinition(String[] propertyNames, OldPropertyDefinition[] properties) {
        super(propertyNames, properties);
    }

    public void parse(OldScanner s, VersitObject object) throws IOException {
        throw new VersitException(s, "Invalid element: VALARM");
    }

    @Override
    public void write(OldFoldingWriter fw, VersitObject object) throws IOException {
        String[] propValueNames;
        Property property = object.getProperty("ACTION");
        if (property == null) {
            throw new IOException("ACTION in VALARM not found");
        }
        String action = property.getValue().toString();
        String[] actions = new String[]{"AUDIO", "DISPLAY", "EMAIL", "PROCEDURE"};
        int alarm_type = -1;
        for (int i = 0; i < actions.length; ++i) {
            if (!actions[i].equalsIgnoreCase(action)) continue;
            alarm_type = i;
            break;
        }
        if (alarm_type < 0) {
            throw new IOException("Unknown ACTION in VALARM: " + action);
        }
        String[] propNames = new String[]{"AALARM", "DALARM", "MALARM", "PALARM"};
        Property alarm = new Property(propNames[alarm_type]);
        if (alarm_type == 0 && (property = object.getProperty("ATTACH")) != null) {
            Parameter param = property.getParameter("FMTTYPE");
            String type = param.getValue(0).getText();
            if ("audio/basic".equalsIgnoreCase(type)) {
                type = "PCM";
            } else if ("audio/x-wav".equalsIgnoreCase(type)) {
                type = "WAVE";
            } else if ("audio/x-aiff".equalsIgnoreCase(type)) {
                type = "AIFF";
            } else {
                throw new IOException("Unknown audio format: " + type);
            }
            Parameter type_param = new Parameter("TYPE");
            type_param.addValue(new ParameterValue(type));
            alarm.addParameter(type_param);
        }
        ArrayList<Object> value = new ArrayList<Object>();
        property = object.getProperty("TRIGGER");
        if (property != null) {
            value.add(property.getValue());
        }
        if ((property = object.getProperty("DURATION")) != null) {
            value.add(property.getValue());
        }
        if ((property = object.getProperty("REPEAT")) != null) {
            value.add(property.getValue());
        }
        if ((property = object.getProperty((propValueNames = new String[]{"ATTACH", "DESCRIPTION", "ATTENDEE", "ATTACH"})[alarm_type])) != null) {
            value.add(property.getValue());
        }
        if (alarm_type == 2 && (property = object.getProperty("DESCRIPTION")) != null) {
            value.add(property.getValue());
        }
    }
}

