/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.filetokenizer;

import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.tools.versit.ICalendar;
import com.openexchange.tools.versit.VCard;
import com.openexchange.tools.versit.filetokenizer.VCardFileToken;
import com.openexchange.tools.versit.old.VCalendar10;
import com.openexchange.tools.versit.old.VCard21;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCardTokenizer {
    private static final Logger LOG = LoggerFactory.getLogger(VCardTokenizer.class);
    public static final String VCARD_V3 = "3.0";
    public static final String VCARD_V21 = "2.1";
    public static final String VCALENDAR = "1.0";
    public static final String ICALENDAR = "2.0";
    public static final String ASCII_ENC = "ASCII";
    private final InputStream vcard;
    private int entriesFound;
    private int entriesRecognized;
    private ByteArrayOutputStream streamAsBytes = new UnsynchronizedByteArrayOutputStream();
    private boolean streamEnded;

    public VCardTokenizer(InputStream is) throws IOException {
        this.vcard = Streams.bufferedInputStreamFor((InputStream)is);
    }

    public List<VCardFileToken> split() {
        LinkedList<VCardFileToken> chunks = new LinkedList<VCardFileToken>();
        VCardFileToken currentChunk = new VCardFileToken();
        boolean potentialCalendar = false;
        boolean potentialCard = false;
        try {
            String currLine;
            while ((currLine = this.readLine()) != null) {
                String compLine = currLine.trim().toUpperCase();
                if (compLine.startsWith("VERSION")) {
                    if (potentialCard && currLine.trim().endsWith(VCARD_V3)) {
                        currentChunk.setVersitDefinition(VCard.definition);
                        continue;
                    }
                    if (potentialCard && compLine.endsWith(VCARD_V21)) {
                        currentChunk.setVersitDefinition(VCard21.definition);
                        continue;
                    }
                    if (potentialCalendar && compLine.endsWith(VCALENDAR)) {
                        currentChunk.setVersitDefinition(VCalendar10.definition);
                        continue;
                    }
                    if (!potentialCalendar || !compLine.endsWith(ICALENDAR)) continue;
                    currentChunk.setVersitDefinition(ICalendar.definition);
                    continue;
                }
                if (compLine.startsWith("BEGIN") && compLine.endsWith("VCALENDAR")) {
                    potentialCalendar = true;
                    continue;
                }
                if (compLine.startsWith("BEGIN") && compLine.endsWith("VCARD")) {
                    potentialCard = true;
                    continue;
                }
                if (!compLine.startsWith("END") || !compLine.endsWith("VCARD") && !compLine.endsWith("VCALENDAR")) continue;
                currentChunk.setContent(this.streamAsBytes.toByteArray());
                this.streamAsBytes = new UnsynchronizedByteArrayOutputStream();
                chunks.add(currentChunk);
                ++this.entriesFound;
                potentialCalendar = false;
                potentialCard = false;
                if (currentChunk.getVersitDefinition() != null) {
                    ++this.entriesRecognized;
                }
                currentChunk = new VCardFileToken();
            }
        }
        catch (IOException e) {
            LOG.error("I/O error while trying to tokenize stream that was a vCard (supposedly)", (Throwable)e);
            Streams.close((Closeable)this.vcard);
        }
        return chunks;
    }

    public int getNumberOfEntriesFound() {
        return this.entriesFound;
    }

    public int getNumberOfEntriesRecognized() {
        return this.entriesRecognized;
    }

    protected String readLine() throws IOException {
        if (this.streamEnded) {
            return null;
        }
        UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream();
        byte[] buf = new byte[1];
        int length = -1;
        while ((length = this.vcard.read(buf)) > 0) {
            baos.write(buf, 0, length);
            if (10 != buf[0]) continue;
            byte[] ret = baos.toByteArray();
            this.streamAsBytes.write(ret);
            return Charsets.toAsciiString((byte[])ret);
        }
        this.streamEnded = true;
        if (baos.size() != 0) {
            baos.write(10);
            byte[] ret = baos.toByteArray();
            this.streamAsBytes.write(ret);
            return Charsets.toAsciiString((byte[])ret);
        }
        return null;
    }

    protected byte[] toByteArray(List<Byte> list) {
        byte[] returnValues = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            returnValues[i] = list.get(i);
        }
        return returnValues;
    }
}

