/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.update;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextExtended;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.ForeignKey;
import java.io.File;
import java.net.URI;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class Tools {
    private static final int NULLABLE = 11;
    private static final String TABLE = "TABLE";

    private Tools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isNullable(Connection con, String table, String column) throws SQLException {
        DatabaseMetaData meta = con.getMetaData();
        ResultSet result = null;
        boolean retval = false;
        try {
            result = meta.getColumns(null, null, table, column);
            if (!result.next()) {
                throw new SQLException("Can't get information for column " + column + " in table " + table + '.');
            }
            retval = 1 == result.getInt(11);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean existsPrimaryKey(Connection con, String table, String[] columns) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ArrayList<String> foundColumns = new ArrayList<String>();
        ResultSet result = null;
        try {
            result = metaData.getPrimaryKeys(null, null, table);
            while (result.next()) {
                String columnName = result.getString(4);
                int columnPos = result.getInt(5);
                while (foundColumns.size() < columnPos) {
                    foundColumns.add(null);
                }
                foundColumns.set(columnPos - 1, columnName);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result);
        boolean matches = columns.length == foundColumns.size();
        for (int i = 0; matches && i < columns.length; ++i) {
            matches = columns[i].equalsIgnoreCase((String)foundColumns.get(i));
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String existsIndex(Connection con, String table, String[] columns) throws SQLException {
        ArrayList foundColumns;
        DatabaseMetaData metaData = con.getMetaData();
        HashMap indexes = new HashMap();
        ResultSet result = null;
        try {
            result = metaData.getIndexInfo(null, null, table, false, false);
            while (result.next()) {
                String indexName = result.getString(6);
                int columnPos = result.getInt(8);
                String columnName = result.getString(9);
                foundColumns = (ArrayList)indexes.get(indexName);
                if (null == foundColumns) {
                    foundColumns = new ArrayList();
                    indexes.put(indexName, foundColumns);
                }
                while (foundColumns.size() < columnPos) {
                    foundColumns.add(null);
                }
                foundColumns.set(columnPos - 1, columnName);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result);
        String foundIndex = null;
        Iterator iter = indexes.entrySet().iterator();
        while (null == foundIndex && iter.hasNext()) {
            Map.Entry entry = iter.next();
            foundColumns = (ArrayList)entry.getValue();
            if (columns.length != foundColumns.size()) continue;
            boolean matches = true;
            for (int i = 0; matches && i < columns.length; ++i) {
                matches = columns[i].equalsIgnoreCase((String)foundColumns.get(i));
            }
            if (!matches) continue;
            foundIndex = (String)entry.getKey();
        }
        return foundIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String existsForeignKey(Connection con, String primaryTable, String[] primaryColumns, String foreignTable, String[] foreignColumns) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        HashSet<ForeignKey> keys = new HashSet<ForeignKey>();
        ResultSet result = null;
        try {
            result = metaData.getImportedKeys(null, null, foreignTable);
            ForeignKey key = null;
            while (result.next()) {
                String foundPrimaryTable = result.getString("PKTABLE_NAME");
                String foundForeignTable = result.getString("FKTABLE_NAME");
                String keyName = result.getString("FK_NAME");
                ForeignKey tmp = new ForeignKey(keyName, foundPrimaryTable, foundForeignTable);
                if (null == key || !key.isSame(tmp)) {
                    key = tmp;
                    keys.add(key);
                }
                String primaryColumn = result.getString("PKCOLUMN_NAME");
                String foreignColumn = result.getString("FKCOLUMN_NAME");
                int columnPos = result.getInt("KEY_SEQ");
                key.setPrimaryColumn(columnPos - 1, primaryColumn);
                key.setForeignColumn(columnPos - 1, foreignColumn);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result);
        for (ForeignKey key : keys) {
            if (!key.getPrimaryTable().equalsIgnoreCase(primaryTable) || !key.getForeignTable().equalsIgnoreCase(foreignTable) || !key.matches(primaryColumns, foreignColumns)) continue;
            return key.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<String> allForeignKey(Connection con, String foreignTable) throws SQLException {
        ArrayList<String> arrayList;
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet result = null;
        try {
            result = metaData.getImportedKeys(null, null, foreignTable);
            HashSet<String> set = new HashSet<String>();
            while (result.next()) {
                String keyName = result.getString("FK_NAME");
                if (null == keyName) continue;
                set.add(keyName);
            }
            arrayList = new ArrayList<String>(set);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void dropPrimaryKey(Connection con, String table) throws SQLException {
        String sql = "ALTER TABLE `" + table + "` DROP PRIMARY KEY";
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(sql);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void dropIndex(Connection con, String table, String index) throws SQLException {
        String sql = "ALTER TABLE `" + table + "` DROP INDEX `" + index + "`";
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(sql);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void dropForeignKey(Connection con, String table, String foreignKey) throws SQLException {
        String sql = "ALTER TABLE `" + table + "` DROP FOREIGN KEY `" + foreignKey + "`";
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(sql);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createPrimaryKey(Connection con, String table, String[] columns, int[] lengths) throws SQLException {
        StringBuilder sql = new StringBuilder("ALTER TABLE `");
        sql.append(table);
        sql.append("` ADD PRIMARY KEY (");
        String column = columns[0];
        sql.append('`').append(column).append('`');
        int len = lengths[0];
        if (len > 0) {
            sql.append('(').append(len).append(')');
        }
        for (int i = 1; i < columns.length; ++i) {
            String column2 = columns[i];
            sql.append(',');
            sql.append('`').append(column2).append('`');
            int len2 = lengths[i];
            if (len2 <= 0) continue;
            sql.append('(').append(len2).append(')');
        }
        sql.append(')');
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(sql.toString());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    public static final void createPrimaryKey(Connection con, String table, String[] columns) throws SQLException {
        int[] lengths = new int[columns.length];
        Arrays.fill(lengths, -1);
        Tools.createPrimaryKey(con, table, columns, lengths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createIndex(Connection con, String table, String name, String[] columns, boolean unique) throws SQLException {
        StringBuilder sql = new StringBuilder("ALTER TABLE `");
        sql.append(table);
        sql.append("` ADD ");
        if (unique) {
            sql.append("UNIQUE ");
        }
        sql.append("INDEX ");
        if (null != name) {
            sql.append('`');
            sql.append(name);
            sql.append("` ");
        }
        sql.append("(");
        for (String column : columns) {
            if (column.startsWith("`")) {
                sql.append(column);
                sql.append(",");
                continue;
            }
            sql.append("`");
            sql.append(column);
            sql.append("`,");
        }
        sql.setLength(sql.length() - 1);
        sql.append(')');
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(sql.toString());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    public static final void createIndex(Connection con, String table, String[] columns) throws SQLException {
        Tools.createIndex(con, table, null, columns, false);
    }

    public static void createForeignKey(Connection con, String primaryTable, String[] primaryColumns, String foreignTable, String[] foreignColumns) throws SQLException {
        Tools.createForeignKey(con, null, primaryTable, primaryColumns, foreignTable, foreignColumns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createForeignKey(Connection con, String name, String primaryTable, String[] primaryColumns, String foreignTable, String[] foreignColumns) throws SQLException {
        StringBuilder sql = new StringBuilder("ALTER TABLE `");
        sql.append(primaryTable);
        sql.append("` ADD FOREIGN KEY ");
        if (null != name) {
            sql.append('`');
            sql.append(name);
            sql.append("` ");
        }
        sql.append("(`");
        for (String column : primaryColumns) {
            sql.append(column);
            sql.append("`,`");
        }
        sql.setLength(sql.length() - 2);
        sql.append(") REFERENCES `");
        sql.append(foreignTable);
        sql.append("`(`");
        for (String column : foreignColumns) {
            sql.append(column);
            sql.append("`,`");
        }
        sql.setLength(sql.length() - 2);
        sql.append(')');
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(sql.toString());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean hasPrimaryKey(Connection con, String table) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet primaryKeys = metaData.getPrimaryKeys(null, null, table);
        try {
            boolean bl = primaryKeys.next();
            return bl;
        }
        finally {
            DBUtils.closeSQLStuff(primaryKeys);
        }
    }

    public static final boolean isVARCHAR(Connection con, String table, String column) throws SQLException {
        return Tools.isType(con, table, column, 12);
    }

    public static final boolean isType(Connection con, String table, String column, int type) throws SQLException {
        return type == Tools.getColumnType(con, table, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getColumnType(Connection con, String table, String column) throws SQLException {
        if (!Tools.columnExists(con, table, column)) {
            return -1;
        }
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        int type = -1;
        try {
            rs = metaData.getColumns(null, null, table, column);
            while (rs.next()) {
                type = rs.getInt(5);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs);
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean hasDefaultValue(Connection con, String table, String column) throws SQLException {
        ResultSet rs;
        block4: {
            boolean bl;
            if (!Tools.columnExists(con, table, column)) {
                throw new SQLException("Column '" + column + "' does not exist in table '" + table + "'");
            }
            DatabaseMetaData metaData = con.getMetaData();
            rs = null;
            try {
                rs = metaData.getColumns(null, null, table, column);
                if (!rs.next()) break block4;
                bl = null != rs.getString("COLUMN_DEF");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs);
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs);
            return bl;
        }
        boolean bl = false;
        DBUtils.closeSQLStuff(rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getColumnTypeName(Connection con, String table, String column) throws SQLException {
        if (!Tools.columnExists(con, table, column)) {
            return null;
        }
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        String typeName = null;
        try {
            rs = metaData.getColumns(null, null, table, column);
            while (rs.next()) {
                typeName = rs.getString(6);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs);
        return typeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean tableExists(Connection con, String table) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        boolean retval = false;
        try {
            rs = metaData.getTables(null, null, table, new String[]{TABLE});
            retval = rs.next() && rs.getString("TABLE_NAME").equalsIgnoreCase(table);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean columnExists(Connection con, String table, String column) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        boolean retval = false;
        try {
            rs = metaData.getColumns(null, null, table, column);
            while (rs.next()) {
                retval = rs.getString(4).equalsIgnoreCase(column);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs);
        return retval;
    }

    public static void removeFile(int cid, String fileStoreLocation) throws OXException {
        ContextExtended ctx = ContextStorage.getInstance().loadContext(cid);
        URI fileStorageURI = FilestoreStorage.createURI(ctx);
        File file = new File(fileStorageURI);
        if (file.exists()) {
            QuotaFileStorage fs = QuotaFileStorage.getInstance(fileStorageURI, ctx);
            ((FileStorage)fs).deleteFile(fileStoreLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasSequenceEntry(String sequenceTable, Connection con, int ctxId) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT 1 FROM " + sequenceTable + " WHERE cid=?");
            stmt.setInt(1, ctxId);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getContextIDs(Connection con) throws SQLException {
        LinkedList<Integer> linkedList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        LinkedList<Integer> contextIds = new LinkedList<Integer>();
        try {
            stmt = con.prepareStatement("SELECT DISTINCT cid FROM user");
            rs = stmt.executeQuery();
            while (rs.next()) {
                contextIds.add(Autoboxing.I((int)rs.getInt(1)));
            }
            linkedList = contextIds;
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exec(Connection con, String sql, Object ... args) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql);
            int i = 1;
            for (Object arg : args) {
                stmt.setObject(i++, arg);
            }
            stmt.execute();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addColumns(Connection con, String tableName, Column ... cols) throws SQLException {
        StringBuffer sql = new StringBuffer("ALTER TABLE ");
        sql.append(tableName);
        for (Column column : cols) {
            sql.append(" ADD ");
            sql.append(column.getName());
            sql.append(' ');
            sql.append(column.getDefinition());
            sql.append(',');
        }
        if (sql.charAt(sql.length() - 1) == ',') {
            sql.setLength(sql.length() - 1);
        }
        if (sql.length() == 12 + tableName.length()) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(sql.toString());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    public static void checkAndAddColumns(Connection con, String tableName, Column ... cols) throws SQLException {
        ArrayList<Column> notExisting = new ArrayList<Column>();
        for (Column col : cols) {
            if (Tools.columnExists(con, tableName, col.getName())) continue;
            notExisting.add(col);
        }
        if (!notExisting.isEmpty()) {
            Tools.addColumns(con, tableName, notExisting.toArray(new Column[notExisting.size()]));
        }
    }

    public static void modifyColumns(Connection con, String tableName, Collection<Column> columns) throws SQLException {
        Tools.modifyColumns(con, tableName, columns.toArray(new Column[columns.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyColumns(Connection con, String tableName, Column ... cols) throws SQLException {
        if (null == cols || cols.length == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder("ALTER TABLE ");
        sql.append(tableName);
        for (Column column : cols) {
            sql.append(" MODIFY COLUMN ");
            sql.append(column.getName());
            sql.append(' ');
            sql.append(column.getDefinition());
            sql.append(',');
        }
        if (sql.charAt(sql.length() - 1) == ',') {
            sql.setLength(sql.length() - 1);
        }
        if (sql.length() == 12 + tableName.length()) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(sql.toString());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    public static void checkAndModifyColumns(Connection con, String tableName, Column ... cols) throws SQLException {
        ArrayList<Column> toDo = new ArrayList<Column>();
        for (Column col : cols) {
            if (col.getDefinition().contains(Tools.getColumnTypeName(con, tableName, col.getName()))) continue;
            toDo.add(col);
        }
        if (!toDo.isEmpty()) {
            Tools.modifyColumns(con, tableName, toDo.toArray(new Column[toDo.size()]));
        }
    }
}

