/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet;

import com.javacodegeeks.concurrent.ConcurrentLinkedHashMap;
import com.javacodegeeks.concurrent.EvictionPolicy;

public final class IdleExpirationPolicy
implements EvictionPolicy {
    private final long idleTimeThresholdMillis;

    public IdleExpirationPolicy(long idleTimeThresholdMillis) {
        this.idleTimeThresholdMillis = idleTimeThresholdMillis;
    }

    public boolean accessOrder() {
        return true;
    }

    public boolean insertionOrder() {
        return false;
    }

    public ConcurrentLinkedHashMap.Entry<?, ?> evictElement(ConcurrentLinkedHashMap.Entry<?, ?> head) {
        return head.getAfter();
    }

    public ConcurrentLinkedHashMap.Entry<?, ?> recordInsertion(ConcurrentLinkedHashMap.Entry<?, ?> head, ConcurrentLinkedHashMap.Entry<?, ?> insertedEntry) {
        return null;
    }

    public ConcurrentLinkedHashMap.Entry<?, ?> recordAccess(ConcurrentLinkedHashMap.Entry<?, ?> head, ConcurrentLinkedHashMap.Entry<?, ?> accessedEntry) {
        long accessedEntryIdleTime = System.currentTimeMillis() - accessedEntry.getLastAccessTime();
        return accessedEntryIdleTime < this.idleTimeThresholdMillis ? head : accessedEntry.getAfter();
    }
}

