/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.StringAllocator;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorExceptionCodes;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.oxfolder.memory.Condition;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMap;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OXFolderIteratorSQL {
    private static final Logger LOG = LoggerFactory.getLogger(OXFolderIteratorSQL.class);
    private static final String OXFOLDER_PERMISSIONS = "oxfolder_permissions";
    private static final String OXFOLDER_TREE = "oxfolder_tree";
    private static final String STR_EMPTY = "";
    private static final String STR_SELECT = "SELECT ";
    private static final int TASK = 1;
    private static final int CONTACT = 3;
    private static final int CALENDAR = 2;
    private static final int INFOSTORE = 8;
    private static final int SYSTEM_MODULE = 5;
    private static final int PRIVATE = 1;
    private static final int PUBLIC = 2;
    private static final int SHARED = 3;
    private static final int SYSTEM_TYPE = 5;
    private static final int SYSTEM_PUBLIC_FOLDER_ID = 2;
    private static final int SYSTEM_PRIVATE_FOLDER_ID = 1;
    private static final int SYSTEM_INFOSTORE_FOLDER_ID = 9;
    private static final int SYSTEM_SHARED_FOLDER_ID = 3;
    private static final int SYSTEM_LDAP_FOLDER_ID = 6;
    private static final int SYSTEM_ROOT_FOLDER_ID = 0;
    private static final int VIRTUAL_LIST_INFOSTORE_FOLDER_ID = 14;
    private static final int VIRTUAL_LIST_CONTACT_FOLDER_ID = 13;
    private static final int VIRTUAL_LIST_CALENDAR_FOLDER_ID = 12;
    private static final int VIRTUAL_LIST_TASK_FOLDER_ID = 11;
    private static final int PRIVATE_PERMISSION = 1;
    private static final int SYSTEM_GLOBAL_FOLDER_ID = 5;
    private static final String SHARED_PREFIX = "u:";
    private static final int MIN_FOLDER_ID = 20;
    private static final String SQL_IN_STR_STANDARD_MODULES_ALL = FolderObject.SQL_IN_STR_STANDARD_MODULES_ALL;
    private static final String SQL_IN_STR_STANDARD_MODULES = FolderObject.SQL_IN_STR_STANDARD_MODULES;
    private static final Pattern PAT_ORDER_BY = Pattern.compile("( *ORDER +BY +)(?:([a-zA-Z0-9_.]+)(?: *ASC *| *DESC *)?)(?:, *[a-zA-Z0-9_.]+(?: *ASC *| *DESC *)?)?", 2);
    private static final Pattern PAT_FIELD = Pattern.compile("(?:([a-zA-Z0-9_.]+)(?: *ASC| *DESC)?)", 2);
    private static final Pattern PAT_PREP = Pattern.compile("[a-zA-Z0-9_]+\\.([a-zA-Z0-9_])");
    private static final String STR_OT = "ot";
    private static final String STR_ORDER_BY = "ORDER BY ";
    private static final String STR_FUID = "fuid";
    private static final String STR_DEFAULTFLAG_DESC = "default_flag DESC";
    private static final String STR_FNAME = "fname";
    private static final String STR_GROUP_BY = "GROUP BY ";
    private static final int[] DEF_MODULES = new int[]{2, 3, 1};
    private static final String SQL_SEL_ALL_PUB = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND type = ? ORDER BY fuid";
    private static final String SQL_SEL_ALL_PUB_MODULE = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND type = ? AND module = ? ORDER BY fuid";
    private static final boolean useLastModifiedIndex = false;

    private OXFolderIteratorSQL() {
    }

    private static String getSQLUserVisibleFolders(String fields, String permissionIds, String accessibleModules, String additionalCondition, String orderBy) {
        return OXFolderIteratorSQL.getSQLUserVisibleFolders(OXFOLDER_TREE, OXFOLDER_PERMISSIONS, fields, permissionIds, accessibleModules, additionalCondition, orderBy, false);
    }

    private static String getSQLUserVisibleFolders(String folderTable, String permissionTable, String fields, String permissionIds, String accessibleModules, String additionalCondition, String orderBy, boolean queryOptUserPrivate) {
        return OXFolderIteratorSQL.getSQLUserVisibleFolders(folderTable, permissionTable, fields, permissionIds, accessibleModules, additionalCondition, orderBy, queryOptUserPrivate, new String[0]);
    }

    private static String getSQLUserVisibleFolders(String folderTable, String permissionTable, String fields, String permissionIds, String accessibleModules, String additionalCondition, String orderBy, boolean queryOptUserPrivate, String ... indexNames) {
        String preparedOrderBy;
        StringBuilder sb = new StringBuilder(256);
        sb.append(STR_SELECT).append(fields);
        if (null == orderBy) {
            preparedOrderBy = null;
        } else {
            String[] orderFields = OXFolderIteratorSQL.parseFieldsFromOrderBy(orderBy);
            if (0 < orderFields.length) {
                for (String orderField : orderFields) {
                    if (-1 != fields.indexOf(orderField)) continue;
                    sb.append(", ").append(orderField);
                }
            }
            preparedOrderBy = OXFolderIteratorSQL.prepareOrderBy(orderBy);
        }
        sb.append(" FROM ").append(folderTable).append(" AS ot");
        if (null != indexNames && indexNames.length > 0) {
            sb.append(" FORCE INDEX (");
            sb.append(indexNames[0]);
            for (int i = 1; i < indexNames.length; ++i) {
                sb.append(',').append(indexNames[i]);
            }
            sb.append(')');
        }
        String select = sb.toString();
        sb.setLength(0);
        ArrayList<String> whereClauses = new ArrayList<String>(3);
        if (queryOptUserPrivate) {
            sb.append(" WHERE ot.cid = ? AND (ot.permission_flag = ").append(1).append(" AND ot.created_from = ?)");
            OXFolderIteratorSQL.appendix(sb, accessibleModules, additionalCondition);
            whereClauses.add(sb.toString());
            sb.setLength(0);
        }
        sb.append(" JOIN ").append(permissionTable).append(" AS op ON ot.fuid = op.fuid AND ot.cid = ? AND op.cid = ? WHERE (op.admin_flag = 1 AND op.permission_id = ?)");
        OXFolderIteratorSQL.appendix(sb, accessibleModules, additionalCondition);
        whereClauses.add(sb.toString());
        sb.setLength(0);
        sb.append(" JOIN ").append(permissionTable).append(" AS op ON ot.fuid = op.fuid AND ot.cid = ? AND op.cid = ? WHERE (op.fp > ").append(0).append(" AND op.permission_id IN ").append(permissionIds).append(')');
        OXFolderIteratorSQL.appendix(sb, accessibleModules, additionalCondition);
        whereClauses.add(sb.toString());
        sb.setLength(0);
        sb.append(select);
        sb.append((String)whereClauses.get(0));
        for (int i = 1; i < whereClauses.size(); ++i) {
            sb.append(" UNION ");
            sb.append(select);
            sb.append((String)whereClauses.get(i));
        }
        if (null != preparedOrderBy) {
            sb.append(' ').append(preparedOrderBy);
        }
        return sb.toString();
    }

    private static final void appendix(StringBuilder sb, String accessibleModules, String additionalCondition) {
        if (OXFolderProperties.isIgnoreSharedAddressbook()) {
            sb.append(" AND (ot.fuid != ").append(5).append(')');
        }
        if (accessibleModules != null) {
            sb.append(" AND (ot.module IN ").append(accessibleModules).append(')');
        }
        if (additionalCondition != null) {
            sb.append(' ').append(additionalCondition);
        }
    }

    private static String[] parseFieldsFromOrderBy(String orderBy) {
        Matcher m = PAT_ORDER_BY.matcher(orderBy);
        if (m.matches()) {
            m = PAT_FIELD.matcher(orderBy.substring(m.end(1)));
            ArrayList<String> l = new ArrayList<String>(2);
            while (m.find()) {
                l.add(m.group(1));
            }
            return l.toArray(new String[l.size()]);
        }
        return new String[0];
    }

    private static final String prepareOrderBy(String orderBy) {
        if (null == orderBy) {
            return null;
        }
        return PAT_PREP.matcher(orderBy).replaceAll("$1");
    }

    private static String getRootOrderBy(String tableAlias) {
        return OXFolderIteratorSQL.getOrderBy(tableAlias, STR_FUID);
    }

    private static String getSubfolderOrderBy(String tableAlias) {
        return OXFolderIteratorSQL.getOrderBy(tableAlias, STR_DEFAULTFLAG_DESC, STR_FNAME);
    }

    private static String getOrderBy(String tableAlias, String ... strings) {
        String alias;
        if (strings == null || strings.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(32);
        if (tableAlias == null) {
            alias = STR_EMPTY;
        } else {
            alias = sb.append(tableAlias).append('.').toString();
            sb.setLength(0);
        }
        sb.append(STR_ORDER_BY);
        sb.append(alias).append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            sb.append(", ");
            sb.append(alias).append(strings[i]);
        }
        return sb.toString();
    }

    private static String getGroupBy(String tableAlias) {
        String alias = tableAlias == null ? STR_EMPTY : new StringBuilder(tableAlias.length() + 1).append(tableAlias).append('.').toString();
        return STR_GROUP_BY + alias + STR_FUID;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SearchIterator<FolderObject> getUserRootFoldersIterator(int userId, int[] memberInGroups, UserPermissionBits permissionBits, Context ctx) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection readCon;
        block10: {
            StringBuilder condBuilder = new StringBuilder(32).append("AND (ot.type = ").append(5).append(") AND (ot.parent = 0)");
            if (!permissionBits.hasFullSharedFolderAccess()) {
                condBuilder.append(" AND (ot.fuid != ").append(3).append(')');
            }
            if (!permissionBits.hasInfostore()) {
                condBuilder.append(" AND (ot.fuid != ").append(9).append(')');
            }
            String sqlSelectStr = OXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), OXFolderIteratorSQL.permissionIds(userId, memberInGroups, ctx), StringCollection.getSqlInString(permissionBits.getAccessibleModules()), condBuilder.toString(), OXFolderIteratorSQL.getRootOrderBy(STR_OT));
            condBuilder = null;
            readCon = null;
            stmt = null;
            rs = null;
            int contextId = ctx.getContextId();
            boolean closeResources = true;
            try {
                readCon = DBPool.pickup(ctx);
                stmt = readCon.prepareStatement(sqlSelectStr);
                int pos = 1;
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, userId);
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, contextId);
                rs = OXFolderIteratorSQL.executeQuery(stmt);
                closeResources = false;
                if (!closeResources) break block10;
            }
            catch (SQLException e) {
                try {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                    catch (RuntimeException t) {
                        throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
                    }
                }
                catch (Throwable throwable) {
                    if (closeResources) {
                        DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
                    }
                    throw throwable;
                }
            }
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
        }
        try {
            return new FolderObjectIterator(rs, stmt, true, ctx, readCon, true);
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
    }

    public static SearchIterator<FolderObject> getVisibleSubfoldersIterator(int parentFolderId, int userId, int[] groups, Context ctx, UserPermissionBits permissionBits, Timestamp since) throws SQLException, OXException {
        return OXFolderIteratorSQL.getVisibleSubfoldersIterator(parentFolderId, userId, groups, ctx, permissionBits, since, null);
    }

    public static SearchIterator<FolderObject> getVisibleSubfoldersIterator(int parentFolderId, int userId, int[] groups, Context ctx, UserPermissionBits permissionBits, Timestamp since, Connection con) throws SQLException, OXException {
        if (parentFolderId == 1) {
            return OXFolderIteratorSQL.getVisiblePrivateFolders(userId, groups, permissionBits.getAccessibleModules(), ctx, since, con);
        }
        if (parentFolderId == 2) {
            return OXFolderIteratorSQL.getVisiblePublicFolders(userId, groups, permissionBits.getAccessibleModules(), ctx, since, con);
        }
        if (parentFolderId == 3) {
            return OXFolderIteratorSQL.getVisibleSharedFolders(userId, groups, permissionBits.getAccessibleModules(), ctx, since, con);
        }
        FolderObject parentFolder = new OXFolderAccess(con, ctx).getFolderObject(parentFolderId);
        EffectivePermission effectivePerm = parentFolder.getEffectiveUserPermission(userId, permissionBits);
        if (((OCLPermission)effectivePerm).getFolderPermission() < 2) {
            return FolderObjectIterator.EMPTY_FOLDER_ITERATOR;
        }
        return OXFolderIteratorSQL.getVisibleSubfoldersIterator(parentFolder, userId, groups, permissionBits.getAccessibleModules(), ctx, since, con);
    }

    private static SearchIterator<FolderObject> getVisiblePrivateFolders(int userId, int[] groups, int[] accessibleModules, final Context ctx, Timestamp since, Connection con) throws OXException {
        ConditionTreeMap treeMap = ConditionTreeMapManagement.getInstance().optMapFor(ctx.getContextId());
        if (null != treeMap) {
            try {
                ArrayList<Condition> conditions = new ArrayList<Condition>(3);
                conditions.add(new ConditionTreeMap.PrivateCondition(userId));
                conditions.add(new ConditionTreeMap.ParentCondition(1));
                if (since != null) {
                    conditions.add(new ConditionTreeMap.LastModifiedCondition(since.getTime()));
                }
                TIntSet set = treeMap.getVisibleForUser(userId, groups, accessibleModules, conditions);
                List<FolderObject> list = ConditionTreeMap.asList(set, ctx, con);
                return new FolderObjectIterator(list, false);
            }
            catch (OXException e) {
                LOG.debug(STR_EMPTY, (Throwable)e);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                ThreadPoolService threadPool = ThreadPools.getThreadPool();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConditionTreeMapManagement.getInstance().getMapFor(ctx.getContextId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                if (null == threadPool) {
                    task.run();
                }
                threadPool.submit(ThreadPools.trackableTask((Runnable)task));
            }
        }
        StringBuilder condBuilder = new StringBuilder(32).append("AND (ot.type = ").append(1).append(" AND ot.created_from = ").append(userId).append(") AND (ot.parent = ").append(1).append(')');
        if (since != null) {
            condBuilder.append(" AND (changing_date > ").append(since.getTime()).append(')');
        }
        String sqlSelectStr = OXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), OXFolderIteratorSQL.permissionIds(userId, groups, ctx), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int contextId = ctx.getContextId();
        try {
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
            List<FolderObject> list = new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeCon).asList();
            if (list.size() >= 3 && (list.get(0).getModule() != 2 || list.get(1).getModule() != 3 || list.get(2).getModule() != 1)) {
                FolderObject[] defaultFolders = new FolderObject[]{list.remove(0), list.remove(0), list.remove(0)};
                OXFolderIteratorSQL.switchElements(defaultFolders);
                for (int i = 0; i < defaultFolders.length; ++i) {
                    list.add(i, defaultFolders[i]);
                }
            }
            return new FolderObjectIterator(list, false);
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
        catch (RuntimeException t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
        }
    }

    private static void switchElements(FolderObject[] folders2) {
        for (int i = 0; i < folders2.length; ++i) {
            boolean switched = false;
            for (int j = 0; j < DEF_MODULES.length && !switched; ++j) {
                if (folders2[i].getModule() != DEF_MODULES[j] || i == j) continue;
                FolderObject tmp = folders2[j];
                folders2[j] = folders2[i];
                folders2[i] = tmp;
                switched = true;
            }
        }
    }

    private static SearchIterator<FolderObject> getVisiblePublicFolders(int userId, int[] groups, int[] accessibleModules, Context ctx, Timestamp since, Connection con) throws OXException {
        SQLStuff sqlStuff = OXFolderIteratorSQL.getVisiblePublicFolders0(userId, groups, accessibleModules, ctx, since, con);
        try {
            return new FolderObjectIterator(sqlStuff.rs, sqlStuff.stmt, false, ctx, sqlStuff.readCon, sqlStuff.closeCon);
        }
        catch (OXException e) {
            DBUtils.closeResources(sqlStuff.rs, sqlStuff.stmt, sqlStuff.closeCon ? sqlStuff.readCon : null, true, ctx);
            throw e;
        }
    }

    private static SQLStuff getVisiblePublicFolders0(int userId, int[] groups, int[] accessibleModules, Context ctx, Timestamp since, Connection con) throws OXException {
        StringBuilder condBuilder = new StringBuilder(32).append("AND (ot.type = ").append(2).append(") AND (ot.parent = ").append(2).append(')');
        if (null != since) {
            condBuilder.append(" AND (changing_date > ").append(since.getTime()).append(')');
        }
        String sqlSelectStr = OXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), OXFolderIteratorSQL.permissionIds(userId, groups, ctx), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int contextId = ctx.getContextId();
        try {
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
            return new SQLStuff(stmt, rs, readCon, closeCon);
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
        catch (RuntimeException t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
        }
    }

    private static SearchIterator<FolderObject> getVisibleSharedFolders(int userId, int[] groups, int[] accessibleModules, Context ctx, Timestamp since, Connection con) throws OXException {
        return OXFolderIteratorSQL.getVisibleSharedFolders(userId, groups, accessibleModules, -1, ctx, since, con);
    }

    private static SearchIterator<FolderObject> getVisibleSubfoldersIterator(FolderObject parentFolder, int userId, int[] memberInGroups, int[] accessibleModules, final Context ctx, Timestamp since, Connection con) throws OXException {
        boolean shared = parentFolder.isShared(userId);
        ConditionTreeMap treeMap = ConditionTreeMapManagement.getInstance().optMapFor(ctx.getContextId());
        if (null != treeMap) {
            try {
                ArrayList<Condition> conditions = new ArrayList<Condition>(3);
                if (shared) {
                    conditions.add(new ConditionTreeMap.TypeCondition(3, userId));
                }
                conditions.add(new ConditionTreeMap.ParentCondition(parentFolder.getObjectID()));
                if (since != null) {
                    conditions.add(new ConditionTreeMap.LastModifiedCondition(since.getTime()));
                }
                TIntSet set = treeMap.getVisibleForUser(userId, memberInGroups, accessibleModules, conditions);
                List<FolderObject> list = ConditionTreeMap.asList(set, ctx, con);
                return new FolderObjectIterator(list, false);
            }
            catch (OXException e) {
                LOG.debug(STR_EMPTY, (Throwable)e);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                ThreadPoolService threadPool = ThreadPools.getThreadPool();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConditionTreeMapManagement.getInstance().getMapFor(ctx.getContextId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                if (null == threadPool) {
                    task.run();
                }
                threadPool.submit(ThreadPools.trackableTask((Runnable)task));
            }
        }
        StringBuilder condBuilder = new StringBuilder(32);
        if (shared) {
            condBuilder.append("AND (ot.type = ").append(1).append(" AND ot.created_from != ").append(userId).append(") ");
        }
        condBuilder.append("AND (ot.parent = ").append(parentFolder.getObjectID()).append(')');
        if (null != since) {
            condBuilder.append(" AND (changing_date > ").append(since.getTime()).append(')');
        }
        String sqlSelectStr = OXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), OXFolderIteratorSQL.permissionIds(userId, memberInGroups, ctx), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int contextId = ctx.getContextId();
        try {
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
        }
        try {
            return new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeCon);
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isVisibleFolder(int folderId, int userId, int[] memberInGroups, int[] accessibleModules, final Context ctx, Connection con) throws OXException {
        Connection connection;
        boolean bl;
        ConditionTreeMap treeMap = ConditionTreeMapManagement.getInstance().optMapFor(ctx.getContextId());
        if (null != treeMap) {
            try {
                return treeMap.isVisibleFolder(userId, memberInGroups, accessibleModules, folderId);
            }
            catch (Exception e) {
                LOG.debug(STR_EMPTY, (Throwable)e);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                ThreadPoolService threadPool = ThreadPools.getThreadPool();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConditionTreeMapManagement.getInstance().getMapFor(ctx.getContextId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                if (null == threadPool) {
                    task.run();
                }
                threadPool.submit(ThreadPools.trackableTask((Runnable)task));
            }
        }
        StringBuilder condBuilder = new StringBuilder(32);
        String fields = condBuilder.append(STR_OT).append(".fuid").toString();
        condBuilder.setLength(0);
        condBuilder.append("AND (ot.fuid = ").append(folderId).append(')');
        String sqlSelectStr = OXFolderIteratorSQL.getSQLUserVisibleFolders(fields, OXFolderIteratorSQL.permissionIds(userId, memberInGroups, ctx), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int contextId = ctx.getContextId();
        try {
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
            bl = rs.next();
            connection = closeCon ? readCon : null;
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                catch (RuntimeException t) {
                    throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
                throw throwable;
            }
        }
        DBUtils.closeResources(rs, (Statement)stmt, connection, true, ctx);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TIntList getVisibleSubfolders(int parent, int userId, int[] memberInGroups, int[] accessibleModules, final Context ctx, Connection con) throws OXException {
        TIntArrayList tIntArrayList;
        int contextId;
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeCon;
        Connection readCon;
        block12: {
            ConditionTreeMap treeMap = ConditionTreeMapManagement.getInstance().optMapFor(ctx.getContextId());
            if (null != treeMap) {
                try {
                    List<Condition> conditions = Collections.singletonList(new ConditionTreeMap.ParentCondition(parent));
                    return new TIntArrayList((TIntCollection)treeMap.getVisibleForUser(userId, memberInGroups, accessibleModules, conditions));
                }
                catch (Exception e) {
                    LOG.debug(STR_EMPTY, (Throwable)e);
                    ConditionTreeMapManagement.dropFor(ctx.getContextId());
                    ThreadPoolService threadPool = ThreadPools.getThreadPool();
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ConditionTreeMapManagement.getInstance().getMapFor(ctx.getContextId());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    if (null == threadPool) {
                        task.run();
                    }
                    threadPool.submit(ThreadPools.trackableTask((Runnable)task));
                }
            }
            StringBuilder condBuilder = new StringBuilder(32);
            String fields = condBuilder.append(STR_OT).append(".fuid").toString();
            condBuilder.setLength(0);
            condBuilder.append("AND (ot.parent = ").append(parent).append(')');
            String sqlSelectStr = OXFolderIteratorSQL.getSQLUserVisibleFolders(fields, OXFolderIteratorSQL.permissionIds(userId, memberInGroups, ctx), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
            readCon = con;
            closeCon = false;
            stmt = null;
            rs = null;
            contextId = ctx.getContextId();
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
            if (rs.next()) break block12;
            TIntArrayList tIntArrayList2 = new TIntArrayList(0);
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            return tIntArrayList2;
        }
        try {
            TIntArrayList retval = new TIntArrayList(16);
            do {
                retval.add(rs.getInt(1));
            } while (rs.next());
            tIntArrayList = retval;
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                catch (RuntimeException t) {
                    throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
                throw throwable;
            }
        }
        return tIntArrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasVisibleSharedFolders(int userId, int[] memberInGroups, int[] accessibleModules, int owner, Context ctx, Timestamp since, Connection con) throws OXException {
        Connection connection;
        Statement statement;
        ResultSet resultSet;
        boolean bl;
        SQLStuff stuff = OXFolderIteratorSQL.getVisibleSharedFolders0(userId, memberInGroups, accessibleModules, owner, ctx, since, con);
        try {
            bl = stuff.rs.next();
            resultSet = stuff.rs;
            statement = stuff.stmt;
            connection = stuff.closeCon ? stuff.readCon : null;
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw OXFolderExceptionCode.RUNTIME_ERROR.create(e2, EnumComponent.FOLDER, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(stuff.rs, stuff.stmt, stuff.closeCon ? stuff.readCon : null, true, ctx);
                throw throwable;
            }
        }
        DBUtils.closeResources(resultSet, statement, connection, true, ctx);
        return bl;
    }

    public static SearchIterator<FolderObject> getVisibleSharedFolders(int userId, int[] memberInGroups, int[] accessibleModules, int owner, final Context ctx, Timestamp since, Connection con) throws OXException {
        ConditionTreeMap treeMap = ConditionTreeMapManagement.getInstance().optMapFor(ctx.getContextId());
        if (null != treeMap) {
            try {
                ArrayList<Condition> conditions = new ArrayList<Condition>(3);
                conditions.add(new ConditionTreeMap.TypeCondition(3, userId));
                if (owner > -1) {
                    conditions.add(new ConditionTreeMap.CreatorCondition(owner));
                }
                if (since != null) {
                    conditions.add(new ConditionTreeMap.LastModifiedCondition(since.getTime()));
                }
                TIntSet set = treeMap.getVisibleForUser(userId, memberInGroups, accessibleModules, conditions);
                List<FolderObject> list = ConditionTreeMap.asList(set, ctx, con);
                return new FolderObjectIterator(list, false);
            }
            catch (OXException e) {
                LOG.debug(STR_EMPTY, (Throwable)e);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                ThreadPoolService threadPool = ThreadPools.getThreadPool();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConditionTreeMapManagement.getInstance().getMapFor(ctx.getContextId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                if (null == threadPool) {
                    task.run();
                }
                threadPool.submit(ThreadPools.trackableTask((Runnable)task));
            }
        }
        SQLStuff stuff = OXFolderIteratorSQL.getVisibleSharedFolders0(userId, memberInGroups, accessibleModules, owner, ctx, since, con);
        try {
            return new FolderObjectIterator(stuff.rs, stuff.stmt, false, ctx, stuff.readCon, stuff.closeCon);
        }
        catch (OXException e) {
            DBUtils.closeResources(stuff.rs, stuff.stmt, stuff.closeCon ? stuff.readCon : null, true, ctx);
            throw e;
        }
        catch (Exception e) {
            DBUtils.closeResources(stuff.rs, stuff.stmt, stuff.closeCon ? stuff.readCon : null, true, ctx);
            throw SearchIteratorExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()}).setPrefix("FLD");
        }
    }

    private static SQLStuff getVisibleSharedFolders0(int userId, int[] memberInGroups, int[] accessibleModules, int owner, Context ctx, Timestamp since, Connection con) throws OXException {
        StringBuilder condBuilder = new StringBuilder(32).append("AND (ot.type = ").append(1).append(" AND ot.created_from != ").append(userId).append(')');
        if (owner > -1) {
            condBuilder.append(" AND (ot.created_from = ").append(owner).append(')');
        }
        if (since != null) {
            condBuilder.append(" AND (changing_date > ").append(since.getTime()).append(')');
        }
        String sqlSelectStr = OXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), OXFolderIteratorSQL.permissionIds(userId, memberInGroups, ctx), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int contextId = ctx.getContextId();
        try {
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
        }
        return new SQLStuff(stmt, rs, readCon, closeCon);
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersNotSeenInTreeView(int userId, int[] groups, UserPermissionBits permissionBits, Context ctx) throws OXException {
        return OXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeViewNew(null, userId, groups, permissionBits, ctx, null);
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersNotSeenInTreeView(int userId, int[] groups, UserPermissionBits permissionBits, Context ctx, Connection readCon) throws OXException {
        return OXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeViewNew(null, userId, groups, permissionBits, ctx, readCon);
    }

    public static SearchIterator<FolderObject> getVisibleFoldersNotSeenInTreeView(int module, int userId, int[] groups, UserPermissionBits permissionBits, Context ctx, Connection readCon) throws OXException {
        return OXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeViewNew(module, userId, groups, permissionBits, ctx, readCon);
    }

    /*
     * Exception decompiling
     */
    public static boolean hasVisibleFoldersNotSeenInTreeView(int module, int userId, int[] groups, UserPermissionBits permissionBits, Context ctx, Connection readCon) throws OXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SearchIterator<FolderObject> getVisibleFoldersNotSeenInTreeViewNew(Integer module, int userId, int[] groups, UserPermissionBits permissionBits, Context ctx, Connection readCon) throws OXException {
        TIntIntHashMap fuid2parent;
        boolean closeResources;
        int contextId;
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection rc;
        block17: {
            FolderObjectIterator folderObjectIterator;
            block18: {
                block15: {
                    FolderObjectIterator folderObjectIterator2;
                    block16: {
                        rc = readCon;
                        closeReadCon = false;
                        stmt = null;
                        rs = null;
                        contextId = ctx.getContextId();
                        closeResources = true;
                        if (readCon == null) {
                            rc = DBPool.pickup(ctx);
                            closeReadCon = true;
                        }
                        StringBuilder condBuilder = new StringBuilder(32).append("AND (ot.type = ").append(2);
                        if (null != module) {
                            condBuilder.append(") AND (ot.module = ").append(module);
                        }
                        condBuilder.append(')');
                        stmt = rc.prepareStatement(OXFolderIteratorSQL.getSQLUserVisibleFolders("ot.fuid, ot.parent", OXFolderIteratorSQL.permissionIds(userId, groups, ctx), StringCollection.getSqlInString(permissionBits.getAccessibleModules()), condBuilder.toString(), OXFolderIteratorSQL.getSubfolderOrderBy(STR_OT)));
                        int pos = 1;
                        stmt.setInt(pos++, contextId);
                        stmt.setInt(pos++, contextId);
                        stmt.setInt(pos++, userId);
                        stmt.setInt(pos++, contextId);
                        stmt.setInt(pos++, contextId);
                        rs = OXFolderIteratorSQL.executeQuery(stmt);
                        if (rs.next()) break block15;
                        folderObjectIterator2 = FolderObjectIterator.EMPTY_FOLDER_ITERATOR;
                        if (!closeResources) break block16;
                        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
                    }
                    return folderObjectIterator2;
                }
                fuid2parent = new TIntIntHashMap(128);
                TIntHashSet fuids = new TIntHashSet(128);
                do {
                    int fuid = rs.getInt(1);
                    fuid2parent.put(fuid, rs.getInt(2));
                    fuids.add(fuid);
                } while (rs.next());
                DBUtils.closeSQLStuff(rs, stmt);
                rs = null;
                stmt = null;
                TIntIntIterator iterator = fuid2parent.iterator();
                while (iterator.hasNext()) {
                    iterator.advance();
                    int parent = iterator.value();
                    if (parent >= 20 && !fuids.contains(parent)) continue;
                    iterator.remove();
                }
                if (!fuid2parent.isEmpty()) break block17;
                folderObjectIterator = FolderObjectIterator.EMPTY_FOLDER_ITERATOR;
                if (!closeResources) break block18;
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
            }
            return folderObjectIterator;
        }
        try {
            stmt = rc.prepareStatement(STR_SELECT + FolderObjectIterator.getFieldsForSQL(STR_OT) + " FROM oxfolder_tree AS ot WHERE ot.cid = ? AND ot.fuid IN " + StringCollection.getSqlInString(fuid2parent.keys()) + ' ' + OXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
            stmt.setInt(1, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
            closeResources = false;
            if (closeResources) {
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
            }
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                catch (RuntimeException t) {
                    throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
                }
            }
            catch (Throwable throwable) {
                if (closeResources) {
                    DBUtils.closeResources(rs, stmt, closeReadCon ? rc : null, true, ctx);
                }
                throw throwable;
            }
        }
        try {
            return new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeReadCon);
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
            throw e;
        }
    }

    private static String buildQueryNonTreeVisibleFolders(Integer module, int userId, int[] groups, UserConfiguration userConfig, Context ctx) throws OXException {
        String sqlStr = OXFolderIteratorSQL.getSQLUserVisibleFolders("ot.fuid", OXFolderIteratorSQL.permissionIds(userId, groups, ctx), StringCollection.getSqlInString(userConfig.getAccessibleModules()), null, null);
        sqlStr = sqlStr.replaceAll("ot\\.", "pt.").replaceAll("op\\.", "pp.");
        sqlStr = sqlStr.replaceAll(" ot", " pt").replaceAll(" op", " pp");
        String regex = "\\?";
        String sContextId = String.valueOf(ctx.getContextId());
        String sUserId = String.valueOf(userId);
        sqlStr = sqlStr.replaceFirst("\\?", sContextId);
        sqlStr = sqlStr.replaceFirst("\\?", sContextId);
        sqlStr = sqlStr.replaceFirst("\\?", sUserId);
        sqlStr = sqlStr.replaceFirst("\\?", sContextId);
        sqlStr = sqlStr.replaceFirst("\\?", sContextId);
        StringBuilder condBuilder = new StringBuilder(32).append("AND ot.type = ").append(2);
        if (null != module) {
            condBuilder.append(" AND ot.module = ").append(module);
        }
        condBuilder.append(" AND ot.parent NOT IN (").append(sqlStr).append(')');
        return OXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), OXFolderIteratorSQL.permissionIds(userId, groups, ctx), StringCollection.getSqlInString(userConfig.getAccessibleModules()), condBuilder.toString(), OXFolderIteratorSQL.getOrderBy(STR_OT, "module", STR_FNAME));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SearchIterator<FolderObject> getVisibleFoldersNotSeenInTreeView(Integer module, int userId, int[] groups, UserConfiguration userConfig, Context ctx, Connection readCon) throws OXException {
        FolderObjectIterator folderObjectIterator;
        int size;
        Queue<FolderObject> q;
        int pos;
        int contextId;
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection rc;
        block12: {
            rc = readCon;
            closeReadCon = false;
            stmt = null;
            rs = null;
            contextId = ctx.getContextId();
            if (readCon == null) {
                rc = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            pos = 1;
            StringBuilder condBuilder = new StringBuilder(32).append("AND ot.type = ").append(2);
            if (null != module) {
                condBuilder.append(" AND ot.module = ").append(module);
            }
            String sqlSelectStr = OXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), OXFolderIteratorSQL.permissionIds(userId, groups, ctx), StringCollection.getSqlInString(userConfig.getAccessibleModules()), condBuilder.toString(), OXFolderIteratorSQL.getOrderBy(STR_OT, "module", STR_FNAME));
            stmt = rc.prepareStatement(sqlSelectStr);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
            q = new FolderObjectIterator(rs, stmt, false, ctx, rc, closeReadCon).asQueue();
            size = q.size();
            if (size != 0) break block12;
            rs = null;
            stmt = null;
            rc = null;
            FolderObjectIterator folderObjectIterator2 = FolderObjectIterator.EMPTY_FOLDER_ITERATOR;
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
            return folderObjectIterator2;
        }
        try {
            if (readCon == null) {
                rc = DBPool.pickup(ctx);
            }
            stmt = rc.prepareStatement(null == module ? SQL_SEL_ALL_PUB : SQL_SEL_ALL_PUB_MODULE);
            pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, 2);
            if (null != module) {
                stmt.setInt(pos, module);
            }
            rs = OXFolderIteratorSQL.executeQuery(stmt);
            TIntHashSet nonVisibleSet = new TIntHashSet(1024);
            while (rs.next()) {
                nonVisibleSet.add(rs.getInt(1));
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            nonVisibleSet.removeAll((TIntCollection)OXFolderIteratorSQL.queue2IDSet(q, size));
            Iterator iter = q.iterator();
            while (iter.hasNext()) {
                if (nonVisibleSet.contains(((FolderObject)iter.next()).getParentFolderID())) continue;
                iter.remove();
            }
            folderObjectIterator = new FolderObjectIterator(q, false);
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                catch (RuntimeException t) {
                    throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, stmt, closeReadCon ? rc : null, true, ctx);
                throw throwable;
            }
        }
        return folderObjectIterator;
    }

    private static TIntSet queue2IDSet(Queue<FolderObject> q, int size) {
        TIntHashSet retval = new TIntHashSet(size);
        Iterator iter = q.iterator();
        int i = size;
        while (i-- > 0) {
            retval.add(((FolderObject)iter.next()).getObjectID());
        }
        return retval;
    }

    public static SearchIterator<FolderObject> getFoldersOnPathToRoot(int folderId, int userId, UserPermissionBits permissionBits, Locale locale, Context ctx) throws OXException {
        ArrayList<FolderObject> folderList = new ArrayList<FolderObject>();
        OXFolderIteratorSQL.fillAncestor(folderList, folderId, userId, permissionBits, locale, null, ctx);
        return new FolderObjectIterator(folderList, false);
    }

    private static void fillAncestor(List<FolderObject> folderList, int folderId, int userId, UserPermissionBits permissionBits, Locale locale, UserStorage userStoreArg, Context ctx) throws OXException {
        OXFolderAccess access = new OXFolderAccess(ctx);
        if (OXFolderIteratorSQL.checkForSpecialFolder(folderList, folderId, locale, access)) {
            return;
        }
        UserStorage userStore = userStoreArg;
        FolderObject fo = access.getFolderObject(folderId);
        int contextId = ctx.getContextId();
        try {
            if (!fo.getEffectiveUserPermission(userId, permissionBits).isFolderVisible()) {
                if (folderList.isEmpty()) {
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(folderId, OXFolderUtility.getUserName(userId, ctx), contextId);
                }
                return;
            }
            if (fo.isShared(userId)) {
                String creatorDisplayName;
                folderList.add(fo);
                if (userStore == null) {
                    userStore = UserStorage.getInstance();
                }
                try {
                    creatorDisplayName = userStore.getUser(fo.getCreatedBy(), ctx).getDisplayName();
                }
                catch (OXException e) {
                    if (fo.getCreatedBy() != 0) {
                        throw e;
                    }
                    StringHelper strHelper = StringHelper.valueOf(locale);
                    creatorDisplayName = strHelper.getString("All users");
                }
                FolderObject virtualOwnerFolder = FolderObject.createVirtualFolderObject(SHARED_PREFIX + fo.getCreatedBy(), creatorDisplayName, 5, true, 5);
                folderList.add(virtualOwnerFolder);
                fo = access.getFolderObject(3);
                fo.setFolderName(FolderObject.getFolderString(3, locale));
                folderList.add(fo);
                return;
            }
            if (fo.getType() == 2 && OXFolderIteratorSQL.hasNonVisibleParent(fo, userId, permissionBits, access)) {
                int virtualParent;
                folderList.add(fo);
                switch (fo.getModule()) {
                    case 1: {
                        virtualParent = 11;
                        break;
                    }
                    case 2: {
                        virtualParent = 12;
                        break;
                    }
                    case 3: {
                        virtualParent = 13;
                        break;
                    }
                    case 8: {
                        virtualParent = 14;
                        break;
                    }
                    default: {
                        throw OXFolderExceptionCode.UNKNOWN_MODULE.create(STR_EMPTY, OXFolderUtility.folderModule2String(fo.getModule()), contextId);
                    }
                }
                OXFolderIteratorSQL.checkForSpecialFolder(folderList, virtualParent, locale, access);
                return;
            }
            folderList.add(fo);
            if (fo.getParentFolderID() != 0) {
                OXFolderIteratorSQL.fillAncestor(folderList, fo.getParentFolderID(), userId, permissionBits, locale, userStore, ctx);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
        }
    }

    private static boolean checkForSpecialFolder(List<FolderObject> folderList, int folderId, Locale locale, OXFolderAccess access) throws OXException {
        boolean publicParent;
        FolderObject specialFolder;
        switch (folderId) {
            case 6: {
                specialFolder = access.getFolderObject(folderId);
                specialFolder.setFolderName(FolderObject.getFolderString(6, locale));
                publicParent = true;
                break;
            }
            case 11: {
                specialFolder = FolderObject.createVirtualFolderObject(11, FolderObject.getFolderString(11, locale), 5, true, 5);
                publicParent = true;
                break;
            }
            case 12: {
                specialFolder = FolderObject.createVirtualFolderObject(12, FolderObject.getFolderString(12, locale), 5, true, 5);
                publicParent = true;
                break;
            }
            case 13: {
                specialFolder = FolderObject.createVirtualFolderObject(13, FolderObject.getFolderString(13, locale), 5, true, 5);
                publicParent = true;
                break;
            }
            case 14: {
                specialFolder = FolderObject.createVirtualFolderObject(14, FolderObject.getFolderString(14, locale), 5, true, 5);
                publicParent = false;
                break;
            }
            default: {
                return false;
            }
        }
        folderList.add(specialFolder);
        int parentId = publicParent ? 2 : 9;
        FolderObject parent = access.getFolderObject(parentId);
        parent.setFolderName(FolderObject.getFolderString(parentId, locale));
        folderList.add(parent);
        return true;
    }

    private static boolean hasNonVisibleParent(FolderObject fo, int userId, UserPermissionBits permissionBits, OXFolderAccess access) throws OXException, SQLException {
        if (fo.getParentFolderID() == 0) {
            return false;
        }
        return !access.getFolderObject(fo.getParentFolderID()).getEffectiveUserPermission(userId, permissionBits).isFolderVisible();
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersIteratorOfType(int userId, int[] memberInGroups, int[] accessibleModules, int type, int[] modules, Context ctx) throws OXException {
        return OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, memberInGroups, accessibleModules, type, modules, null, ctx, null);
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersIteratorOfType(int userId, int[] memberInGroups, int[] accessibleModules, int type, int[] modules, Context ctx, Connection con) throws OXException {
        return OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, memberInGroups, accessibleModules, type, modules, null, ctx, con);
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersIteratorOfType(int userId, int[] memberInGroups, int[] accessibleModules, int type, int[] modules, int parent, Context ctx) throws OXException {
        return OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, memberInGroups, accessibleModules, type, modules, parent, ctx, null);
    }

    private static SearchIterator<FolderObject> getAllVisibleFoldersIteratorOfType(int userId, int[] memberInGroups, int[] accessibleModules, int type, int[] modules, Integer parent, final Context ctx, Connection con) throws OXException {
        ConditionTreeMap treeMap = ConditionTreeMapManagement.getInstance().optMapFor(ctx.getContextId());
        if (null != treeMap) {
            try {
                ArrayList<Condition> conditions = new ArrayList<Condition>(3);
                TIntHashSet set = new TIntHashSet(modules);
                set.retainAll(accessibleModules);
                if (set.isEmpty()) {
                    return FolderObjectIterator.EMPTY_FOLDER_ITERATOR;
                }
                conditions.add(new ConditionTreeMap.ModulesCondition((TIntCollection)set));
                conditions.add(new ConditionTreeMap.TypeCondition(type, userId));
                if (parent != null) {
                    conditions.add(new ConditionTreeMap.ParentCondition(parent));
                }
                set = treeMap.getVisibleForUser(userId, memberInGroups, accessibleModules, conditions);
                List<FolderObject> list = ConditionTreeMap.asList((TIntSet)set, ctx, con);
                return new FolderObjectIterator(list, false);
            }
            catch (OXException e) {
                LOG.debug(STR_EMPTY, (Throwable)e);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                ThreadPoolService threadPool = ThreadPools.getThreadPool();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConditionTreeMapManagement.getInstance().getMapFor(ctx.getContextId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                if (null == threadPool) {
                    task.run();
                }
                threadPool.submit(ThreadPools.trackableTask((Runnable)task));
            }
        }
        StringBuilder condBuilder = new StringBuilder(32);
        if (null != modules && modules.length > 0) {
            if (1 == modules.length) {
                condBuilder.append("AND (ot.module = ").append(modules[0]).append(')');
            } else {
                condBuilder.append("AND (ot.module IN (");
                condBuilder.append(modules[0]);
                for (int i = 1; i < modules.length; ++i) {
                    condBuilder.append(", ").append(modules[i]);
                }
                condBuilder.append("))");
            }
        }
        if (type == 3) {
            condBuilder.append(" AND (ot.type = ").append(1);
            condBuilder.append(" AND ot.created_from != ").append(userId).append(')');
        } else {
            condBuilder.append(" AND (ot.type = ").append(type).append(')');
        }
        if (parent != null) {
            condBuilder.append(" AND (ot.parent = ").append(parent).append(')');
        }
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int contextId = ctx.getContextId();
        try {
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(OXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), OXFolderIteratorSQL.permissionIds(userId, memberInGroups, ctx), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderIteratorSQL.getSubfolderOrderBy(STR_OT)));
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException t) {
            DBUtils.closeResources(rs, stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
        }
        try {
            return new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeCon);
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersIteratorOfModule(int userId, int[] memberInGroups, int[] accessibleModules, int module, Context ctx) throws OXException {
        return OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfModule(userId, memberInGroups, accessibleModules, module, ctx, null);
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersIteratorOfModule(int userId, int[] memberInGroups, int[] accessibleModules, int module, final Context ctx, Connection readConArg) throws OXException {
        ConditionTreeMap treeMap = ConditionTreeMapManagement.getInstance().optMapFor(ctx.getContextId());
        if (null != treeMap) {
            try {
                TIntSet set = treeMap.getVisibleModuleForUser(userId, memberInGroups, accessibleModules, module);
                List<FolderObject> list = ConditionTreeMap.asList(set, ctx, readConArg);
                return new FolderObjectIterator(list, false);
            }
            catch (OXException e) {
                LOG.debug(STR_EMPTY, (Throwable)e);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                ThreadPoolService threadPool = ThreadPools.getThreadPool();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConditionTreeMapManagement.getInstance().getMapFor(ctx.getContextId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                if (null == threadPool) {
                    task.run();
                }
                threadPool.submit(ThreadPools.trackableTask((Runnable)task));
            }
        }
        String sqlSelectStr = OXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), OXFolderIteratorSQL.permissionIds(userId, memberInGroups, ctx), StringCollection.getSqlInString(accessibleModules), new StringAllocator("AND (ot.module = ").append(module).append(')').toString(), OXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        boolean closeReadCon = readConArg == null;
        int contextId = ctx.getContextId();
        Connection readCon = closeReadCon ? DBPool.pickup(ctx) : readConArg;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
        }
        try {
            return new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeReadCon);
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw e;
        }
    }

    public static SearchIterator<FolderObject> getDeletedFoldersSince(Date since, int userId, int[] memberInGroups, int[] accessibleModules, Context ctx) throws OXException {
        return OXFolderIteratorSQL.getDeletedFoldersSince(since, userId, memberInGroups, accessibleModules, ctx, null);
    }

    public static SearchIterator<FolderObject> getDeletedFoldersSince(Date since, int userId, int[] memberInGroups, int[] accessibleModules, Context ctx, Connection con) throws OXException {
        String fields = FolderObjectIterator.getFieldsForSQL(STR_OT);
        String condition = since == null ? null : " AND (ot.changing_date > " + since.getTime() + ')';
        String sqlSelectStr = OXFolderIteratorSQL.getSQLUserVisibleFolders("del_oxfolder_tree", "del_oxfolder_permissions", fields, OXFolderIteratorSQL.permissionIds(userId, memberInGroups, ctx), StringCollection.getSqlInString(accessibleModules), condition, "ORDER by ot.fuid", false);
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int contextId = ctx.getContextId();
        try {
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
        }
        try {
            return new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeCon).releaseCache();
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
    }

    public static SearchIterator<FolderObject> getModifiedFoldersSince(Date since, int userId, int[] memberInGroups, int[] accessibleModules, boolean userFoldersOnly, Context ctx) throws OXException {
        StringBuilder condBuilder = new StringBuilder(32).append("AND (changing_date > ").append(since.getTime()).append(") AND (module IN ").append(SQL_IN_STR_STANDARD_MODULES).append(')');
        if (userFoldersOnly) {
            condBuilder.append(" AND (ot.created_from = ").append(userId).append(") ");
        }
        String sqlSelectStr = OXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), OXFolderIteratorSQL.permissionIds(userId, memberInGroups, ctx), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int contextId = ctx.getContextId();
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, contextId);
            rs = OXFolderIteratorSQL.executeQuery(stmt);
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, contextId);
        }
        try {
            return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
    }

    public static SearchIterator<FolderObject> getAllModifiedFoldersSince(Date since, Context ctx) throws OXException {
        return OXFolderIteratorSQL.getAllModifiedFoldersSince(since, ctx, null);
    }

    public static SearchIterator<FolderObject> getAllModifiedFoldersSince(Date since, Context ctx, Connection con) throws OXException {
        StringBuilder sb = new StringBuilder(256).append(STR_SELECT);
        sb.append(FolderObjectIterator.getFieldsForSQL(STR_OT)).append(" FROM oxfolder_tree AS ot");
        long time = since.getTime();
        if (time > 0L) {
            sb.append(" WHERE (cid = ").append(ctx.getContextId()).append(')');
            sb.append(" AND (changing_date > ").append(time).append(')');
        } else {
            sb.append(" WHERE (cid = ").append(ctx.getContextId()).append(')');
        }
        sb.append(" AND (module IN ").append(SQL_IN_STR_STANDARD_MODULES_ALL);
        sb.append(") ").append(OXFolderProperties.isEnableDBGrouping() ? OXFolderIteratorSQL.getGroupBy(STR_OT) : null).append(" ORDER by ot.fuid").toString();
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sb.toString());
            rs = OXFolderIteratorSQL.executeQuery(stmt);
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        try {
            return new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeCon);
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
    }

    private static ResultSet executeQuery(PreparedStatement stmt) throws SQLException {
        try {
            return stmt.executeQuery();
        }
        catch (SQLException e) {
            if ("MySQLSyntaxErrorException".equals(e.getClass().getSimpleName())) {
                String sql = stmt.toString();
                LOG.error("\nFollowing SQL query contains syntax errors:\n{}", (Object)sql.substring(sql.indexOf(": ") + 2));
            }
            throw e;
        }
    }

    private static String permissionIds(int userId, int[] memberInGroups, Context ctx) throws OXException {
        int[] groups = memberInGroups;
        if (!(null != groups && 0 != groups.length || null != (groups = UserStorage.getInstance().getUser(userId, ctx).getGroups()) && 0 != groups.length)) {
            groups = new int[]{0};
        }
        return StringCollection.getSqlInString(userId, groups);
    }

    private static final class SQLStuff {
        final ResultSet rs;
        final Statement stmt;
        final Connection readCon;
        final boolean closeCon;

        SQLStuff(Statement stmt, ResultSet rs, Connection readCon, boolean closeCon) {
            this.stmt = stmt;
            this.rs = rs;
            this.closeCon = closeCon;
            this.readCon = readCon;
        }
    }

    public static final class Parameter {
        private final int user;
        private final int[] groups;
        private final UserConfiguration userConfig;
        private final Context ctx;
        private Date since;
        private Connection con;
        private int folderId;
        private int module;
        private int type;

        public Parameter(int user, int[] groups, UserConfiguration userConfig, Context ctx) {
            this.user = user;
            this.groups = groups;
            this.userConfig = userConfig;
            this.ctx = ctx;
        }

        public Parameter since(Date since) {
            this.since = since;
            return this;
        }

        public Parameter connection(Connection con) {
            this.con = con;
            return this;
        }

        public Parameter folderId(int folderId) {
            this.folderId = folderId;
            return this;
        }

        public Parameter module(int module) {
            this.module = module;
            return this;
        }

        public Parameter type(int type) {
            this.type = type;
            return this;
        }
    }
}

