/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.transformations;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.java.Streams;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.images.ImageTransformationUtility;
import com.openexchange.tools.images.ImageTransformations;
import com.openexchange.tools.images.ScaleType;
import com.openexchange.tools.images.TransformedImage;
import com.openexchange.tools.images.impl.ImageInformation;
import com.openexchange.tools.images.transformations.CropTransformation;
import com.openexchange.tools.images.transformations.ImageTransformation;
import com.openexchange.tools.images.transformations.RotateTransformation;
import com.openexchange.tools.images.transformations.ScaleTransformation;
import com.openexchange.tools.images.transformations.TransformationContext;
import com.openexchange.tools.images.transformations.TransformedImageImpl;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTransformationsImpl
implements ImageTransformations {
    private static Logger LOG = LoggerFactory.getLogger(ImageTransformationsImpl.class);
    private final TransformationContext transformationContext;
    private final InputStream sourceImageStream;
    private final List<ImageTransformation> transformations;
    private BufferedImage sourceImage;
    private Metadata metadata;
    private boolean compress;

    private ImageTransformationsImpl(BufferedImage sourceImage, InputStream sourceImageStream) {
        this.sourceImage = sourceImage;
        this.sourceImageStream = sourceImageStream;
        this.transformations = new ArrayList<ImageTransformation>();
        this.transformationContext = new TransformationContext();
    }

    public ImageTransformationsImpl(BufferedImage sourceImage) {
        this(sourceImage, null);
    }

    public ImageTransformationsImpl(InputStream sourceImageStream) throws IOException {
        this(null, sourceImageStream);
    }

    @Override
    public ImageTransformations rotate() {
        this.transformations.add(new RotateTransformation());
        return this;
    }

    @Override
    public ImageTransformations scale(int maxWidth, int maxHeight, ScaleType scaleType) {
        this.transformations.add(new ScaleTransformation(maxWidth, maxHeight, scaleType));
        return this;
    }

    @Override
    public ImageTransformations crop(int x, int y, int width, int height) {
        this.transformations.add(new CropTransformation(x, y, width, height));
        return this;
    }

    @Override
    public ImageTransformations compress() {
        this.compress = true;
        return this;
    }

    @Override
    public BufferedImage getImage() throws IOException {
        if (!this.needsTransformation(null) && null != this.sourceImage) {
            return this.sourceImage;
        }
        return this.getImage(null);
    }

    @Override
    public byte[] getBytes(String formatName) throws IOException {
        String imageFormat = ImageTransformationUtility.getImageFormat(formatName);
        return this.innerGetBytes(imageFormat);
    }

    private byte[] innerGetBytes(String imageFormat) throws IOException {
        return this.write(this.getImage(imageFormat), imageFormat);
    }

    @Override
    public InputStream getInputStream(String formatName) throws IOException {
        String imageFormat = ImageTransformationUtility.getImageFormat(formatName);
        if (!this.needsTransformation(imageFormat) && null != this.sourceImageStream) {
            return this.sourceImageStream;
        }
        byte[] bytes = this.innerGetBytes(imageFormat);
        return null == bytes ? null : Streams.newByteArrayInputStream((byte[])bytes);
    }

    @Override
    public TransformedImage getTransformedImage(String formatName) throws IOException {
        String imageFormat = ImageTransformationUtility.getImageFormat(formatName);
        BufferedImage bufferedImage = this.getImage(imageFormat);
        return this.writeTransformedImage(bufferedImage, imageFormat);
    }

    private boolean needsTransformation(String formatName) {
        if (!ImageTransformationUtility.canRead(formatName)) {
            return false;
        }
        for (ImageTransformation transformation : this.transformations) {
            if (!transformation.supports(formatName)) continue;
            return true;
        }
        return false;
    }

    private BufferedImage getImage(String formatName) throws IOException {
        BufferedImage image = this.getSourceImage(formatName);
        if (null != image && image.getHeight() > 3 && image.getWidth() > 3) {
            ImageInformation imageInformation = null != this.metadata ? ImageTransformationsImpl.getImageInformation(this.metadata) : null;
            for (ImageTransformation transformation : this.transformations) {
                if (!transformation.supports(formatName)) continue;
                image = transformation.perform(image, this.transformationContext, imageInformation);
            }
        }
        image = ImageTransformationsImpl.removeTransparencyIfNeeded(image, formatName);
        return image;
    }

    private BufferedImage getSourceImage(String formatName) throws IOException {
        if (null == this.sourceImage && null != this.sourceImageStream) {
            this.sourceImage = this.needsMetadata(formatName) ? this.readAndExtractMetadata(this.sourceImageStream, formatName) : this.read(this.sourceImageStream, formatName);
        }
        return this.sourceImage;
    }

    private boolean needsMetadata(String formatName) {
        if (null == formatName || 0 == formatName.length()) {
            return false;
        }
        for (ImageTransformation transformation : this.transformations) {
            if (!transformation.supports(formatName) || !transformation.needsImageInformation()) continue;
            return true;
        }
        return false;
    }

    private TransformedImage writeTransformedImage(BufferedImage image, String formatName) throws IOException {
        TransformedImageImpl transformedImageImpl;
        if (null == image) {
            return null;
        }
        DigestOutputStream digestOutputStream = null;
        UnsynchronizedByteArrayOutputStream outputStream = null;
        try {
            outputStream = new UnsynchronizedByteArrayOutputStream(8192);
            digestOutputStream = new DigestOutputStream((OutputStream)outputStream, MessageDigest.getInstance("MD5"));
            if (this.needsCompression(formatName)) {
                ImageTransformationsImpl.writeCompressed(image, formatName, digestOutputStream, this.transformationContext);
            } else {
                ImageTransformationsImpl.write(image, formatName, digestOutputStream);
            }
            byte[] imageData = outputStream.toByteArray();
            byte[] md5 = digestOutputStream.getMessageDigest().digest();
            long size = null != imageData ? (long)imageData.length : 0L;
            transformedImageImpl = new TransformedImageImpl(image.getWidth(), image.getHeight(), size, formatName, imageData, md5, this.transformationContext.getExpenses());
        }
        catch (NoSuchAlgorithmException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{digestOutputStream, outputStream});
                throw throwable;
            }
        }
        Streams.close((Closeable[])new Closeable[]{digestOutputStream, outputStream});
        return transformedImageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] write(BufferedImage image, String formatName) throws IOException {
        byte[] byArray;
        if (null == image) {
            return null;
        }
        UnsynchronizedByteArrayOutputStream outputStream = null;
        try {
            outputStream = new UnsynchronizedByteArrayOutputStream(8192);
            if (this.needsCompression(formatName)) {
                ImageTransformationsImpl.writeCompressed(image, formatName, (OutputStream)outputStream, this.transformationContext);
            } else {
                ImageTransformationsImpl.write(image, formatName, (OutputStream)outputStream);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Streams.close(outputStream);
            throw throwable;
        }
        Streams.close((Closeable)outputStream);
        return byArray;
    }

    private boolean needsCompression(String formatName) {
        return this.compress && null != formatName && "jpeg".equalsIgnoreCase(formatName) || "jpg".equalsIgnoreCase(formatName);
    }

    private static void write(BufferedImage image, String formatName, OutputStream output) throws IOException {
        if (!ImageIO.write((RenderedImage)image, formatName, output)) {
            throw new IOException("no appropriate writer found for " + formatName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCompressed(BufferedImage image, String formatName, OutputStream output, TransformationContext transformationContext) throws IOException {
        ImageWriter writer = null;
        ImageInputStream imageOutputStream = null;
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
            if (!(null != iter && iter.hasNext() || null != (iter = ImageIO.getImageWritersByMIMEType(formatName)) && iter.hasNext())) {
                throw new IOException("No image writer for format " + formatName);
            }
            writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            ImageTransformationsImpl.adjustCompressionParams(iwp);
            imageOutputStream = ImageIO.createImageOutputStream(output);
            writer.setOutput(imageOutputStream);
            IIOImage iioImage = new IIOImage(image, null, null);
            writer.write(null, iioImage, iwp);
            transformationContext.addExpense(1);
        }
        finally {
            if (null != writer) {
                writer.dispose();
            }
            if (null != imageOutputStream) {
                imageOutputStream.close();
            }
        }
    }

    private static void adjustCompressionParams(ImageWriteParam parameters) {
        try {
            parameters.setCompressionMode(2);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("", (Throwable)e);
        }
        try {
            parameters.setProgressiveMode(1);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("", (Throwable)e);
        }
        try {
            parameters.setCompressionQuality(0.8f);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage read(InputStream inputStream, String formatName) throws IOException {
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (RuntimeException e) {
            LOG.debug("error reading image from stream for {}", (Object)formatName, (Object)e);
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            Streams.close((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readAndExtractMetadata(InputStream inputStream, String formatName) throws IOException {
        ManagedFile managedFile = null;
        try {
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            managedFile = mfm.createManagedFile(inputStream);
            try {
                this.metadata = ImageMetadataReader.readMetadata((BufferedInputStream)new BufferedInputStream(managedFile.getInputStream(), 65536), (boolean)false);
            }
            catch (ImageProcessingException e) {
                LOG.warn("error getting metadata for {}", (Object)formatName, (Object)e);
            }
            BufferedImage bufferedImage = ImageIO.read(managedFile.getInputStream());
            return bufferedImage;
        }
        catch (OXException e) {
            throw new IOException("error accessing managed file", e);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("error reading image from stream for {}", (Object)formatName, (Object)e);
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            if (managedFile != null) {
                try {
                    managedFile.delete();
                }
                catch (Exception x) {}
            }
        }
    }

    private static ImageInformation getImageInformation(Metadata metadata) {
        if (null == metadata) {
            return null;
        }
        int orientation = 1;
        int width = 0;
        int height = 0;
        try {
            JpegDirectory jpegDirectory;
            Directory directory = metadata.getDirectory(ExifIFD0Directory.class);
            if (null != directory) {
                orientation = directory.getInt(274);
            }
            if (null != (jpegDirectory = (JpegDirectory)metadata.getDirectory(JpegDirectory.class))) {
                width = jpegDirectory.getImageWidth();
                height = jpegDirectory.getImageHeight();
            }
        }
        catch (MetadataException e) {
            LOG.debug("Unable to retrieve image information.", (Throwable)e);
            return null;
        }
        return new ImageInformation(orientation, width, height);
    }

    private static BufferedImage removeTransparencyIfNeeded(BufferedImage image, String formatName) {
        ColorModel colorModel;
        if (null != image && null != formatName && !ImageTransformationUtility.supportsTransparency(formatName) && null != (colorModel = image.getColorModel()) && colorModel.hasAlpha()) {
            BufferedImage targetImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            Graphics2D graphics = targetImage.createGraphics();
            graphics.drawImage(image, 0, 0, Color.WHITE, null);
            graphics.dispose();
            return targetImage;
        }
        return image;
    }
}

