/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.tools.file.external.FileStorageCodes;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class State {
    private static final Logger LOG = LoggerFactory.getLogger(State.class);
    private static final long serialVersionUID = 1064393846000L;
    private final int entries;
    private final int depth;
    private final Set<String> unused;
    private String nextEntry;

    State(int depth, int entries, String nextEntry) {
        this.entries = entries;
        this.depth = depth;
        this.nextEntry = nextEntry;
        this.unused = new HashSet<String>();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    State(InputStream input) throws OXException {
        InputStreamReader isr = null;
        BufferedReader reader = null;
        try {
            isr = new InputStreamReader(input, Charsets.ISO_8859_1);
            reader = new BufferedReader(isr);
            this.depth = Integer.parseInt(reader.readLine());
            this.entries = Integer.parseInt(reader.readLine());
            this.nextEntry = reader.readLine();
            this.unused = new HashSet<String>();
            String line = reader.readLine();
            while (line != null) {
                this.unused.add(line);
                line = reader.readLine();
            }
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw FileStorageCodes.ENCODING.create(e, new Object[0]);
                catch (NumberFormatException e2) {
                    throw FileStorageCodes.NO_NUMBER.create(e2, new Object[0]);
                }
                catch (IOException e3) {
                    throw FileStorageCodes.IOERROR.create(e3, e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{reader, isr});
                throw throwable;
            }
        }
        Streams.close((Closeable[])new Closeable[]{reader, isr});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InputStream saveState() throws OXException {
        ByteArrayInputStream byteArrayInputStream;
        BufferedWriter writer = null;
        try {
            UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream();
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "ISO-8859-1"));
            writer.write(String.valueOf(this.depth));
            writer.newLine();
            writer.write(String.valueOf(this.entries));
            writer.newLine();
            writer.write(this.nextEntry);
            writer.newLine();
            Iterator<String> iter = this.unused.iterator();
            while (iter.hasNext()) {
                writer.write(iter.next());
                writer.newLine();
            }
            writer.flush();
            byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw FileStorageCodes.ENCODING.create(e, new Object[0]);
                catch (IOException e2) {
                    throw FileStorageCodes.IOERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                Streams.close(writer);
                throw throwable;
            }
        }
        Streams.close((Closeable)writer);
        return byteArrayInputStream;
    }

    public String getNextEntry() {
        return this.nextEntry;
    }

    public void setNextEntry(String nextEntry) {
        this.nextEntry = nextEntry;
    }

    public void addUnused(String entry) {
        this.unused.add(entry);
    }

    public boolean hasUnused() {
        return !this.unused.isEmpty();
    }

    public String getUnused() {
        String retval = null;
        if (!this.unused.isEmpty()) {
            Iterator<String> iter = this.unused.iterator();
            retval = iter.next();
            iter.remove();
        }
        return retval;
    }
}

