/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.external;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum FileStorageCodes implements DisplayableOXExceptionCode
{
    IOERROR("An IO error occurred: %s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_SERVICE_DOWN, 3),
    INSTANTIATIONERROR("File store could not be accessed: %s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_SERVICE_DOWN, 4),
    CREATE_DIR_FAILED("Cannot create directory \"%1$s\" in file storage.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_CONFIGURATION, 6),
    ENCODING("Unsupported encoding.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 9),
    NO_NUMBER("Number parsing problem.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 10),
    STORE_FULL("File storage is full.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_CAPACITY, 11),
    DEPTH_MISMATCH("'Depth' mismatch while computing next entry.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 12),
    UNLOCK("Cannot remove lock file.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_SERVICE_DOWN, 13),
    LOCK("Cannot create lock file here %1$s. Please check for a stale .lock file, inappropriate permissions or usage of the file store for too long a time.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_SERVICE_DOWN, 14),
    NOT_ELIMINATED("Eliminating the file storage failed.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_SERVICE_DOWN, 16),
    FILE_NOT_FOUND("File does not exist in file store \"%1$s\". Consider running the consistency tool.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_SERVICE_DOWN, 17),
    INVALID_RANGE("The requested range (offset: %1$d, length: %2$d) for the file \"%3$s\" (current size: %4$d) is invalid.", "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later.", Category.CATEGORY_USER_INPUT, 18),
    INVALID_OFFSET("The specified offset %1$d for the file \"%2$s\" (current size: %3$d) is invalid.", "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later.", Category.CATEGORY_USER_INPUT, 19),
    INVALID_LENGTH("The specified length %1$d for the file \"%2$s\" (current size: %3$d) is invalid.", "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later.", Category.CATEGORY_USER_INPUT, 20);

    private final String message;
    private final String displayMessage;
    private final Category category;
    private final int number;

    private FileStorageCodes(String message, String displayMessage, Category category, int detailNumber) {
        this.message = message;
        this.displayMessage = displayMessage;
        this.category = category;
        this.number = detailNumber;
    }

    public String getPrefix() {
        return "FLS";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

