/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.external.FileStorageCodes;
import com.openexchange.tools.file.external.QuotaFileStorageFactory;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import java.util.SortedSet;

public final class QuotaFileStorage
extends FileStorage {
    private static volatile QuotaFileStorageFactory qfss;
    private com.openexchange.tools.file.external.QuotaFileStorage qfs;

    private QuotaFileStorage(URI uri, Context ctx, QuotaFileStorageFactory qfss) throws OXException {
        this.qfs = qfss.getQuotaFileStorage(ctx, uri);
    }

    public static final QuotaFileStorage getInstance(URI uri, Context ctx) throws OXException {
        if (qfss == null) {
            throw FileStorageCodes.INSTANTIATIONERROR.create("No quota file storage starter registered.");
        }
        return new QuotaFileStorage(uri, ctx, qfss);
    }

    public static void setQuotaFileStorageStarter(QuotaFileStorageFactory qfss) {
        QuotaFileStorage.qfss = qfss;
    }

    public long getUsage() throws OXException {
        return this.qfs.getUsage();
    }

    public void recalculateUsage() throws OXException {
        this.qfs.recalculateUsage();
    }

    public void recalculateUsage(Set<String> filesToIgnore) throws OXException {
        this.qfs.recalculateUsage(filesToIgnore);
    }

    public long getQuota() {
        return this.qfs.getQuota();
    }

    @Override
    public boolean deleteFile(String identifier) throws OXException {
        return this.qfs.deleteFile(identifier);
    }

    @Override
    public Set<String> deleteFiles(String[] identifiers) throws OXException {
        return this.qfs.deleteFiles(identifiers);
    }

    @Override
    public InputStream getFile(String name) throws OXException {
        return this.qfs.getFile(name);
    }

    @Override
    public SortedSet<String> getFileList() throws OXException {
        return this.qfs.getFileList();
    }

    @Override
    public long getFileSize(String name) throws OXException {
        return this.qfs.getFileSize(name);
    }

    @Override
    public String getMimeType(String name) throws OXException {
        return this.qfs.getMimeType(name);
    }

    @Override
    public void recreateStateFile() throws OXException {
        this.qfs.recreateStateFile();
    }

    @Override
    public void remove() throws OXException {
        this.qfs.remove();
    }

    @Override
    public String saveNewFile(InputStream file) throws OXException {
        return this.qfs.saveNewFile(file);
    }

    public String saveNewFile(InputStream file, long sizeHint) throws OXException {
        return this.qfs.saveNewFile(file, sizeHint);
    }

    public long appendToFile(InputStream file, String name, long offset, long sizeHint) throws OXException {
        return this.qfs.appendToFile(file, name, offset, sizeHint);
    }

    @Override
    public void close() {
        this.qfs = null;
    }

    @Override
    public long appendToFile(InputStream file, String name, long offset) throws OXException {
        return this.qfs.appendToFile(file, name, offset);
    }

    @Override
    public void setFileLength(long length, String name) throws OXException {
        this.qfs.setFileLength(length, name);
    }

    @Override
    public InputStream getFile(String name, long offset, long length) throws OXException {
        return this.qfs.getFile(name, offset, length);
    }
}

