/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file;

import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.stream.CountingInputStream;
import com.openexchange.tx.AbstractUndoable;
import com.openexchange.tx.UndoableAction;
import java.io.Closeable;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jonelo.jacksum.util.Service;

public abstract class FileStreamAction
extends AbstractUndoable
implements UndoableAction {
    private static final String CHECKSUM_ALGORITHM = "MD5";
    private final FileStorage storage;
    private final InputStream data;
    private String checksum;
    private long bytesRead;
    private final long sizeHint;
    private boolean calculateChecksum;

    protected FileStreamAction(FileStorage storage, InputStream data, long sizeHint, boolean calculateChecksum) {
        this.storage = storage;
        this.data = data;
        this.sizeHint = sizeHint;
        this.calculateChecksum = calculateChecksum;
    }

    protected abstract void store(FileStorage var1, InputStream var2) throws OXException;

    protected abstract void store(QuotaFileStorage var1, InputStream var2, long var3) throws OXException;

    protected abstract void undo(FileStorage var1) throws OXException;

    private void store(InputStream stream) throws OXException {
        if (0L < this.sizeHint && QuotaFileStorage.class.isInstance(this.storage)) {
            this.store((QuotaFileStorage)this.storage, stream, this.sizeHint);
        } else {
            this.store(this.storage, stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() throws OXException {
        CountingInputStream countingStream = null;
        DigestInputStream digestStream = null;
        try {
            countingStream = new CountingInputStream(this.data, -1L);
            if (this.calculateChecksum) {
                try {
                    digestStream = new DigestInputStream((InputStream)countingStream, MessageDigest.getInstance(CHECKSUM_ALGORITHM));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (null != digestStream) {
                this.store(digestStream);
                this.checksum = Service.format((byte[])digestStream.getMessageDigest().digest());
            } else {
                this.store((InputStream)countingStream);
            }
            this.bytesRead = countingStream.getCount();
        }
        catch (Throwable throwable) {
            Streams.close((Closeable[])new Closeable[]{countingStream, digestStream});
            throw throwable;
        }
        Streams.close((Closeable[])new Closeable[]{countingStream, digestStream});
    }

    protected void undoAction() throws OXException {
        this.undo(this.storage);
    }

    public abstract String getFileStorageID();

    public long getByteCount() {
        return this.bytesRead;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public boolean isCalculateChecksum() {
        return this.calculateChecksum;
    }

    public void setCalculateChecksum(boolean calculateChecksum) {
        this.calculateChecksum = calculateChecksum;
    }
}

