/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.exceptions;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogProperties;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionUtils.class);
    private static final String MARKER = " ---=== /!\\ ===--- ";

    public static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            Map taskProperties = LogProperties.getPropertyMap();
            if (null == taskProperties) {
                LOG.error("{}Thread death{}", new Object[]{MARKER, MARKER, t});
            } else {
                StringBuilder logBuilder = new StringBuilder(512);
                TreeMap<String, String> sorted = new TreeMap<String, String>();
                for (Map.Entry entry : taskProperties.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (null == value) continue;
                    sorted.put(propertyName, value);
                }
                for (Map.Entry entry : sorted.entrySet()) {
                    logBuilder.append('\n').append((String)entry.getKey()).append('=').append((String)entry.getValue());
                }
                logBuilder.deleteCharAt(0);
                logBuilder.append("\n\n");
                logBuilder.append(MARKER);
                logBuilder.append("Thread death");
                logBuilder.append(MARKER);
                LOG.error(logBuilder.toString(), t);
            }
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            Map taskProperties = LogProperties.getPropertyMap();
            if (null == taskProperties) {
                LOG.error(" ---=== /!\\ ===--- The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating. ---=== /!\\ ===--- ", t);
            } else {
                StringAllocator logBuilder = new StringAllocator(512);
                TreeMap<String, String> sorted = new TreeMap<String, String>();
                for (Map.Entry entry : taskProperties.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (null == value) continue;
                    sorted.put(propertyName, value);
                }
                for (Map.Entry entry : sorted.entrySet()) {
                    logBuilder.append('\n').append((String)entry.getKey()).append('=').append((String)entry.getValue());
                }
                logBuilder.deleteCharAt(0);
                logBuilder.append("\n\n");
                logBuilder.append(MARKER);
                logBuilder.append("The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating.");
                logBuilder.append(MARKER);
                LOG.error(logBuilder.toString(), t);
            }
            throw (VirtualMachineError)t;
        }
    }

    private static String surroundWithMarker(String message) {
        return new StringAllocator(message.length() + 40).append(MARKER).append(message).append(MARKER).toString();
    }
}

