/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum ResourceExceptionCode implements DisplayableOXExceptionCode
{
    NO_CONNECTION("Cannot get database connection.", Category.CATEGORY_SERVICE_DOWN, 1, "Error while reading/writing data from/to the database."),
    SQL_ERROR("SQL problem: \"%1$s\"", Category.CATEGORY_ERROR, 2, "Error while reading/writing data from/to the database."),
    RESOURCEGROUP_NOT_FOUND("Cannot find resource group with identifier %1$d.", Category.CATEGORY_USER_INPUT, 3, "No resource group found for identifier \"%1$d\"."),
    RESOURCEGROUP_CONFLICT("Found resource groups with same identifier %1$d.", Category.CATEGORY_USER_INPUT, 4, "Found resource groups with the same identifier \"%1$d\"."),
    RESOURCE_NOT_FOUND("Cannot find resource with identifier %1$d.", Category.CATEGORY_USER_INPUT, 5, "No resource found with identifier \"%1$d\"."),
    RESOURCE_CONFLICT("Found resource(s) with same identifier %1$s.", Category.CATEGORY_USER_INPUT, 6, "Found resource(s) with same identifier \"%1$s\"."),
    NULL("No resource given.", Category.CATEGORY_ERROR, 7),
    MANDATORY_FIELD("Missing mandatory field(s) in given resource.", Category.CATEGORY_ERROR, 8),
    PERMISSION("No permission to modify resources in context %1$s", Category.CATEGORY_PERMISSION_DENIED, 9, "You do not have the appropriate permissions to modify resources."),
    RESOURCE_CONFLICT_MAIL("Found resource(s) with same email address %1$s.", Category.CATEGORY_ERROR, 10),
    INVALID_RESOURCE_IDENTIFIER("Invalid resource identifier: %1$s", Category.CATEGORY_USER_INPUT, 11, "The provided resource identifier \"%1$s\" contains invalid characters."),
    INVALID_RESOURCE_MAIL("Invalid resource E-Mail address: %1$s", Category.CATEGORY_USER_INPUT, 12, "The provided E-Mail address \"%1$s\" for resource is invalid."),
    CONCURRENT_MODIFICATION("The resource has been changed in the meantime: %1$s", Category.CATEGORY_CONFLICT, 13, "The selected resource \"%1$s\" has been changed in the meantime.");

    private static final String NO_CONNECTION_MSG = "Cannot get database connection.";
    private static final String SQL_ERROR_MSG = "SQL problem: \"%1$s\"";
    private static final String RESOURCEGROUP_NOT_FOUND_MSG = "Cannot find resource group with identifier %1$d.";
    private static final String RESOURCEGROUP_CONFLICT_MSG = "Found resource groups with same identifier %1$d.";
    private static final String RESOURCE_NOT_FOUND_MSG = "Cannot find resource with identifier %1$d.";
    private static final String RESOURCE_CONFLICT_MSG = "Found resource(s) with same identifier %1$s.";
    private static final String NULL_MSG = "No resource given.";
    private static final String MANDATORY_FIELD_MSG = "Missing mandatory field(s) in given resource.";
    private static final String PERMISSION_MSG = "No permission to modify resources in context %1$s";
    private static final String RESOURCE_CONFLICT_MAIL_MSG = "Found resource(s) with same email address %1$s.";
    private static final String INVALID_RESOURCE_IDENTIFIER_MSG = "Invalid resource identifier: %1$s";
    private static final String INVALID_RESOURCE_MAIL_MSG = "Invalid resource E-Mail address: %1$s";
    private static final String CONCURRENT_MODIFICATION_MSG = "The resource has been changed in the meantime: %1$s";
    final String message;
    final Category category;
    final int detailNumber;
    private String displayMessage;

    private ResourceExceptionCode(String message, Category category, int detailNumber) {
        this(message, category, detailNumber, null);
    }

    private ResourceExceptionCode(String message, Category category, int detailNumber, String displayMessage) {
        this.message = message;
        this.category = category;
        this.detailNumber = detailNumber;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public Category getCategory() {
        return this.category;
    }

    public String getPrefix() {
        return "RES";
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

