/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.internal;

import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.Strings;
import com.openexchange.report.internal.LastLoginRecorder;
import com.openexchange.session.Session;
import com.openexchange.user.UserService;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LastLoginUpdater
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LastLoginUpdater.class);
    private static final long MILLIS_DAY = 86400000L;
    private final Set<String> acceptedClients;
    private final ContextService contextService;
    private final UserService userService;

    public LastLoginUpdater(ContextService contextService, UserService userService) {
        this.contextService = contextService;
        this.userService = userService;
        HashSet<String> set = new HashSet<String>(1);
        set.add("USM-EAS");
        this.acceptedClients = set;
    }

    public void handleEvent(Event event) {
        if ("com/openexchange/sessiond/touch/session".equals(event.getTopic())) {
            Session session = (Session)event.getProperty("com.openexchange.sessiond.session");
            try {
                this.handleSessionTouched(session);
            }
            catch (Exception e) {
                String message = "Couldn't check/update last-accessed time stamp for client \"" + session.getClient() + "\" of user " + session.getUserId() + " in context " + session.getContextId();
                LOG.warn(message, (Throwable)e);
            }
        }
    }

    private void handleSessionTouched(Session session) throws OXException {
        String client = session.getClient();
        if (!LastLoginUpdater.isEmpty(client) && this.acceptedClients.contains(client)) {
            Context context = this.contextService.getContext(session.getContextId());
            User user = this.userService.getUser(session.getUserId(), context);
            Set<String> values = user.getAttributes().get("client:" + client);
            if (null != values && !values.isEmpty()) {
                try {
                    long lastAccessed = Long.parseLong(values.iterator().next());
                    long now = System.currentTimeMillis();
                    if (now - lastAccessed >= 86400000L) {
                        LastLoginRecorder.updateLastLogin(this.userService, client, user, context);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }
}

