/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.database.Databases;
import com.openexchange.databaseold.Database;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.jslob.DefaultJSlob;
import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobId;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.mailaccount.json.actions.ValidateAction;
import com.openexchange.mailaccount.json.fields.MailAccountFields;
import com.openexchange.mailaccount.json.parser.MailAccountParser;
import com.openexchange.mailaccount.json.writer.MailAccountWriter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

@Action(method=RequestMethod.PUT, name="new", description="Create a new mail account", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="A JSON object describing the new account to create. See mail account data.", responseDescription="A JSON object representing the inserted mail account. See mail account data.")
public final class NewAction
extends AbstractMailAccountAction
implements MailAccountFields {
    public static final String ACTION = "new";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult innerPerform(AJAXRequestData requestData, ServerSession session, JSONValue jData) throws OXException, JSONException {
        int id;
        if (!session.getUserPermissionBits().isMultipleMailAccounts()) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(session.getUserId(), session.getContextId());
        }
        MailAccountDescription accountDescription = new MailAccountDescription();
        LinkedList<OXException> warnings = new LinkedList<OXException>();
        MailAccountParser.getInstance().parse(accountDescription, jData.toObject(), warnings, true);
        NewAction.checkNeededFields(accountDescription);
        if (NewAction.isUnifiedINBOXAccount(accountDescription.getMailProtocol())) {
            throw MailAccountExceptionCodes.UNIFIED_INBOX_ACCOUNT_CREATION_FAILED.create(accountDescription.getId());
        }
        String name = accountDescription.getName();
        if (NewAction.isEmpty(name) || "null".equalsIgnoreCase(name)) {
            accountDescription.setName(accountDescription.getPrimaryAddress());
        }
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        boolean pop3 = accountDescription.getMailProtocol().toLowerCase(Locale.ENGLISH).startsWith("pop3");
        if (!pop3) {
            session.setParameter("mail-account.validate.type", "create");
            try {
                if (!ValidateAction.actionValidateBoolean(accountDescription, session, false, warnings).booleanValue()) {
                    OXException warning = MimeMailExceptionCode.CONNECT_ERROR.create(accountDescription.getMailServer(), accountDescription.getLogin());
                    warning.setCategory(Category.CATEGORY_WARNING);
                    warnings.add(0, warning);
                }
            }
            finally {
                session.setParameter("mail-account.validate.type", null);
            }
        }
        int cid = session.getContextId();
        MailAccount newAccount = null;
        Connection wcon = Database.get(cid, true);
        boolean rollback = false;
        try {
            MailAccount[] accounts;
            Databases.startTransaction((Connection)wcon);
            rollback = true;
            id = storageService.insertMailAccount(accountDescription, session.getUserId(), session.getContext(), session, wcon);
            for (MailAccount mailAccount : accounts = storageService.getUserMailAccounts(session.getUserId(), cid, wcon)) {
                if (mailAccount.getId() != id) continue;
                newAccount = mailAccount;
                break;
            }
            if (null != newAccount) {
                newAccount = NewAction.checkFullNames(newAccount, storageService, session, wcon);
            }
            wcon.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(wcon);
            }
            DBUtils.autocommit(wcon);
            Database.back(cid, true, wcon);
        }
        JSONObject jBody = jData.toObject();
        if (jBody.hasAndNotNull("meta")) {
            JSONObject jMeta = jBody.optJSONObject("meta");
            NewAction.getStorage().store(new JSlobId("com.openexchange.mailaccount", Integer.toString(id), session.getUserId(), session.getContextId()), (JSlob)new DefaultJSlob(jMeta));
        }
        JSONObject jsonAccount = null == newAccount ? MailAccountWriter.write(NewAction.checkFullNames(storageService.getMailAccount(id, session.getUserId(), session.getContextId()), storageService, session)) : MailAccountWriter.write(newAccount);
        return new AJAXRequestResult(jsonAccount).addWarnings(warnings);
    }
}

