/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.mailaccount.internal.CachingMailAccountStorage;
import com.openexchange.mailaccount.internal.DeleteListenerRegistry;
import com.openexchange.mailaccount.internal.RdbMailAccountStorage;
import com.openexchange.mailaccount.internal.SanitizingStorageService;
import com.openexchange.mailaccount.internal.UnifiedInboxManagementImpl;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailAccountStorageInit
implements Initialization {
    private static final Logger LOG = LoggerFactory.getLogger(MailAccountStorageInit.class);
    private final AtomicBoolean started = new AtomicBoolean();

    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        ServerServiceRegistry.getInstance().addService(MailAccountStorageService.class, MailAccountStorageInit.newMailAccountStorageService());
        ServerServiceRegistry.getInstance().addService(UnifiedInboxManagement.class, MailAccountStorageInit.newUnifiedINBOXManagement());
        DeleteListenerRegistry.initInstance();
        LOG.info("MailAccountStorageService successfully injected to server service registry");
    }

    public void stop() throws OXException {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        DeleteListenerRegistry.releaseInstance();
        ServerServiceRegistry.getInstance().removeService(UnifiedInboxManagement.class);
        ServerServiceRegistry.getInstance().removeService(MailAccountStorageService.class);
        LOG.info("MailAccountStorageService successfully removed from server service registry");
    }

    public static MailAccountStorageService newMailAccountStorageService() {
        return new SanitizingStorageService(new CachingMailAccountStorage(new RdbMailAccountStorage()));
    }

    public static UnifiedInboxManagement newUnifiedINBOXManagement() {
        return new UnifiedInboxManagementImpl();
    }
}

