/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.watcher;

import com.openexchange.mail.watcher.MailAccessDelayElement;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class MailAccessDelayQueue
extends AbstractQueue<MailAccessDelayElement>
implements BlockingQueue<MailAccessDelayElement> {
    final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition available = this.lock.newCondition();
    final PriorityQueue<MailAccessDelayElement> q = new PriorityQueue();

    public MailAccessDelayQueue() {
    }

    public MailAccessDelayQueue(Collection<? extends MailAccessDelayElement> c) {
        this.addAll(c);
    }

    @Override
    public boolean add(MailAccessDelayElement e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(MailAccessDelayElement e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            MailAccessDelayElement first = this.q.peek();
            this.q.offer(e);
            if (first == null || e.compareTo(first) < 0) {
                this.available.signalAll();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void put(MailAccessDelayElement e) {
        this.offer(e);
    }

    @Override
    public boolean offer(MailAccessDelayElement e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailAccessDelayElement poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            MailAccessDelayElement first = this.q.peek();
            if (first == null || first.getDelay(TimeUnit.NANOSECONDS) > 0L) {
                MailAccessDelayElement mailAccessDelayElement = null;
                return mailAccessDelayElement;
            }
            MailAccessDelayElement x = this.q.poll();
            assert (x != null);
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            MailAccessDelayElement mailAccessDelayElement = x;
            return mailAccessDelayElement;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailAccessDelayElement poll(ElementFilter filter) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            MailAccessDelayElement first = this.q.peek();
            if (first == null || first.getDelay(TimeUnit.NANOSECONDS) > 0L || null != filter && !filter.accept(first)) {
                MailAccessDelayElement mailAccessDelayElement = null;
                return mailAccessDelayElement;
            }
            MailAccessDelayElement x = this.q.poll();
            assert (x != null);
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            MailAccessDelayElement mailAccessDelayElement = x;
            return mailAccessDelayElement;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public MailAccessDelayElement take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                MailAccessDelayElement first;
                if ((first = this.q.peek()) == null) {
                    this.available.await();
                    continue;
                }
                long delay = first.getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) {
                    this.available.awaitNanos(delay);
                    continue;
                }
                MailAccessDelayElement x = this.q.poll();
                assert (x != null);
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                MailAccessDelayElement mailAccessDelayElement = x;
                return mailAccessDelayElement;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public MailAccessDelayElement poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                MailAccessDelayElement first;
                if ((first = this.q.peek()) == null) {
                    if (nanos <= 0L) {
                        MailAccessDelayElement mailAccessDelayElement = null;
                        return mailAccessDelayElement;
                    }
                    nanos = this.available.awaitNanos(nanos);
                    continue;
                }
                long delay = first.getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) {
                    if (nanos <= 0L) {
                        MailAccessDelayElement mailAccessDelayElement = null;
                        return mailAccessDelayElement;
                    }
                    if (delay > nanos) {
                        delay = nanos;
                    }
                    long timeLeft = this.available.awaitNanos(delay);
                    nanos -= delay - timeLeft;
                    continue;
                }
                MailAccessDelayElement x = this.q.poll();
                assert (x != null);
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                MailAccessDelayElement mailAccessDelayElement = x;
                return mailAccessDelayElement;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailAccessDelayElement peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            MailAccessDelayElement mailAccessDelayElement = this.q.peek();
            return mailAccessDelayElement;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super MailAccessDelayElement> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            MailAccessDelayElement first;
            int n = 0;
            while ((first = this.q.peek()) != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                c.add(this.q.poll());
                ++n;
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super MailAccessDelayElement> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            MailAccessDelayElement first;
            int n;
            for (n = 0; n < maxElements && (first = this.q.peek()) != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L; ++n) {
                c.add(this.q.poll());
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            T[] TArray = this.q.toArray(a);
            return TArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.remove(o);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<MailAccessDelayElement> iterator() {
        return new Itr(this.toArray());
    }

    private class Itr
    implements Iterator<MailAccessDelayElement> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public MailAccessDelayElement next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return (MailAccessDelayElement)this.array[this.cursor++];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object x = this.array[this.lastRet];
            this.lastRet = -1;
            MailAccessDelayQueue.this.lock.lock();
            try {
                Iterator<MailAccessDelayElement> it = MailAccessDelayQueue.this.q.iterator();
                while (it.hasNext()) {
                    if (it.next() != x) continue;
                    it.remove();
                    return;
                }
            }
            finally {
                MailAccessDelayQueue.this.lock.unlock();
            }
        }
    }

    public static interface ElementFilter {
        public boolean accept(MailAccessDelayElement var1);
    }
}

