/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.datasource.DataContentHandlerDataSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.datasource.StreamDataSource;
import com.openexchange.mail.utils.CP932EmojiMapping;
import com.sun.mail.handlers.message_rfc822;
import com.sun.mail.handlers.multipart_mixed;
import com.sun.mail.handlers.text_html;
import com.sun.mail.handlers.text_plain;
import com.sun.mail.handlers.text_xml;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.activation.DataContentHandler;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageUtility {
    private static final String STR_EMPTY = "";
    private static final Logger LOG = LoggerFactory.getLogger(MessageUtility.class);
    private static final int BUFSIZE = 8192;
    public static final char UNKNOWN = '\ufffd';
    private static final Pattern PATTERN_BIG5 = Pattern.compile("[-_]+");
    private static final String BIG5 = "big5";
    private static final String BIGFIVE = "bigfive";
    private static final String GB2312 = "gb2312";
    private static final Set<String> SHIFT_JIS = new HashSet<String>(Arrays.asList("shift_jis", "shift-jis", "sjis", "cp932"));
    private static final int THRESHOLD = 25;
    private static volatile Field dataContentHandlerField;
    private static volatile Field objectField;
    private static volatile Field objectMimeTypeField;
    private static final multipart_mixed DCH_MULTIPART;
    private static final message_rfc822 DCH_MESSAGE;
    private static final text_plain DCH_TEXT_PLAIN;
    private static final text_html DCH_TEXT_HTML;
    private static final text_xml DCH_TEXT_XML;
    private static final String HDR_CONTENT_TYPE = "Content-Type";

    private MessageUtility() {
    }

    public static String checkCharset(MailPart p, ContentType ct) throws OXException {
        String cs = ct.getCharsetParameter();
        if (!CharsetDetector.isValid((String)cs)) {
            if (cs != null) {
                MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(cs);
            }
            String prev = cs;
            cs = CharsetDetector.detectCharset((InputStream)p.getInputStream());
            LOG.warn("Illegal or unsupported encoding \"{}\". Using auto-detected encoding: \"{}\"", (Object)prev, (Object)cs);
        }
        return cs;
    }

    public static String checkCharset(Part p, ContentType ct) {
        String cs = ct.getCharsetParameter();
        if (!CharsetDetector.isValid((String)cs)) {
            if (cs != null) {
                MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(cs);
            }
            String prev = cs;
            cs = CharsetDetector.detectCharset((InputStream)MessageUtility.getPartInputStream(p));
            LOG.warn("Illegal or unsupported encoding \"{}\". Using auto-detected encoding: \"{}\"", (Object)prev, (Object)cs);
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getPartInputStream(Part p) {
        InputStream tmp = null;
        try {
            tmp = p.getInputStream();
            tmp.read();
            InputStream inputStream = p.getInputStream();
            return inputStream;
        }
        catch (IOException e) {
            InputStream inputStream = MessageUtility.getPartRawInputStream(p);
            return inputStream;
        }
        catch (MessagingException e) {
            InputStream inputStream = MessageUtility.getPartRawInputStream(p);
            return inputStream;
        }
        finally {
            Streams.close((Closeable)tmp);
        }
    }

    private static InputStream getPartRawInputStream(Part p) {
        if (p instanceof MimeBodyPart) {
            try {
                return ((MimeBodyPart)p).getRawInputStream();
            }
            catch (MessagingException e1) {
                return null;
            }
        }
        if (p instanceof MimeMessage) {
            try {
                return ((MimeMessage)p).getRawInputStream();
            }
            catch (MessagingException e1) {
                return null;
            }
        }
        return null;
    }

    public static String readMimePart(Part p, ContentType ct) throws MessagingException {
        String charset = ct.getCharsetParameter();
        if (null == charset) {
            charset = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding);
        }
        return MessageUtility.readMimePart(p, charset);
    }

    public static String readMimePart(final Part p, String charset) throws MessagingException {
        try {
            AbstractInputStreamProvider streamProvider = new AbstractInputStreamProvider(){

                @Override
                public InputStream getInputStream() throws IOException {
                    try {
                        return p.getInputStream();
                    }
                    catch (MessagingException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
            };
            return MessageUtility.readStream(streamProvider, charset);
        }
        catch (IOException e) {
            AbstractInputStreamProvider streamProvider;
            Throwable cause = e.getCause();
            if (cause instanceof MessagingException) {
                throw (MessagingException)cause;
            }
            if (p instanceof MimeBodyPart) {
                streamProvider = new AbstractInputStreamProvider(){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        try {
                            return ((MimeBodyPart)p).getRawInputStream();
                        }
                        catch (MessagingException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                    }
                };
            } else if (p instanceof MimeMessage) {
                streamProvider = new AbstractInputStreamProvider(){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        try {
                            return ((MimeMessage)p).getRawInputStream();
                        }
                        catch (MessagingException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                    }
                };
            } else {
                return STR_EMPTY;
            }
            try {
                return MessageUtility.readStream(streamProvider, charset);
            }
            catch (IOException e1) {
                LOG.error(STR_EMPTY, (Throwable)e1);
                return STR_EMPTY;
            }
        }
    }

    public static String readMailPart(final MailPart mailPart, String charset) throws IOException, OXException {
        AbstractInputStreamProvider streamProvider = new AbstractInputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                try {
                    return mailPart.getInputStream();
                }
                catch (OXException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
        };
        try {
            return MessageUtility.readStream(streamProvider, charset);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw e;
        }
    }

    public static String readBytes(final byte[] bytes, String charset) throws IOException {
        AbstractInputStreamProvider streamProvider = new AbstractInputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                return Streams.newByteArrayInputStream((byte[])bytes);
            }
        };
        return MessageUtility.readStream(streamProvider, charset);
    }

    public static String readStream(StreamDataSource.InputStreamProvider streamProvider, String charset) throws IOException {
        if (null == streamProvider) {
            return STR_EMPTY;
        }
        if (MessageUtility.isBig5(charset)) {
            return MessageUtility.readBig5Bytes(MessageUtility.getBytesFrom(streamProvider.getInputStream()));
        }
        if ("GB18030".equalsIgnoreCase(charset)) {
            return MessageUtility.readGB18030Bytes(MessageUtility.getBytesFrom(streamProvider.getInputStream()));
        }
        if (MessageUtility.isGB2312(charset)) {
            byte[] bytes = MessageUtility.getBytesFrom(streamProvider.getInputStream());
            if (bytes.length == 0) {
                return STR_EMPTY;
            }
            String retval = new String(bytes, Charsets.forName((String)"GB2312"));
            if (retval.indexOf(65533) < 0) {
                return retval;
            }
            retval = new String(bytes, Charsets.forName((String)"GB18030"));
            if (retval.indexOf(65533) < 0) {
                return retval;
            }
            String detectedCharset = CharsetDetector.detectCharset((ByteArrayInputStream)Streams.newByteArrayInputStream((byte[])bytes));
            LOG.debug("Mapped \"GB2312\" charset to \"{}\".", (Object)detectedCharset);
            if (MessageUtility.isBig5(detectedCharset)) {
                return MessageUtility.readBig5Bytes(bytes);
            }
            return new String(bytes, Charsets.forName((String)detectedCharset));
        }
        if (MessageUtility.isShiftJis(charset)) {
            byte[] bytes = MessageUtility.getBytesFrom(streamProvider.getInputStream());
            if (bytes.length == 0) {
                return STR_EMPTY;
            }
            String retval = new String(bytes, Charsets.forName((String)("cp932".equalsIgnoreCase(charset) ? "MS932" : charset)));
            if (retval.indexOf(65533) < 0) {
                return retval;
            }
            return CP932EmojiMapping.getInstance().replaceIn(new String(bytes, Charsets.forName((String)"MS932")));
        }
        String retval = MessageUtility.readStream0(streamProvider.getInputStream(), charset);
        return retval;
    }

    public static String readStream(InputStream inStream, String charset) throws IOException {
        if (null == inStream) {
            return STR_EMPTY;
        }
        if (MessageUtility.isBig5(charset)) {
            return MessageUtility.readBig5Bytes(MessageUtility.getBytesFrom(inStream));
        }
        if ("GB18030".equalsIgnoreCase(charset)) {
            return MessageUtility.readGB18030Bytes(MessageUtility.getBytesFrom(inStream));
        }
        if (MessageUtility.isGB2312(charset)) {
            byte[] bytes = MessageUtility.getBytesFrom(inStream);
            if (bytes.length == 0) {
                return STR_EMPTY;
            }
            String retval = new String(bytes, Charsets.forName((String)"GB2312"));
            if (retval.indexOf(65533) < 0) {
                return retval;
            }
            retval = new String(bytes, Charsets.forName((String)"GB18030"));
            if (retval.indexOf(65533) < 0) {
                return retval;
            }
            String detectedCharset = CharsetDetector.detectCharset((ByteArrayInputStream)Streams.newByteArrayInputStream((byte[])bytes));
            LOG.debug("Mapped \"GB2312\" charset to \"{}\".", (Object)detectedCharset);
            if (MessageUtility.isBig5(detectedCharset)) {
                return MessageUtility.readBig5Bytes(bytes);
            }
            return new String(bytes, Charsets.forName((String)detectedCharset));
        }
        if (MessageUtility.isShiftJis(charset)) {
            byte[] bytes = MessageUtility.getBytesFrom(inStream);
            if (bytes.length == 0) {
                return STR_EMPTY;
            }
            String retval = new String(bytes, Charsets.forName((String)("cp932".equalsIgnoreCase(charset) ? "MS932" : charset)));
            if (retval.indexOf(65533) < 0) {
                return retval;
            }
            return CP932EmojiMapping.getInstance().replaceIn(new String(bytes, Charsets.forName((String)"MS932")));
        }
        return MessageUtility.readStream0(inStream, charset);
    }

    private static String readGB18030Bytes(byte[] bytes) throws Error {
        if (bytes.length == 0) {
            return STR_EMPTY;
        }
        String retval = new String(bytes, Charsets.forName((String)"GB18030"));
        if (retval.indexOf(65533) < 0) {
            return retval;
        }
        String detectedCharset = CharsetDetector.detectCharset((ByteArrayInputStream)Streams.newByteArrayInputStream((byte[])bytes));
        LOG.debug("Mapped \"GB18030\" charset to \"{}\".", (Object)detectedCharset);
        if (MessageUtility.isBig5(detectedCharset)) {
            return MessageUtility.readBig5Bytes(bytes);
        }
        return new String(bytes, Charsets.forName((String)detectedCharset));
    }

    private static String readBig5Bytes(byte[] bytes) throws Error {
        if (bytes.length == 0) {
            return STR_EMPTY;
        }
        String retval = new String(bytes, Charsets.forName((String)BIG5));
        if (retval.indexOf(65533) < 0) {
            return retval;
        }
        try {
            return new String(bytes, Charsets.forName((String)"Big5-HKSCS"));
        }
        catch (Error error) {
            Throwable cause = error.getCause();
            if (cause instanceof CharConversionException || cause instanceof CharacterCodingException) {
                return new String(bytes, Charsets.forName((String)CharsetDetector.detectCharset((ByteArrayInputStream)Streams.newByteArrayInputStream((byte[])bytes))));
            }
            throw error;
        }
    }

    /*
     * Exception decompiling
     */
    private static String readStream0(InputStream inStream, String charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String detectCharset(byte[] bytes) {
        String charset = CharsetDetector.detectCharset((ByteArrayInputStream)Streams.newByteArrayInputStream((byte[])bytes));
        if ("US-ASCII".equalsIgnoreCase(charset)) {
            charset = "ISO-8859-1";
        }
        return charset;
    }

    public static boolean isSpecialCharset(String charset) {
        if (MessageUtility.isBig5(charset)) {
            return true;
        }
        if ("GB18030".equalsIgnoreCase(charset)) {
            return true;
        }
        if (MessageUtility.isGB2312(charset)) {
            return true;
        }
        return MessageUtility.isShiftJis(charset);
    }

    public static boolean isBig5(String charset) {
        if (null == charset) {
            return false;
        }
        String lc = MessageUtility.toLowerCase(charset);
        if (!lc.startsWith("big", 0)) {
            return false;
        }
        String wo = PATTERN_BIG5.matcher(lc).replaceAll(STR_EMPTY);
        return BIG5.equals(wo) || BIGFIVE.equals(wo);
    }

    public static boolean isGB2312(String charset) {
        if (null == charset) {
            return false;
        }
        return GB2312.equals(MessageUtility.toLowerCase(charset));
    }

    public static boolean isShiftJis(String charset) {
        if (null == charset) {
            return false;
        }
        return SHIFT_JIS.contains(MessageUtility.toLowerCase(charset));
    }

    public static byte[] getBytesFrom(InputStream in) throws IOException {
        if (null == in) {
            return new byte[0];
        }
        try {
            byte[] buf = new byte[8192];
            int len = 0;
            len = in.read(buf, 0, buf.length);
            if (len <= 0) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            ByteArrayOutputStream out = Streams.newByteArrayOutputStream((int)8192);
            do {
                out.write(buf, 0, len);
            } while ((len = in.read(buf, 0, buf.length)) > 0);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            if ("No content".equals(e.getMessage())) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            throw e;
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    public static boolean isAscii(byte[] bytes) {
        if (null == bytes || 0 == bytes.length) {
            return true;
        }
        int len = bytes.length;
        boolean isAscci = true;
        for (int i = 0; i < len && isAscci; ++i) {
            isAscci = bytes[i] >= 0;
        }
        return isAscci;
    }

    public static String simpleHtmlDuplicateRemoval(String html) {
        if (MessageUtility.isEmpty(html)) {
            return html;
        }
        String lc = html.toLowerCase();
        String sub = "<html>";
        int count = 0;
        int idx = 0;
        int subLen = "<html>".length();
        while ((idx = lc.indexOf("<html>", idx)) >= 0) {
            ++count;
            idx += subLen;
        }
        if (count <= 25) {
            return html;
        }
        int pos = lc.lastIndexOf("<html>");
        if (pos > 0 && (pos = lc.lastIndexOf("<html>", pos - 1)) >= 0) {
            return html.substring(pos + 6);
        }
        return html;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Field dataContentHandlerField() {
        Field f = dataContentHandlerField;
        if (null != f) return f;
        Class<MessageUtility> clazz = MessageUtility.class;
        synchronized (MessageUtility.class) {
            f = dataContentHandlerField;
            if (null != f) return f;
            try {
                f = DataHandler.class.getDeclaredField("dataContentHandler");
                f.setAccessible(true);
            }
            catch (Exception e) {
                f = null;
            }
            dataContentHandlerField = f;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Field objectField() {
        Field f = objectField;
        if (null != f) return f;
        Class<MessageUtility> clazz = MessageUtility.class;
        synchronized (MessageUtility.class) {
            f = objectField;
            if (null != f) return f;
            try {
                f = DataHandler.class.getDeclaredField("object");
                f.setAccessible(true);
            }
            catch (Exception e) {
                f = null;
            }
            objectField = f;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Field objectMimeTypeField() {
        Field f = objectMimeTypeField;
        if (null != f) return f;
        Class<MessageUtility> clazz = MessageUtility.class;
        synchronized (MessageUtility.class) {
            f = objectMimeTypeField;
            if (null != f) return f;
            try {
                f = DataHandler.class.getDeclaredField("objectMimeType");
                f.setAccessible(true);
            }
            catch (Exception e) {
                f = null;
            }
            objectMimeTypeField = f;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return f;
        }
    }

    private static void setField(Field field, Object obj, Object value, String name) throws MessagingException {
        try {
            if (null == field) {
                throw new NoSuchFieldException(name);
            }
            field.set(obj, value);
        }
        catch (SecurityException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        catch (NoSuchFieldException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        catch (RuntimeException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    private static DataHandler setFields(DataHandler dataHandler, DataContentHandler dch, Object object, String objectMimeType) throws MessagingException {
        if (null == dataHandler) {
            return dataHandler;
        }
        if (null != dch) {
            MessageUtility.setField(MessageUtility.dataContentHandlerField(), dataHandler, dch, "dataContentHandler");
        }
        if (null != object) {
            MessageUtility.setField(MessageUtility.objectField(), dataHandler, object, "object");
        }
        if (null != objectMimeType) {
            MessageUtility.setField(MessageUtility.objectMimeTypeField(), dataHandler, objectMimeType, "objectMimeType");
        }
        return dataHandler;
    }

    private static DataContentHandler dchFor(String subtype) {
        if (subtype.startsWith("plain")) {
            return DCH_TEXT_PLAIN;
        }
        if (subtype.startsWith("htm")) {
            return DCH_TEXT_HTML;
        }
        if (subtype.startsWith("xml")) {
            return DCH_TEXT_XML;
        }
        return null;
    }

    public static DataHandler dhFor(DataSource dataSource, DataContentHandler dch, Object object, String objectMimeType) throws MessagingException {
        return MessageUtility.setFields(new DataHandler(dataSource), dch, object, objectMimeType);
    }

    public static void setContent(Message message, Part part) throws MessagingException {
        if (null == message || null == part) {
            return;
        }
        part.setDataHandler(MessageUtility.dhFor(new DataContentHandlerDataSource(message, "message/rfc822", (DataContentHandler)DCH_MESSAGE), (DataContentHandler)DCH_MESSAGE, message, "message/rfc822"));
    }

    public static void setContent(Multipart multipart, Part part) throws MessagingException {
        MessageUtility.setContent(multipart, null, part);
    }

    public static void setContent(Multipart multipart, String contentType, Part part) throws MessagingException {
        if (null == multipart || null == part) {
            return;
        }
        String objectMimeType = null == contentType ? multipart.getContentType() : contentType;
        part.setDataHandler(MessageUtility.dhFor(new DataContentHandlerDataSource(multipart, objectMimeType, (DataContentHandler)DCH_MULTIPART), (DataContentHandler)DCH_MULTIPART, multipart, objectMimeType));
    }

    public static void setText(String text, Part part) throws MessagingException {
        MessageUtility.setText(text, null, null, part);
    }

    public static void setText(String text, String charset, Part part) throws MessagingException {
        MessageUtility.setText(text, charset, null, part);
    }

    public static void setText(String text, String charset, String subtype, Part part) throws MessagingException {
        if (null == text || null == part) {
            return;
        }
        String st = null == subtype ? "plain" : subtype;
        String objectMimeType = new StringAllocator(32).append("text/").append(st).append("; charset=").append(MimeUtility.quote((String)(null == charset ? "us-ascii" : charset), (String)"()<>@,;:\\\"\t []/?=")).toString();
        DataContentHandler dch = MessageUtility.dchFor(MessageUtility.toLowerCase(st));
        if (null == dch) {
            try {
                part.setDataHandler(new DataHandler((DataSource)new MessageDataSource(text, objectMimeType)));
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException("Unsupported encoding", (Exception)e);
            }
            catch (OXException e) {
                throw new MessagingException("Invalid MIME type", (Exception)((Object)e));
            }
        } else {
            part.setDataHandler(MessageUtility.dhFor(new DataContentHandlerDataSource(text, objectMimeType, dch), dch, text, objectMimeType));
        }
        part.setHeader(HDR_CONTENT_TYPE, objectMimeType);
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    static {
        DCH_MULTIPART = new multipart_mixed();
        DCH_MESSAGE = new message_rfc822();
        DCH_TEXT_PLAIN = new text_plain();
        DCH_TEXT_HTML = new text_html();
        DCH_TEXT_XML = new text_xml();
    }

    private static abstract class AbstractInputStreamProvider
    implements StreamDataSource.InputStreamProvider {
        protected AbstractInputStreamProvider() {
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

