/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.mail.MailSortField;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.PlainTextAddress;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.Locale;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.idn.IDNA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailMessageComparator
implements Comparator<MailMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(MailMessageComparator.class);
    private static final String STR_EMPTY = "";
    private final boolean descendingDir;
    private final FieldComparer fieldComparer;
    private static final EnumMap<MailSortField, FieldComparer> COMPARERS = new EnumMap(MailSortField.class);
    private static FieldComparer DUMMY_COMPARER;
    private static final Integer COLOR_FLAG_MIN;

    public MailMessageComparator(boolean descendingDirection, Locale locale) {
        this(MailSortField.SENT_DATE, descendingDirection, locale);
    }

    public MailMessageComparator(MailSortField sortField, boolean descendingDirection, Locale locale) {
        this.descendingDir = descendingDirection;
        if (MailSortField.COLOR_LABEL.equals((Object)sortField) && !MailProperties.getInstance().isUserFlagsEnabled()) {
            this.fieldComparer = DUMMY_COMPARER;
        } else {
            FieldComparer tmp = COMPARERS.get((Object)sortField);
            if (null == tmp) {
                tmp = MailMessageComparator.createFieldComparer(sortField, locale);
            }
            this.fieldComparer = tmp;
        }
    }

    static int compareAddrs(Address[] addrs1, Address[] addrs2, Locale locale, Collator collator) {
        if (MailMessageComparator.isEmptyAddrArray(addrs1) && !MailMessageComparator.isEmptyAddrArray(addrs2)) {
            return -1;
        }
        if (!MailMessageComparator.isEmptyAddrArray(addrs1) && MailMessageComparator.isEmptyAddrArray(addrs2)) {
            return 1;
        }
        if (MailMessageComparator.isEmptyAddrArray(addrs1) && MailMessageComparator.isEmptyAddrArray(addrs2)) {
            return 0;
        }
        return collator.compare(MailMessageComparator.getCompareStringFromAddress(addrs1[0], locale), MailMessageComparator.getCompareStringFromAddress(addrs2[0], locale));
    }

    private static boolean isEmptyAddrArray(Address[] addrs) {
        return addrs == null || addrs.length == 0;
    }

    private static String getCompareStringFromAddress(Address addr, Locale locale) {
        if (addr instanceof PlainTextAddress) {
            return ((PlainTextAddress)addr).getAddress().toLowerCase(locale);
        }
        if (addr instanceof InternetAddress) {
            InternetAddress ia1 = (InternetAddress)addr;
            String personal = ia1.getPersonal();
            if (personal != null && personal.length() > 0) {
                return personal.charAt(0) == '\'' || personal.charAt(0) == '\"' ? personal.substring(1).toLowerCase(locale) : personal.toLowerCase(locale);
            }
            return IDNA.toIDN((String)ia1.getAddress()).toLowerCase(locale);
        }
        return STR_EMPTY;
    }

    private static FieldComparer createFieldComparer(MailSortField sortCol, Locale locale) {
        switch (sortCol) {
            case FROM: {
                return new LocalizedFieldComparer(locale){

                    @Override
                    public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                        return MailMessageComparator.compareAddrs((Address[])msg1.getFrom(), (Address[])msg2.getFrom(), this.locale, this.collator);
                    }
                };
            }
            case TO: {
                return new LocalizedFieldComparer(locale){

                    @Override
                    public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                        return MailMessageComparator.compareAddrs((Address[])msg1.getTo(), (Address[])msg2.getTo(), this.locale, this.collator);
                    }
                };
            }
            case CC: {
                return new LocalizedFieldComparer(locale){

                    @Override
                    public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                        return MailMessageComparator.compareAddrs((Address[])msg1.getCc(), (Address[])msg2.getCc(), this.locale, this.collator);
                    }
                };
            }
            case SUBJECT: {
                return new LocalizedFieldComparer(locale){

                    @Override
                    public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                        String sub1 = msg1.getSubject();
                        String sub2 = msg2.getSubject();
                        return this.collator.compare(sub1 == null ? MailMessageComparator.STR_EMPTY : sub1, sub2 == null ? MailMessageComparator.STR_EMPTY : sub2);
                    }
                };
            }
            case ACCOUNT_NAME: {
                return new LocalizedFieldComparer(locale){

                    @Override
                    public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                        String name1 = msg1.getAccountName();
                        String name2 = msg2.getAccountName();
                        return this.collator.compare(name1 == null ? MailMessageComparator.STR_EMPTY : name1, name2 == null ? MailMessageComparator.STR_EMPTY : name2);
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unknown sort column value " + (Object)((Object)sortCol));
    }

    static Integer getColorFlag(String[] userFlags) {
        for (int i = 0; i < userFlags.length; ++i) {
            String userFlag = userFlags[i];
            if (!MailMessage.isColorLabel(userFlag)) continue;
            int cf = MailMessage.parseColorLabel(userFlag, COLOR_FLAG_MIN);
            return 0 == cf ? COLOR_FLAG_MIN : Integer.valueOf(cf * -1);
        }
        return COLOR_FLAG_MIN;
    }

    @Override
    public int compare(MailMessage msg1, MailMessage msg2) {
        try {
            int comparedTo = this.fieldComparer.compareFields(msg1, msg2);
            if (this.descendingDir) {
                comparedTo *= -1;
            }
            return comparedTo;
        }
        catch (MessagingException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            return 0;
        }
    }

    static {
        COMPARERS.put(MailSortField.SENT_DATE, new FieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                Date d1 = msg1.getSentDate();
                Date d2 = msg2.getSentDate();
                if (null == d1) {
                    if (null == d2) {
                        return 0;
                    }
                    return -1;
                }
                if (null == d2) {
                    return 1;
                }
                return d1.compareTo(d2);
            }
        });
        COMPARERS.put(MailSortField.RECEIVED_DATE, new FieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                Date d1 = msg1.getReceivedDate();
                Date d2 = msg2.getReceivedDate();
                if (null == d1) {
                    if (null == d2) {
                        return 0;
                    }
                    return -1;
                }
                if (null == d2) {
                    return 1;
                }
                return d1.compareTo(d2);
            }
        });
        COMPARERS.put(MailSortField.FLAG_SEEN, new FieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                boolean isSeen1 = msg1.isSeen();
                boolean isSeen2 = msg2.isSeen();
                if (isSeen1 && isSeen2) {
                    return 0;
                }
                if (!isSeen1 && !isSeen2) {
                    boolean isRecent1 = msg1.isRecent();
                    boolean isRecent2 = msg2.isRecent();
                    if (isRecent1 && isRecent2 || !isRecent1 && !isRecent2) {
                        return 0;
                    }
                    if (isRecent1 && !isRecent2) {
                        return 1;
                    }
                    if (!isRecent1 && isRecent2) {
                        return -1;
                    }
                } else {
                    if (isSeen1 && !isSeen2) {
                        return 1;
                    }
                    if (!isSeen1 && isSeen2) {
                        return -1;
                    }
                }
                return 0;
            }
        });
        COMPARERS.put(MailSortField.SIZE, new FieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                return Long.valueOf(msg1.getSize()).compareTo(msg2.getSize());
            }
        });
        COMPARERS.put(MailSortField.COLOR_LABEL, new FieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                Integer cl1 = msg1.getColorLabel();
                Integer cl2 = msg2.getColorLabel();
                return cl1.compareTo(cl2);
            }
        });
        DUMMY_COMPARER = new FieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) {
                return 0;
            }
        };
        COLOR_FLAG_MIN = -99;
    }

    private static abstract class LocalizedFieldComparer
    implements FieldComparer {
        public final Locale locale;
        public final Collator collator;

        public LocalizedFieldComparer(Locale locale) {
            this.locale = locale;
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }
    }

    private static interface FieldComparer {
        public int compareFields(MailMessage var1, MailMessage var2) throws MessagingException;
    }
}

