/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport.config;

import com.openexchange.exception.OXException;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.server.Initialization;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportPropertiesInit
implements Initialization {
    private static final Logger LOG = LoggerFactory.getLogger(TransportPropertiesInit.class);
    private final AtomicBoolean started = new AtomicBoolean();
    private static final TransportPropertiesInit instance = new TransportPropertiesInit();

    private TransportPropertiesInit() {
    }

    public static TransportPropertiesInit getInstance() {
        return instance;
    }

    public void start() throws OXException {
        if (this.started.get()) {
            LOG.error("{} already started", (Object)this.getClass().getName());
            return;
        }
        TransportProperties.getInstance().loadProperties();
        this.started.set(true);
    }

    public void stop() {
        if (!this.started.get()) {
            LOG.error("{} cannot be stopped since it has not been started before", (Object)this.getClass().getName());
            return;
        }
        TransportProperties.getInstance().resetProperties();
        this.started.set(false);
    }
}

