/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.threader;

import com.openexchange.exception.OXException;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailFields;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.threader.Conversation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Conversations {
    private static final MailField[] FIELDS_HEADERS = new MailField[]{MailField.ID, MailField.HEADERS};
    private static final MailSortField RECEIVED_DATE = MailSortField.RECEIVED_DATE;
    private static final OrderDirection ASC = OrderDirection.ASC;

    private Conversations() {
    }

    public static List<Conversation> conversationsFor(String fullName, int limit, MailFields mailFields, IMailMessageStorage messageStorage) throws OXException {
        IndexRange indexRange = limit > 0 ? new IndexRange(0, limit) : null;
        mailFields.addAll(FIELDS_HEADERS);
        MailMessage[] messages = messageStorage.searchMessages(fullName, indexRange, RECEIVED_DATE, ASC, null, mailFields.toArray());
        String sInReplyTo = "In-Reply-To";
        String sReferences = "References";
        int length = messages.length;
        ArrayList<Conversation> conversations = new ArrayList<Conversation>(length);
        for (int i = 0; i < length; ++i) {
            String inReplyTo;
            MailMessage message = messages[i];
            if (null == message) continue;
            message.setFolder(fullName);
            String references = message.getFirstHeader("References");
            if (null == references && null != (inReplyTo = message.getFirstHeader("In-Reply-To"))) {
                message.setHeader("References", inReplyTo);
            }
            conversations.add(new Conversation(message));
        }
        return conversations;
    }

    public static List<MailMessage> messagesFor(String fullName, int limit, MailFields mailFields, IMailMessageStorage messageStorage) throws OXException {
        IndexRange indexRange = limit > 0 ? new IndexRange(0, limit) : null;
        mailFields.addAll(FIELDS_HEADERS);
        MailMessage[] messages = messageStorage.searchMessages(fullName, indexRange, RECEIVED_DATE, ASC, null, mailFields.toArray());
        String sInReplyTo = "In-Reply-To";
        String sReferences = "References";
        int length = messages.length;
        ArrayList<MailMessage> retval = new ArrayList<MailMessage>(length);
        for (int i = 0; i < length; ++i) {
            String inReplyTo;
            MailMessage message = messages[i];
            if (null == message) continue;
            message.setFolder(fullName);
            String references = message.getFirstHeader("References");
            if (null == references && null != (inReplyTo = message.getFirstHeader("In-Reply-To"))) {
                message.setHeader("References", inReplyTo);
            }
            retval.add(message);
        }
        return retval;
    }

    public static List<Conversation> fold(List<Conversation> toFold) {
        int lastProcessed = -1;
        Iterator<Conversation> iter = toFold.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (i > lastProcessed) {
                Conversations.foldInto(iter.next(), iter);
                lastProcessed = i;
                iter = toFold.iterator();
                i = 0;
                continue;
            }
            iter.next();
            ++i;
        }
        return toFold;
    }

    private static void foldInto(Conversation conversation, Iterator<Conversation> iter) {
        while (iter.hasNext()) {
            Conversation other = iter.next();
            if (!conversation.referencesOrIsReferencedBy(other)) continue;
            iter.remove();
            conversation.join(other);
        }
    }
}

