/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.text;

import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.java.UnsynchronizedByteArrayInputStream;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.TNEFBodyPart;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MimeRawSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mail.uuencode.UUEncodedMultiPart;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.textxtraction.TextXtractService;
import com.openexchange.tools.tnef.TNEF2ICal;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Part;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.CompressedRTFInputStream;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextFinder {
    private static final Logger LOG = LoggerFactory.getLogger(TextFinder.class);
    private boolean textIsHtml = false;
    private final TextXtractService textXtractService = ServerServiceRegistry.getInstance().getService(TextXtractService.class);
    private final HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
    private static final String TNEF_IPM_CONTACT = "IPM.Contact";
    private static final String TNEF_IPM_MS_READ_RECEIPT = "IPM.Microsoft Mail.Read Receipt";

    private String extractPlainText(String content) throws OXException {
        return this.textXtractService.extractFrom((InputStream)new UnsynchronizedByteArrayInputStream(content.getBytes(Charsets.UTF_8)), null);
    }

    public String getText(MailPart p) throws OXException {
        this.textIsHtml = false;
        return this.getTextRecursive(p);
    }

    private String getTextRecursive(MailPart part) throws OXException {
        if (null == part) {
            return null;
        }
        try {
            ContentType ct = part.getContentType();
            if (ct.startsWith("text/")) {
                String content = TextFinder.readContent(part, ct);
                if (ct.startsWith("text/plain")) {
                    UUEncodedMultiPart uuencodedMP;
                    if (UUEncodedMultiPart.isUUEncoded(content) && (uuencodedMP = new UUEncodedMultiPart(content)).isUUEncoded()) {
                        content = uuencodedMP.getCleanText();
                    }
                    this.textIsHtml = false;
                } else if (ct.startsWith("text/htm")) {
                    this.textIsHtml = true;
                    try {
                        content = new Renderer(new Segment(new Source((CharSequence)content), 0, content.length())).setMaxLineLength(9999).setIncludeHyperlinkURLs(false).toString();
                    }
                    catch (StackOverflowError e) {
                        LOG.warn("StackOverflowError while rendering html content. Returning null.");
                        content = this.extractPlainText(content);
                    }
                    catch (Throwable t) {
                        LOG.warn("Error while rendering html content. Returning null.", t);
                        content = null;
                    }
                } else {
                    content = this.extractPlainText(content);
                    this.textIsHtml = false;
                }
                return content;
            }
            if (ct.startsWith("multipart/alternative")) {
                int count = part.getEnclosedCount();
                String text = null;
                for (int i = 0; i < count; ++i) {
                    String s;
                    MailPart bp = part.getEnclosedMailPart(i);
                    ContentType bct = bp.getContentType();
                    if (bct.startsWith("text/plain")) {
                        if (text != null) continue;
                        text = this.getTextRecursive(bp);
                        continue;
                    }
                    if (!(bct.startsWith("text/htm") ? (s = this.getTextRecursive(bp)) != null : bct.startsWith("multipart/") && (s = this.getTextRecursive(bp)) != null)) continue;
                    return s;
                }
                return text;
            }
            if (ct.startsWith("multipart/")) {
                int count = part.getEnclosedCount();
                for (int i = 0; i < count; ++i) {
                    String s = this.getTextRecursive(part.getEnclosedMailPart(i));
                    if (s == null) continue;
                    return s;
                }
            }
            if (TNEFUtils.isTNEFMimeType((String)ct.getBaseType())) {
                return this.handleTNEFPart(part);
            }
            return null;
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private String handleTNEFPart(MailPart part) throws OXException {
        return this.handleTNEFStream(part.getInputStream());
    }

    public String handleTNEFStream(InputStream inputStream) throws OXException {
        try {
            RawInputStream ris;
            MAPIProp prop;
            TNEFInputStream tnefInputStream = new TNEFInputStream(inputStream);
            Message message = new Message(tnefInputStream);
            Attr messageClass = message.getAttribute(32776);
            String messageClassName = messageClass == null ? (null == (prop = message.getMAPIProps().getProp(26)) ? "" : prop.getValue().toString()) : (String)messageClass.getValue();
            if (TNEF_IPM_CONTACT.equalsIgnoreCase(messageClassName)) {
                return null;
            }
            if (TNEF_IPM_MS_READ_RECEIPT.equalsIgnoreCase(messageClassName)) {
                return null;
            }
            if (TNEF2ICal.isVPart(messageClassName)) {
                return null;
            }
            Attr attrBody = Attr.findAttr((List)message.getAttributes(), (int)32780);
            if (attrBody != null) {
                TNEFBodyPart bodyPart = new TNEFBodyPart();
                String value = (String)attrBody.getValue();
                MessageUtility.setText(value, (Part)bodyPart);
                bodyPart.setSize(value.length());
                String s = this.getTextRecursive(MimeMessageConverter.convertPart((Part)bodyPart));
                if (null != s) {
                    return s;
                }
            }
            TNEFBodyPart rtfPart = null;
            MAPIProps mapiProps = message.getMAPIProps();
            if (mapiProps != null && (ris = (RawInputStream)mapiProps.getPropValue(4105)) != null) {
                rtfPart = new TNEFBodyPart();
                byte[] decompressedBytes = CompressedRTFInputStream.decompressRTF((byte[])ris.toByteArray());
                String contentTypeStr = "application/rtf";
                rtfPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(decompressedBytes, contentTypeStr)));
                rtfPart.setHeader("Content-Type", contentTypeStr);
                rtfPart.setSize(decompressedBytes.length);
            }
            return this.getTextRecursive(MimeMessageConverter.convertPart(rtfPart));
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private static String readContent(MailPart mailPart, ContentType contentType) throws OXException, IOException {
        String charset = TextFinder.getCharset(mailPart, contentType);
        try {
            return MessageUtility.readMailPart(mailPart, charset);
        }
        catch (CharConversionException e) {
            String fallback = "ISO-8859-1";
            LOG.warn("Character conversion exception while reading content with charset \"{}\". Using fallback charset \"{}\" instead.", new Object[]{charset, "ISO-8859-1", e});
            return MessageUtility.readMailPart(mailPart, "ISO-8859-1");
        }
    }

    private static String getCharset(MailPart mailPart, ContentType contentType) throws OXException {
        String charset;
        if (mailPart.containsHeader("Content-Type")) {
            String cs = contentType.getCharsetParameter();
            if (!CharsetDetector.isValid((String)cs)) {
                String prev = cs;
                if (contentType.startsWith("text/")) {
                    try {
                        cs = CharsetDetector.detectCharsetFailOnError((InputStream)mailPart.getInputStream());
                    }
                    catch (IOException e) {
                        cs = mailPart instanceof MimeRawSource ? CharsetDetector.detectCharset((InputStream)((MimeRawSource)((Object)mailPart)).getRawInputStream()) : CharsetDetector.getFallback();
                    }
                    LOG.warn("Illegal or unsupported encoding \"{}\". Using auto-detected encoding: \"{}\"", (Object)prev, (Object)cs);
                } else {
                    cs = MailProperties.getInstance().getDefaultMimeCharset();
                    LOG.warn("Illegal or unsupported encoding \"{}\". Using fallback encoding: \"{}\"", (Object)prev, (Object)cs);
                }
            }
            charset = cs;
        } else if (contentType.startsWith("text/")) {
            String cs;
            try {
                cs = CharsetDetector.detectCharsetFailOnError((InputStream)mailPart.getInputStream());
            }
            catch (IOException e) {
                cs = mailPart instanceof MimeRawSource ? CharsetDetector.detectCharset((InputStream)((MimeRawSource)((Object)mailPart)).getRawInputStream()) : CharsetDetector.getFallback();
            }
            charset = cs;
        } else {
            charset = MailProperties.getInstance().getDefaultMimeCharset();
        }
        return charset;
    }
}

