/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure.parser;

import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.upload.impl.UploadFileImpl;
import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.dataobjects.compose.UploadFileMailPart;
import com.openexchange.mail.json.parser.AbortAttachmentHandler;
import com.openexchange.mail.json.parser.IAttachmentHandler;
import com.openexchange.mail.json.parser.PublishAttachmentHandler;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.ParameterizedHeader;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.structure.parser.MIMEStructureParser;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.TransportProviderRegistry;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;

public final class MIMEStructure2ComposedMailParser {
    private final List<ManagedFile> managedFiles;
    private final Session session;
    private final TransportProvider transportProvider;
    private final ComposedMailMessage composedMail;
    private final IAttachmentHandler attachmentHandler;
    private boolean headers;
    private int alternativeLevel;
    private int level;
    private TextBodyMailPart textBodyPart;
    private static final int IN_MEMORY_LIMIT = 0x100000;
    private static final Set<String> HEADERS_ADDRESS = new HashSet<String>(Arrays.asList("from", "to", "cc", "bcc", "reply-to", "sender", "errors-to", "resent-bcc", "resent-cc", "resent-from", "resent-to", "resent-sender", "disposition-notification-to"));
    private static final Set<String> HEADERS_DATE = new HashSet<String>(Arrays.asList("date"));
    private static final String PRIMARY_TEXT = "text/";
    private static final String[] SUB_TEXT = new String[]{"plain", "htm"};

    public MIMEStructure2ComposedMailParser(int accountId, ServerSession session, String protocol, String hostName) throws OXException {
        this.session = session;
        this.managedFiles = new ArrayList<ManagedFile>(4);
        this.transportProvider = TransportProviderRegistry.getTransportProviderBySession(session, accountId);
        this.composedMail = this.transportProvider.getNewComposedMailMessage(session, session.getContext());
        this.attachmentHandler = TransportProperties.getInstance().isPublishOnExceededQuota() && (!TransportProperties.getInstance().isPublishPrimaryAccountOnly() || 0 == accountId) ? new PublishAttachmentHandler(session, this.transportProvider, protocol, hostName) : new AbortAttachmentHandler(session);
    }

    public List<ManagedFile> getManagedFiles() {
        return this.managedFiles;
    }

    public ComposedMailMessage[] parseMessage(JSONObject jsonMessage, List<OXException> warnings) throws OXException {
        this.parseFlags(jsonMessage);
        this.parsePart(jsonMessage);
        this.attachmentHandler.setTextPart(this.textBodyPart);
        return this.attachmentHandler.generateComposedMails(this.composedMail, warnings);
    }

    private void parseFlags(JSONObject jsonMessage) throws OXException {
        try {
            JSONArray jsonUser;
            int length;
            int colorLabel;
            int flags;
            if (jsonMessage.hasAndNotNull("flags") && (flags = jsonMessage.getInt("flags")) > 0) {
                this.composedMail.setFlags(flags);
            }
            if (jsonMessage.hasAndNotNull("color_label") && (colorLabel = jsonMessage.getInt("color_label")) != 0) {
                this.composedMail.setColorLabel(colorLabel);
            }
            if (jsonMessage.hasAndNotNull("user") && (length = (jsonUser = jsonMessage.getJSONArray("user")).length()) > 0) {
                for (int i = length - 1; i >= 0; --i) {
                    this.composedMail.addUserFlag(jsonUser.getString(i));
                }
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void parsePart(JSONObject jsonPart) throws OXException {
        try {
            Map<String, String> m;
            ContentType contentType = new ContentType("text/plain; charset=us-ascii");
            if (this.headers) {
                JSONObject jsonHeaders = jsonPart.getJSONObject("headers");
                MIMEStructure2ComposedMailParser.parseContentType(jsonHeaders, contentType);
                String contentId = MIMEStructure2ComposedMailParser.parseContentID(jsonHeaders);
                if (null == contentId) {
                    m = Collections.emptyMap();
                } else {
                    m = new HashMap(1);
                    m.put("Content-ID", contentId);
                }
            } else {
                MIMEStructure2ComposedMailParser.parseHeaders(jsonPart.getJSONObject("headers"), this.composedMail, contentType);
                m = Collections.emptyMap();
                this.headers = true;
            }
            if (contentType.startsWith(PRIMARY_TEXT)) {
                this.parseSimpleBodyText(jsonPart.getJSONObject("body"), contentType, m);
            } else if (contentType.startsWith("multipart/")) {
                this.parseMultipartBody(jsonPart.getJSONArray("body"), contentType.getSubType());
            } else if (contentType.startsWith("message/rfc822") || contentType.getNameParameter() != null && contentType.getNameParameter().endsWith(".eml")) {
                this.parseMessageBody(jsonPart.getJSONObject("body"));
            } else {
                this.parseSimpleBodyBinary(jsonPart.getJSONObject("body"), contentType, m);
            }
            if (null == this.textBodyPart) {
                this.textBodyPart = this.transportProvider.getNewTextBodyPart("");
                this.composedMail.setContentType("text/plain; charset=UTF-8");
            } else if (this.textBodyPart.getHTML() == null) {
                this.composedMail.setContentType("text/html; charset=UTF-8");
            } else if (this.textBodyPart.getPlainText() == null) {
                this.composedMail.setContentType("text/html; charset=UTF-8");
            } else {
                this.composedMail.setContentType("multipart/alternative");
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void parseMessageBody(JSONObject jsonMessage) throws OXException {
        MailMessage mail = MIMEStructureParser.parseStructure(jsonMessage);
        if (mail.getSize() < 0L) {
            UnsynchronizedByteArrayOutputStream tmp = new UnsynchronizedByteArrayOutputStream(8192);
            mail.writeTo((OutputStream)tmp);
            mail.setSize(tmp.toByteArray().length);
        }
        this.attachmentHandler.addAttachment(this.transportProvider.getNewReferencedMail(mail, this.session));
    }

    private void parseMultipartBody(JSONArray jsonMultiparts, String subtype) throws OXException {
        try {
            int length = jsonMultiparts.length();
            ++this.level;
            if (this.alternativeLevel == 0 && "alternative".equalsIgnoreCase(subtype) && length >= 2) {
                this.alternativeLevel = this.level;
                this.composedMail.setContentType("multipart/alternative");
            }
            for (int i = 0; i < length; ++i) {
                this.parsePart(jsonMultiparts.getJSONObject(i));
            }
            if (this.alternativeLevel == this.level) {
                this.alternativeLevel = 0;
            }
            --this.level;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void parseSimpleBodyText(JSONObject jsonBody, ContentType contentType, Map<String, String> headers) throws OXException {
        try {
            if (MIMEStructure2ComposedMailParser.isText(contentType.getBaseType())) {
                if (contentType.startsWith("text/plain")) {
                    if (null == this.textBodyPart) {
                        this.textBodyPart = this.transportProvider.getNewTextBodyPart(null);
                        this.textBodyPart.setPlainText(jsonBody.getString("data"));
                    } else if (this.alternativeLevel > 0 && this.textBodyPart.getPlainText() == null) {
                        this.textBodyPart.setPlainText(jsonBody.getString("data"));
                    } else {
                        this.addAsAttachment(Charsets.toAsciiBytes((String)jsonBody.getString("data")), contentType, headers);
                    }
                } else if (null == this.textBodyPart) {
                    this.textBodyPart = this.transportProvider.getNewTextBodyPart(jsonBody.getString("data"));
                } else if (this.alternativeLevel > 0 && this.textBodyPart.getHTML() == null) {
                    this.textBodyPart.setText(jsonBody.getString("data"));
                } else {
                    this.addAsAttachment(Charsets.toAsciiBytes((String)jsonBody.getString("data")), contentType, headers);
                }
            } else {
                this.addAsAttachment(Charsets.toAsciiBytes((String)jsonBody.getString("data")), contentType, headers);
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void parseSimpleBodyBinary(JSONObject jsonBody, ContentType contentType, Map<String, String> headers) throws OXException {
        try {
            this.addAsAttachment(Base64.decodeBase64((byte[])Charsets.toAsciiBytes((String)jsonBody.getString("data"))), contentType, headers);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void addAsAttachment(byte[] rawBytes, ContentType contentType, Map<String, String> headers) throws OXException {
        if (rawBytes.length <= 0x100000) {
            this.addInMemory(rawBytes, contentType, headers);
        } else {
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            if (null == mfm) {
                this.addInMemory(rawBytes, contentType, headers);
            } else {
                try {
                    ManagedFile managedFile = mfm.createManagedFile(rawBytes);
                    this.managedFiles.add(managedFile);
                    UploadFileImpl uf = new UploadFileImpl();
                    uf.setContentType(managedFile.getContentType());
                    uf.setFileName(managedFile.getFileName());
                    uf.setSize(managedFile.getSize());
                    uf.setTmpFile(managedFile.getFile());
                    UploadFileMailPart mailPart = this.transportProvider.getNewFilePart(uf);
                    if (!headers.isEmpty()) {
                        for (Map.Entry<String, String> entry : headers.entrySet()) {
                            mailPart.setHeader(entry.getKey(), entry.getValue());
                        }
                    }
                    this.attachmentHandler.addAttachment(mailPart);
                }
                catch (OXException e) {
                    LoggerFactory.getLogger(MIMEStructure2ComposedMailParser.class).warn("Creating managed file failed. Using in-memory version instead.", (Throwable)e);
                    this.addInMemory(rawBytes, contentType, headers);
                }
            }
        }
    }

    private void addInMemory(byte[] rawBytes, ContentType contentType, Map<String, String> headers) throws OXException {
        try {
            MimeBodyPart mimePart = new MimeBodyPart();
            mimePart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(rawBytes, contentType.getBaseType())));
            mimePart.setHeader("Content-Type", contentType.toString());
            mimePart.setHeader("Content-Disposition", "attachment");
            mimePart.setHeader("Content-Transfer-Encoding", "base64");
            MailPart mailPart = MimeMessageConverter.convertPart((Part)mimePart, false);
            if (!headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    mailPart.setHeader(entry.getKey(), entry.getValue());
                }
            }
            this.attachmentHandler.addAttachment(mailPart);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void parseHeaders(JSONObject jsonHeaders, MailMessage composedMail, ContentType contentType) throws OXException {
        try {
            StringBuilder headerNameBuilder = new StringBuilder(16);
            for (Map.Entry entry : jsonHeaders.entrySet()) {
                String name = ((String)entry.getKey()).toLowerCase(Locale.ENGLISH);
                if (HEADERS_ADDRESS.contains(name)) {
                    JSONArray jsonAddresses = (JSONArray)entry.getValue();
                    int length = jsonAddresses.length();
                    ArrayList<QuotedInternetAddress> list = new ArrayList<QuotedInternetAddress>(length);
                    for (int i = length - 1; i >= 0; --i) {
                        void var13_25;
                        JSONObject jsonAddress = jsonAddresses.getJSONObject(i);
                        String address = jsonAddress.getString("address");
                        if (jsonAddress.hasAndNotNull("personal")) {
                            String string = jsonAddress.getString("personal");
                        } else {
                            Object var13_24 = null;
                        }
                        QuotedInternetAddress qia = new QuotedInternetAddress(address, (String)var13_25, "UTF-8");
                        list.add(qia);
                    }
                    if ("from".equals(name)) {
                        composedMail.addFrom(list.toArray(new InternetAddress[list.size()]));
                        continue;
                    }
                    if ("to".equals(name)) {
                        composedMail.addTo(list.toArray(new InternetAddress[list.size()]));
                        continue;
                    }
                    if ("cc".equals(name)) {
                        composedMail.addCc(list.toArray(new InternetAddress[list.size()]));
                        continue;
                    }
                    if ("bcc".equals(name)) {
                        composedMail.addBcc(list.toArray(new InternetAddress[list.size()]));
                        continue;
                    }
                    if ("disposition-notification-to".equals(name)) {
                        composedMail.setDispositionNotification((InternetAddress)list.get(0));
                        continue;
                    }
                    StringAllocator builder = new StringAllocator(list.size() * 16);
                    String delim = ", ";
                    for (InternetAddress internetAddress : list) {
                        builder.insert(0, internetAddress.toString()).insert(0, ", ");
                    }
                    composedMail.setHeader(MIMEStructure2ComposedMailParser.toHeaderCase(name, headerNameBuilder), builder.delete(0, ", ".length()).toString());
                    continue;
                }
                if (HEADERS_DATE.contains(name)) {
                    JSONObject jsonDate = (JSONObject)entry.getValue();
                    composedMail.setHeader(MIMEStructure2ComposedMailParser.toHeaderCase(name, headerNameBuilder), jsonDate.getString("date"));
                    continue;
                }
                if ("content-type".equals(name)) {
                    JSONObject jsonContentType = (JSONObject)entry.getValue();
                    contentType.reset();
                    contentType.setBaseType(jsonContentType.getString("type"));
                    MIMEStructure2ComposedMailParser.parseParameterList(jsonContentType.getJSONObject("params"), contentType);
                    composedMail.setHeader(MIMEStructure2ComposedMailParser.toHeaderCase(name, headerNameBuilder), contentType.toString(true));
                    continue;
                }
                if ("content-disposition".equals(name)) {
                    JSONObject jsonContentDisposition = (JSONObject)entry.getValue();
                    ContentDisposition contentDisposition = new ContentDisposition();
                    contentDisposition.setDisposition(jsonContentDisposition.getString("type"));
                    MIMEStructure2ComposedMailParser.parseParameterList(jsonContentDisposition.getJSONObject("params"), contentDisposition);
                    composedMail.setHeader(MIMEStructure2ComposedMailParser.toHeaderCase(name, headerNameBuilder), contentDisposition.toString(true));
                    continue;
                }
                Object value = entry.getValue();
                if (value instanceof JSONArray) {
                    JSONArray jsonHeader = (JSONArray)value;
                    int length = jsonHeader.length();
                    String headerName = MIMEStructure2ComposedMailParser.toHeaderCase(name, headerNameBuilder);
                    for (int i = length - 1; i >= 0; --i) {
                        composedMail.addHeader(headerName, jsonHeader.getString(i));
                    }
                    continue;
                }
                composedMail.setHeader(MIMEStructure2ComposedMailParser.toHeaderCase(name, headerNameBuilder), (String)value);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private static void parseContentType(JSONObject jsonHeaders, ContentType contentType) throws OXException {
        try {
            if (jsonHeaders.hasAndNotNull("content-type")) {
                JSONObject jsonContentType = jsonHeaders.getJSONObject("content-type");
                contentType.reset();
                contentType.setBaseType(jsonContentType.getString("type"));
                MIMEStructure2ComposedMailParser.parseParameterList(jsonContentType.getJSONObject("params"), contentType);
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private static String parseContentID(JSONObject jsonHeaders) throws OXException {
        try {
            if (jsonHeaders.hasAndNotNull("content-id")) {
                return jsonHeaders.getString("content-id");
            }
            return null;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private static void parseParameterList(JSONObject jsonParameters, ParameterizedHeader parameterizedHeader) throws JSONException {
        for (Map.Entry entry : jsonParameters.entrySet()) {
            String name = ((String)entry.getKey()).toLowerCase(Locale.ENGLISH);
            if ("read-date".equals(name)) {
                JSONObject jsonDate = (JSONObject)entry.getValue();
                parameterizedHeader.addParameter(name, jsonDate.getString("date"));
                continue;
            }
            parameterizedHeader.addParameter(name, (String)entry.getValue());
        }
    }

    private static boolean isText(String contentType) {
        if (contentType.startsWith(PRIMARY_TEXT, 0)) {
            int off = PRIMARY_TEXT.length();
            for (String subtype : SUB_TEXT) {
                if (!contentType.startsWith(subtype, off)) continue;
                return true;
            }
        }
        return false;
    }

    private static String toHeaderCase(String name, StringBuilder builder) {
        StringBuilder sb;
        if (null == name) {
            return null;
        }
        if ("mime-version".equals(name)) {
            return "MIME-Version";
        }
        if ("message-id".equals(name)) {
            return "Message-ID";
        }
        int len = name.length();
        if (len <= 0) {
            return "";
        }
        if (builder == null) {
            sb = new StringBuilder(len);
        } else {
            sb = builder;
            sb.setLength(0);
        }
        sb.append(Character.toUpperCase(name.charAt(0)));
        int i = 1;
        while (i < len) {
            char c;
            if ('-' == (c = name.charAt(i++)) && i < len) {
                sb.append(c).append(Character.toUpperCase(name.charAt(i++)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

