/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.ComparablePattern;
import com.openexchange.mail.search.ComparisonType;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import java.util.Date;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.slf4j.LoggerFactory;

public final class SentDateTerm
extends SearchTerm<ComparablePattern<Date>> {
    private static final long serialVersionUID = -1602773060126517090L;
    private final ComparablePattern<Date> pattern;

    public SentDateTerm(final ComparisonType comparisonType, final Date sentDate) {
        this.pattern = new ComparablePattern<Date>(){

            @Override
            public ComparisonType getComparisonType() {
                return comparisonType;
            }

            @Override
            public Date getPattern() {
                return sentDate;
            }
        };
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ComparablePattern<Date> getPattern() {
        return this.pattern;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.SENT_DATE);
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        Date sentDate = mailMessage.getSentDate();
        if (null == sentDate) {
            return false;
        }
        Object pattern = this.getPattern();
        ComparisonType comparisonType = pattern.getComparisonType();
        if (ComparisonType.EQUALS == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() == sentDate.getTime();
        }
        if (ComparisonType.LESS_THAN == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() > sentDate.getTime();
        }
        if (ComparisonType.GREATER_THAN == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() < sentDate.getTime();
        }
        return ((Date)pattern.getPattern()).getTime() == sentDate.getTime();
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        Date sentDate;
        try {
            sentDate = msg.getSentDate();
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(SentDateTerm.class).warn("Error during search.", (Throwable)e);
            return false;
        }
        if (null == sentDate) {
            return false;
        }
        Object pattern = this.getPattern();
        ComparisonType comparisonType = pattern.getComparisonType();
        if (ComparisonType.EQUALS == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() == sentDate.getTime();
        }
        if (ComparisonType.LESS_THAN == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() > sentDate.getTime();
        }
        if (ComparisonType.GREATER_THAN == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() < sentDate.getTime();
        }
        return ((Date)pattern.getPattern()).getTime() == sentDate.getTime();
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        Object pattern = this.getPattern();
        return new javax.mail.search.SentDateTerm(pattern.getComparisonType().getType(), (Date)pattern.getPattern());
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return this.getJavaMailSearchTerm();
    }
}

