/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.slf4j.LoggerFactory;

public final class FlagTerm
extends SearchTerm<Integer> {
    private static final long serialVersionUID = -6887694637971347838L;
    private final boolean set;
    private final int flags;

    public FlagTerm(int flag, boolean set) {
        this.flags = flag;
        this.set = set;
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Integer getPattern() {
        return this.set ? Integer.valueOf(this.flags) : Integer.valueOf(this.flags * -1);
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.FLAGS);
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        if (this.set) {
            return (mailMessage.getFlags() & this.flags) == this.flags;
        }
        return (mailMessage.getFlags() & this.flags) == 0;
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        Flags msgFlags;
        Flags flagsObj = MimeMessageConverter.convertMailFlags(this.flags);
        try {
            msgFlags = msg.getFlags();
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(FlagTerm.class).warn("Error during search.", (Throwable)e);
            return false;
        }
        return this.set ? msgFlags.contains(flagsObj) : !msgFlags.contains(flagsObj);
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        return new javax.mail.search.FlagTerm(MimeMessageConverter.convertMailFlags(this.flags), this.set);
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return this.getJavaMailSearchTerm();
    }
}

