/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.loginhandler;

import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginResult;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportLoginHandler
implements LoginHandlerService {
    private static final Logger LOG = LoggerFactory.getLogger(TransportLoginHandler.class);
    private static final List<File.Field> FIELDS = Collections.unmodifiableList(new ArrayList<File.Field>(Arrays.asList(File.Field.ID, File.Field.CREATED, File.Field.CREATED_BY)));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleLogin(LoginResult login) throws OXException {
        try {
            int folderId;
            int lookUpFolder;
            OXFolderAccess folderAccess;
            FolderObject defaultInfoStoreFolder;
            Context ctx = login.getContext();
            ServerSession serverSession = TransportLoginHandler.getServerSessionFrom(login.getSession(), ctx);
            UserPermissionBits permissionBits = serverSession.getUserPermissionBits();
            if (!TransportProperties.getInstance().isPublishOnExceededQuota() || !permissionBits.hasInfostore() || !(defaultInfoStoreFolder = (folderAccess = new OXFolderAccess(ctx)).getDefaultFolder(serverSession.getUserId(), 8)).getEffectiveUserPermission(serverSession.getUserId(), permissionBits).canCreateSubfolders()) return;
            String name = TransportProperties.getInstance().getPublishingInfostoreFolder();
            if ("i18n-defined".equals(name)) {
                name = "E-Mail attachments";
            }
            if (-1 == (lookUpFolder = OXFolderSQL.lookUpFolder(defaultInfoStoreFolder.getObjectID(), name, 8, null, ctx))) {
                Class<TransportLoginHandler> clazz = TransportLoginHandler.class;
                synchronized (TransportLoginHandler.class) {
                    folderId = this.createIfAbsent(serverSession, ctx, name, defaultInfoStoreFolder);
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                }
            } else {
                folderId = lookUpFolder;
            }
            {
                long now;
                serverSession.setParameter(MailSessionParameterNames.getParamPublishingInfostoreFolderID(), folderId);
                if (!TransportProperties.getInstance().publishedDocumentsExpire()) {
                    return;
                }
                IDBasedFileAccess fileAccess = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class).createAccess((Session)serverSession);
                List<String> toRemove = this.getElapsedDocuments(folderId, fileAccess, serverSession, now = System.currentTimeMillis());
                if (toRemove.isEmpty()) return;
                fileAccess.startTransaction();
                try {
                    fileAccess.removeDocument(toRemove, now);
                    fileAccess.commit();
                    return;
                }
                finally {
                    fileAccess.finish();
                }
            }
        }
        catch (SQLException e) {
            throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getElapsedDocuments(int folderId, IDBasedFileAccess fileAccess, ServerSession serverSession, long now) throws OXException {
        SearchIterator searchIterator = fileAccess.getDocuments(String.valueOf(folderId), FIELDS).results();
        try {
            ArrayList<String> ret;
            long timeToLive = TransportProperties.getInstance().getPublishedDocumentTimeToLive();
            int userId = serverSession.getUserId();
            if (searchIterator.size() != -1) {
                int size = searchIterator.size();
                ret = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    File file = (File)searchIterator.next();
                    if (!TransportLoginHandler.isOwner(userId, file.getCreatedBy()) || !TransportLoginHandler.isElapsed(now, file.getCreated().getTime(), timeToLive)) continue;
                    ret.add(file.getId());
                }
            } else {
                ret = new ArrayList<String>();
                while (searchIterator.hasNext()) {
                    File file = (File)searchIterator.next();
                    if (!TransportLoginHandler.isOwner(userId, file.getCreatedBy()) || !TransportLoginHandler.isElapsed(now, file.getCreated().getTime(), timeToLive)) continue;
                    ret.add(file.getId());
                }
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
        finally {
            try {
                searchIterator.close();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private static boolean isOwner(int sessionUser, int createdBy) {
        return sessionUser == createdBy;
    }

    private static boolean isElapsed(long now, long creationDate, long ttl) {
        return now - creationDate > ttl;
    }

    private int createIfAbsent(Session session, Context ctx, String name, FolderObject defaultInfoStoreFolder) throws SQLException, OXException {
        int lookUpFolder = OXFolderSQL.lookUpFolder(defaultInfoStoreFolder.getObjectID(), name, 8, null, ctx);
        if (-1 == lookUpFolder) {
            FolderObject fo = this.createNewInfostoreFolder(session.getUserId(), name, defaultInfoStoreFolder.getObjectID());
            return OXFolderManager.getInstance(session).createFolder(fo, true, System.currentTimeMillis()).getObjectID();
        }
        return lookUpFolder;
    }

    private FolderObject createNewInfostoreFolder(int adminId, String name, int parent) {
        FolderObject newFolder = new FolderObject();
        newFolder.setFolderName(name);
        newFolder.setParentFolderID(parent);
        newFolder.setType(2);
        newFolder.setModule(8);
        OCLPermission perm = new OCLPermission();
        perm.setEntity(adminId);
        perm.setFolderAdmin(true);
        perm.setFolderPermission(128);
        perm.setReadObjectPermission(128);
        perm.setWriteObjectPermission(128);
        perm.setDeleteObjectPermission(128);
        perm.setGroupPermission(false);
        newFolder.setPermissions(Collections.singletonList(perm));
        return newFolder;
    }

    @Override
    public void handleLogout(LoginResult logout) throws OXException {
    }

    private static ServerSession getServerSessionFrom(Session session, Context context) {
        if (session instanceof ServerSession) {
            return (ServerSession)session;
        }
        return ServerSessionAdapter.valueOf(session, context);
    }
}

