/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.Collections;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.PUT, name="list", description="Get a list of mails", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for mails are defined in Detailed mail data. The alias \"list\" uses the predefined columnset [20, 1, 5, 2, 500, 501, 502, 505, 523, 525, 526, 527, 542, 555, 102, 602, 592, 101, 551, 552, 543, 547, 548, 549, 556, 569]"), @Parameter(name="headers", description="(preliminary) A comma-separated list of header names. Each name requests denoted header from each mail")}, requestBody="An array with one object for each requested mail. Each object contains the fields folder and id.", responseDescription="Response (not IMAP: with timestamp): An array with mail data. Each array element describes one mail and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter followed by requested headers.")
public final class ListAction
extends AbstractMailAction {
    private static final Logger LOG = LoggerFactory.getLogger(ListAction.class);

    public ListAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            ServerSession session = req.getSession();
            int[] columns = req.checkIntArray("columns");
            String[] headers = req.optStringArray("headers");
            Map<String, List<String>> idMap = ListAction.fillMapByArray((JSONArray)req.getRequest().getData());
            if (idMap.isEmpty()) {
                return new AJAXRequestResult(java.util.Collections.emptyList(), "mail");
            }
            MailServletInterface mailInterface = this.getMailInterface(req);
            LinkedList<MailMessage> list = new LinkedList<MailMessage>();
            for (Map.Entry<String, List<String>> entry : idMap.entrySet()) {
                MailMessage[] mails = mailInterface.getMessageList(entry.getKey(), ListAction.toArray((Collection<String>)entry.getValue()), columns, headers);
                int accountID = mailInterface.getAccountID();
                for (int i = 0; i < mails.length; ++i) {
                    MailMessage mail = mails[i];
                    if (mail == null) continue;
                    if (!mail.containsAccountId()) {
                        mail.setAccountId(accountID);
                    }
                    list.add(mail);
                }
            }
            return new AJAXRequestResult(list, "mail");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private static final Map<String, List<String>> fillMapByArray(JSONArray idArray) throws JSONException, OXException {
        int length = idArray.length();
        if (length <= 0) {
            return java.util.Collections.emptyMap();
        }
        HashMap<String, List<String>> idMap = Collections.newHashMap(4);
        String parameterFolderId = "folder";
        String parameterId = "id";
        JSONObject idObject = idArray.getJSONObject(0);
        String folder = ListAction.ensureString("folder", idObject);
        List<String> list = new ArrayList<String>(length);
        idMap.put(folder, list);
        list.add(ListAction.ensureString("id", idObject));
        for (int i = 1; i < length; ++i) {
            JSONObject idObject2 = idArray.getJSONObject(i);
            String fld = ListAction.ensureString("folder", idObject2);
            if (!folder.equals(fld)) {
                folder = fld;
                List tmp = (List)idMap.get(folder);
                if (tmp == null) {
                    list = new ArrayList(length);
                    idMap.put(folder, list);
                } else {
                    list = tmp;
                }
            }
            list.add(ListAction.ensureString("id", idObject2));
        }
        return idMap;
    }

    private static String ensureString(String key, JSONObject jo) throws OXException {
        if (!jo.hasAndNotNull(key)) {
            throw MailExceptionCode.MISSING_PARAMETER.create(key);
        }
        return jo.optString(key);
    }

    private static String[] toArray(Collection<String> c) {
        return c.toArray(new String[c.size()]);
    }
}

