/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects.compose;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.datasource.FileDataSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.utils.MessageUtility;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UploadFileMailPart
extends MailPart
implements ComposedMailPart {
    private static final long serialVersionUID = 257902073011243269L;
    private static final transient Logger LOG = LoggerFactory.getLogger(UploadFileMailPart.class);
    private final File uploadFile;
    private transient DataSource dataSource;
    private transient Object cachedContent;
    private static final String TEXT = "text/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected UploadFileMailPart(UploadFile uploadFile) throws OXException {
        String preparedFileName;
        block7: {
            ContentType contentType;
            block8: {
                this.uploadFile = uploadFile.getTmpFile();
                preparedFileName = uploadFile.getPreparedFileName();
                try {
                    this.setContentType(UploadFileMailPart.prepareContentType(uploadFile.getContentType(), preparedFileName));
                }
                catch (OXException e) {
                    this.setContentType(MimeType2ExtMap.getContentType(preparedFileName));
                }
                contentType = this.getContentType();
                if (!contentType.startsWith(TEXT) || !"GB18030".equalsIgnoreCase(contentType.getCharsetParameter())) break block8;
                FileInputStream in = null;
                try {
                    in = new FileInputStream(this.uploadFile);
                    contentType.setCharsetParameter(CharsetDetector.detectCharset((InputStream)in));
                    this.setContentType(contentType);
                }
                catch (IOException e) {
                    Streams.close(in);
                    break block7;
                    catch (Throwable throwable) {
                        Streams.close(in);
                        throw throwable;
                    }
                }
                Streams.close((Closeable)in);
                break block7;
            }
            if (contentType.startsWith("application/force")) {
                contentType.setBaseType(MimeType2ExtMap.getContentType(preparedFileName));
                this.setContentType(contentType);
            }
        }
        this.setFileName(preparedFileName);
        this.setSize(uploadFile.getSize());
        ContentDisposition cd = new ContentDisposition();
        cd.setDisposition("attachment");
        cd.setFilenameParameter(this.getFileName());
        this.setContentDisposition(cd);
    }

    private static String prepareContentType(String contentType, String preparedFileName) {
        if (null == contentType || contentType.length() == 0) {
            return "application/octet-stream";
        }
        int mlen = contentType.length() - 1;
        String retval = 0 == contentType.indexOf(34) && mlen == contentType.lastIndexOf(34) ? contentType.substring(1, mlen) : contentType;
        if ("multipart/form-data".equalsIgnoreCase(retval)) {
            return MimeType2ExtMap.getContentType(preparedFileName);
        }
        return contentType;
    }

    private DataSource getDataSource() {
        if (null == this.dataSource) {
            try {
                if (this.getContentType().getCharsetParameter() == null && this.getContentType().startsWith(TEXT)) {
                    String cs = CharsetDetector.detectCharset((InputStream)new FileInputStream(this.uploadFile));
                    this.getContentType().setCharsetParameter(cs);
                    LOG.warn("Uploaded file contains textual content but does not specify a charset. Assumed charset is: {}", (Object)cs);
                }
                this.dataSource = new FileDataSource(this.uploadFile, this.getContentType().toString());
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
                this.dataSource = new MessageDataSource(new byte[0], "application/octet-stream");
            }
        }
        return this.dataSource;
    }

    public File getUploadFile() {
        return this.uploadFile;
    }

    @Override
    public Object getContent() throws OXException {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        if (this.getContentType().isMimeType("text/*")) {
            String charset = this.getContentType().getCharsetParameter();
            if (charset == null) {
                try {
                    charset = CharsetDetector.detectCharset((InputStream)new FileInputStream(this.uploadFile));
                    LOG.warn("Uploaded file contains textual content but does not specify a charset. Assumed charset is: {}", (Object)charset);
                }
                catch (FileNotFoundException e) {
                    throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                }
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.uploadFile);
                this.cachedContent = MessageUtility.readStream(fis, charset);
            }
            catch (FileNotFoundException e) {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        LOG.error("", (Throwable)e);
                    }
                }
            }
            return this.cachedContent;
        }
        return null;
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return new DataHandler(this.getDataSource());
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        try {
            return new FileInputStream(this.uploadFile);
        }
        catch (FileNotFoundException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void loadContent() {
    }

    @Override
    public void prepareForCaching() {
    }

    @Override
    public ComposedMailPart.ComposedPartType getType() {
        return ComposedMailPart.ComposedPartType.FILE;
    }
}

