/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.cache.DoubleKeyMap;
import com.openexchange.mail.cache.MailCacheConfiguration;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailMessageCache {
    private static final String ANNOT_UNCHECKED = "unchecked";
    private static final MailFieldUpdater flagsUpdater = new MailFieldUpdater(){

        @Override
        public void updateField(MailMessage mail, Object newValue) {
            int newFlags = mail.getFlags();
            int flags = (Integer)newValue;
            boolean set = flags > 0;
            int n = flags = set ? flags : flags * -1;
            if ((flags & 1) > 0) {
                int n2 = newFlags = set ? newFlags | 1 : newFlags & 0xFFFFFFFE;
            }
            if ((flags & 2) > 0) {
                int n3 = newFlags = set ? newFlags | 2 : newFlags & 0xFFFFFFFD;
            }
            if ((flags & 4) > 0) {
                int n4 = newFlags = set ? newFlags | 4 : newFlags & 0xFFFFFFFB;
            }
            if ((flags & 8) > 0) {
                int n5 = newFlags = set ? newFlags | 8 : newFlags & 0xFFFFFFF7;
            }
            if ((flags & 0x20) > 0) {
                int n6 = newFlags = set ? newFlags | 0x20 : newFlags & 0xFFFFFFDF;
            }
            if ((flags & 0x40) > 0) {
                int n7 = newFlags = set ? newFlags | 0x40 : newFlags & 0xFFFFFFBF;
            }
            if ((flags & 0x80) > 0) {
                int n8 = newFlags = set ? newFlags | 0x80 : newFlags & 0xFFFFFF7F;
            }
            if ((flags & 0x100) > 0) {
                int n9 = newFlags = set ? newFlags | 0x100 : newFlags & 0xFFFFFEFF;
            }
            if ((flags & 0x200) > 0) {
                newFlags = set ? newFlags | 0x200 : newFlags & 0xFFFFFDFF;
            }
            mail.setFlags(newFlags);
        }
    };
    private static final MailFieldUpdater colorFlagUpdater = new MailFieldUpdater(){

        @Override
        public void updateField(MailMessage mail, Object newValue) {
            mail.setColorLabel((Integer)newValue);
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(MailMessageCache.class);
    private static final Object[] EMPTY_ARGS = new Object[0];
    static final String REGION_NAME = "MailMessageCache";
    private static final ConcurrentMap<CacheKey, ReadWriteLock> contextLocks = new ConcurrentHashMap<CacheKey, ReadWriteLock>();
    private static volatile MailMessageCache singleton;
    private Cache cache;

    private static MailFieldUpdater[] createMailFieldUpdater(MailListField[] changedFields) {
        MailFieldUpdater[] updaters = new MailFieldUpdater[changedFields.length];
        block4: for (int i = 0; i < changedFields.length; ++i) {
            switch (changedFields[i]) {
                case FLAGS: {
                    updaters[i] = flagsUpdater;
                    continue block4;
                }
                case COLOR_LABEL: {
                    updaters[i] = colorFlagUpdater;
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("No Updater for MailListField." + changedFields[i].toString());
                }
            }
        }
        return updaters;
    }

    private MailMessageCache() throws OXException {
        this.initCache();
    }

    public void initCache() throws OXException {
        if (!MailCacheConfiguration.getInstance().isStarted()) {
            throw MailExceptionCode.INITIALIZATION_PROBLEM.create();
        }
        if (this.cache != null) {
            return;
        }
        this.cache = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(REGION_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCache() throws OXException {
        if (this.cache == null) {
            return;
        }
        try {
            this.cache.clear();
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (null != cacheService) {
                cacheService.freeCache(REGION_NAME);
            }
        }
        finally {
            this.cache = null;
        }
    }

    private static ReadWriteLock getLock(CacheKey key) {
        ReentrantReadWriteLock tmp;
        ReadWriteLock l = (ReadWriteLock)contextLocks.get(key);
        if (l == null && null == (l = contextLocks.putIfAbsent(key, tmp = new ReentrantReadWriteLock()))) {
            l = tmp;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MailMessageCache getInstance() throws OXException {
        MailMessageCache tmp = singleton;
        if (null != tmp) return tmp;
        Class<MailMessageCache> clazz = MailMessageCache.class;
        synchronized (MailMessageCache.class) {
            tmp = singleton;
            if (null != tmp) return tmp;
            singleton = new MailMessageCache();
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseInstance() {
        if (null == singleton) return;
        Class<MailMessageCache> clazz = MailMessageCache.class;
        synchronized (MailMessageCache.class) {
            if (null == singleton) return;
            singleton = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCachedMessages(String[] uids, int accountId, String fullname, int userId, int cid, MailListField[] changedFields, Object[] newValues) {
        if (null == this.cache) {
            return;
        }
        if (null == uids) {
            this.updateCachedMessages(accountId, fullname, userId, cid, changedFields, newValues);
            return;
        }
        CacheKey mapKey = this.getMapKey(userId, cid);
        Lock writeLock = MailMessageCache.getLock(mapKey).writeLock();
        writeLock.lock();
        try {
            DoubleKeyMap map = (DoubleKeyMap)this.cache.get((Serializable)mapKey);
            if (map == null) {
                return;
            }
            MailMessage[] mails = (MailMessage[])map.getValues(this.getEntryKey(accountId, fullname), uids);
            if (mails != null && mails.length > 0) {
                MailFieldUpdater[] updaters = MailMessageCache.createMailFieldUpdater(changedFields);
                for (MailMessage mail : mails) {
                    if (mail == null) continue;
                    for (int i = 0; i < updaters.length; ++i) {
                        updaters[i].updateField(mail, newValues[i]);
                    }
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCachedMessages(int accountId, String fullname, int userId, int cid, MailListField[] changedFields, Object[] newValues) {
        if (null == this.cache) {
            return;
        }
        CacheKey mapKey = this.getMapKey(userId, cid);
        Lock writeLock = MailMessageCache.getLock(mapKey).writeLock();
        writeLock.lock();
        try {
            DoubleKeyMap map = (DoubleKeyMap)this.cache.get((Serializable)mapKey);
            if (map == null) {
                return;
            }
            MailMessage[] mails = (MailMessage[])map.getValues(this.getEntryKey(accountId, fullname));
            if (mails != null && mails.length > 0) {
                MailFieldUpdater[] updaters = MailMessageCache.createMailFieldUpdater(changedFields);
                for (MailMessage mail : mails) {
                    if (mail == null) continue;
                    for (int i = 0; i < updaters.length; ++i) {
                        updaters[i].updateField(mail, newValues[i]);
                    }
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean containsUserMessages(int userId, int cid) {
        if (null == this.cache) {
            return false;
        }
        return this.cache.get((Serializable)this.getMapKey(userId, cid)) != null;
    }

    public boolean containsFolderMessages(int accountId, String fullname, int userId, int cid) {
        if (null == this.cache) {
            return false;
        }
        CacheKey mapKey = this.getMapKey(userId, cid);
        DoubleKeyMap map = (DoubleKeyMap)this.cache.get((Serializable)mapKey);
        if (map == null) {
            return false;
        }
        return map.containsKey(this.getEntryKey(accountId, fullname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserMessages(int userId, int cid) throws OXException {
        Cache cache = this.cache;
        if (null == cache) {
            return;
        }
        CacheKey mapKey = this.getMapKey(userId, cid);
        if (cache.get((Serializable)mapKey) == null) {
            return;
        }
        Lock writeLock = MailMessageCache.getLock(mapKey).writeLock();
        writeLock.lock();
        try {
            cache.remove((Serializable)mapKey);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolderMessages(int accountId, String fullname, int userId, int cid) {
        if (null == this.cache) {
            return;
        }
        CacheKey mapKey = this.getMapKey(userId, cid);
        Lock writeLock = MailMessageCache.getLock(mapKey).writeLock();
        writeLock.lock();
        try {
            DoubleKeyMap map = (DoubleKeyMap)this.cache.get((Serializable)mapKey);
            if (map == null) {
                return;
            }
            map.removeValues(this.getEntryKey(accountId, fullname));
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessages(String[] uids, int accountId, String fullname, int userId, int cid) {
        if (null == this.cache) {
            return;
        }
        CacheKey mapKey = this.getMapKey(userId, cid);
        Lock writeLock = MailMessageCache.getLock(mapKey).writeLock();
        writeLock.lock();
        try {
            DoubleKeyMap map = (DoubleKeyMap)this.cache.get((Serializable)mapKey);
            if (map == null) {
                return;
            }
            if (null == uids) {
                map.removeValues(this.getEntryKey(accountId, fullname));
            } else {
                map.removeValues(this.getEntryKey(accountId, fullname), uids);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailMessage[] getMessages(String[] uids, int accountId, String fullname, int userId, int cid) {
        if (null == this.cache) {
            return null;
        }
        CacheKey mapKey = this.getMapKey(userId, cid);
        Lock readLock = MailMessageCache.getLock(mapKey).readLock();
        readLock.lock();
        try {
            DoubleKeyMap map = (DoubleKeyMap)this.cache.get((Serializable)mapKey);
            if (null == map) {
                MailMessage[] mailMessageArray = null;
                return mailMessageArray;
            }
            CacheKey entryKey = this.getEntryKey(accountId, fullname);
            if (!map.containsKey(entryKey)) {
                MailMessage[] mailMessageArray = null;
                return mailMessageArray;
            }
            MailMessage[] retval = new MailMessage[uids.length];
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = (MailMessage)map.getValue(entryKey, uids[i]);
                if (null != retval[i]) continue;
                MailMessage[] mailMessageArray = null;
                return mailMessageArray;
            }
            MailMessage[] mailMessageArray = retval;
            return mailMessageArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessages(int accountId, MailMessage[] mails, int userId, int cid) throws OXException {
        if (null == this.cache) {
            return;
        }
        if (mails == null || mails.length == 0) {
            return;
        }
        CacheKey mapKey = this.getMapKey(userId, cid);
        Lock writeLock = MailMessageCache.getLock(mapKey).writeLock();
        writeLock.lock();
        try {
            DoubleKeyMap<CacheKey, String, MailMessage> map = (DoubleKeyMap<CacheKey, String, MailMessage>)this.cache.get((Serializable)mapKey);
            if (null == map) {
                map = new DoubleKeyMap<CacheKey, String, MailMessage>(MailMessage.class);
                this.cache.put((Serializable)mapKey, map, false);
            }
            for (MailMessage mail : mails) {
                if (mail == null) continue;
                mail.prepareForCaching();
                map.putValue(this.getEntryKey(accountId, mail.getFolder()), mail.getMailId(), mail);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private CacheKey getMapKey(int userId, int cid) {
        return this.cache.newCacheKey(cid, userId);
    }

    private CacheKey getEntryKey(int accountId, String fullname) {
        return this.cache.newCacheKey(accountId, new Serializable[]{fullname});
    }

    private static interface MailFieldUpdater {
        public void updateField(MailMessage var1, Object var2);
    }
}

