/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import com.openexchange.caching.CacheService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailCacheConfiguration
implements Initialization {
    private static final Logger LOG = LoggerFactory.getLogger(MailCacheConfiguration.class);
    private static final MailCacheConfiguration instance = new MailCacheConfiguration();
    private final AtomicBoolean started = new AtomicBoolean();

    private MailCacheConfiguration() {
    }

    public static MailCacheConfiguration getInstance() {
        return instance;
    }

    private void configure() throws OXException {
        File cacheConfigFile = ServerServiceRegistry.getInstance().getService(ConfigurationService.class).getFileByName("mailcache.ccf");
        if (cacheConfigFile == null) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create("mailcache.ccf");
        }
        try {
            ServerServiceRegistry.getInstance().getService(CacheService.class).loadConfiguration((InputStream)new FileInputStream(cacheConfigFile));
        }
        catch (FileNotFoundException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            LOG.warn("{} has already been started. Aborting.", (Object)MailCacheConfiguration.class.getSimpleName());
        }
        this.configure();
    }

    public void stop() {
        CacheService cacheService;
        if (!this.started.compareAndSet(true, false)) {
            LOG.warn("{} has already been stopped. Aborting.", (Object)MailCacheConfiguration.class.getSimpleName());
        }
        if (null != (cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class))) {
            try {
                cacheService.freeCache("MailMessageCache");
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }
}

