/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.attachment;

import com.openexchange.exception.OXException;
import com.openexchange.mail.attachment.AttachmentToken;
import com.openexchange.mail.attachment.AttachmentTokenConstants;
import com.openexchange.session.Session;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttachmentTokenRegistry
implements AttachmentTokenConstants {
    protected static final Logger LOG = LoggerFactory.getLogger(AttachmentTokenRegistry.class);
    private static volatile AttachmentTokenRegistry singleton;
    private final ConcurrentMap<Key, ConcurrentMap<String, AttachmentToken>> map = new ConcurrentHashMap<Key, ConcurrentMap<String, AttachmentToken>>();
    private final ConcurrentMap<String, AttachmentToken> tokens = new ConcurrentHashMap<String, AttachmentToken>();
    private final ScheduledTimerTask timerTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AttachmentTokenRegistry getInstance() throws OXException {
        AttachmentTokenRegistry tmp = singleton;
        if (null != tmp) return tmp;
        Class<AttachmentTokenRegistry> clazz = AttachmentTokenRegistry.class;
        synchronized (AttachmentTokenRegistry.class) {
            tmp = singleton;
            if (null != tmp) return tmp;
            singleton = tmp = new AttachmentTokenRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseInstance() {
        if (null == singleton) return;
        Class<AttachmentTokenRegistry> clazz = AttachmentTokenRegistry.class;
        synchronized (AttachmentTokenRegistry.class) {
            if (null == singleton) return;
            singleton.dispose();
            singleton = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private AttachmentTokenRegistry() throws OXException {
        TimerService timerService = ThreadPools.getTimerService();
        if (null != timerService) {
            CleanExpiredTokensRunnable task = new CleanExpiredTokensRunnable(this.map, this.tokens);
            this.timerTask = timerService.scheduleWithFixedDelay((Runnable)task, 300000L, 300000L);
        } else {
            this.timerTask = null;
        }
    }

    private void dispose() {
        ScheduledTimerTask timerTask = this.timerTask;
        if (null != timerTask) {
            timerTask.cancel(false);
        }
        this.tokens.clear();
        this.map.clear();
    }

    public void dropFor(int userId, int contextId) {
        ConcurrentMap userTokens = (ConcurrentMap)this.map.remove(AttachmentTokenRegistry.keyFor(userId, contextId));
        if (null != userTokens) {
            Iterator iter = userTokens.values().iterator();
            while (iter.hasNext()) {
                AttachmentToken token = (AttachmentToken)iter.next();
                this.tokens.remove(token.getId());
                iter.remove();
            }
        }
        LOG.debug("Cleaned user-sensitive attachment tokens for user {} in context {}", (Object)userId, (Object)contextId);
    }

    public void dropFor(Session session) {
        this.dropFor(session.getUserId(), session.getContextId());
    }

    public void removeToken(String tokenId) {
        AttachmentToken attachmentToken = (AttachmentToken)this.tokens.remove(tokenId);
        if (null == attachmentToken) {
            return;
        }
        Key key = AttachmentTokenRegistry.keyFor(attachmentToken.getUserId(), attachmentToken.getContextId());
        ConcurrentMap userTokens = (ConcurrentMap)this.map.get(key);
        if (null != userTokens) {
            userTokens.remove(tokenId);
            if (userTokens.isEmpty()) {
                this.map.remove(key);
            }
        }
    }

    public AttachmentToken getToken(String tokenId) {
        AttachmentToken attachmentToken = (AttachmentToken)this.tokens.get(tokenId);
        if (null == attachmentToken) {
            return null;
        }
        if (attachmentToken.isExpired()) {
            this.removeToken(tokenId);
            return null;
        }
        if (attachmentToken.isOneTime()) {
            this.removeToken(tokenId);
            return attachmentToken;
        }
        return attachmentToken.touch();
    }

    public void putToken(AttachmentToken token, Session session) {
        ConcurrentHashMap<String, AttachmentToken> newmap;
        Key key = AttachmentTokenRegistry.keyFor(session);
        ConcurrentHashMap<String, AttachmentToken> userTokens = (ConcurrentHashMap<String, AttachmentToken>)this.map.remove(key);
        if (null == userTokens && null == (userTokens = (ConcurrentMap)this.map.putIfAbsent(key, newmap = new ConcurrentHashMap<String, AttachmentToken>()))) {
            userTokens = newmap;
        }
        userTokens.put(token.getId(), token);
        this.tokens.put(token.getId(), token);
    }

    private static Key keyFor(Session session) {
        return AttachmentTokenRegistry.keyFor(session.getUserId(), session.getContextId());
    }

    protected static Key keyFor(int user, int context) {
        return new Key(user, context);
    }

    private static final class CleanExpiredTokensRunnable
    implements Runnable {
        private final ConcurrentMap<Key, ConcurrentMap<String, AttachmentToken>> rmap;
        private final ConcurrentMap<String, AttachmentToken> rtokens;

        protected CleanExpiredTokensRunnable(ConcurrentMap<Key, ConcurrentMap<String, AttachmentToken>> rmap, ConcurrentMap<String, AttachmentToken> rtokens) {
            this.rmap = rmap;
            this.rtokens = rtokens;
        }

        @Override
        public void run() {
            try {
                Iterator iterator = this.rtokens.values().iterator();
                while (iterator.hasNext()) {
                    AttachmentToken token = (AttachmentToken)iterator.next();
                    if (!token.isExpired()) continue;
                    iterator.remove();
                    ConcurrentMap userTokens = (ConcurrentMap)this.rmap.get(AttachmentTokenRegistry.keyFor(token.getUserId(), token.getContextId()));
                    if (null == userTokens) continue;
                    userTokens.remove(token.getId());
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private static final class Key {
        private final int cid;
        private final int user;
        private final int hash;

        public Key(int user, int cid) {
            this.user = user;
            this.cid = cid;
            int prime = 31;
            int result = 1;
            result = 31 * result + cid;
            this.hash = result = 31 * result + user;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.cid != other.cid) {
                return false;
            }
            return this.user == other.user;
        }
    }
}

