/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.api.enhanced;

import com.openexchange.exception.OXException;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.MailMessageStorage;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.ImageMessageHandler;
import com.openexchange.mail.parser.handlers.MailPartHandler;
import com.openexchange.mail.search.FlagTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.text.TextFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MailMessageStorageLong
extends MailMessageStorage {
    private static final Logger LOG = LoggerFactory.getLogger(MailMessageStorageLong.class);
    private static final MailField[] FIELDS_FULL = new MailField[]{MailField.FULL};
    private static final SearchTerm<Integer> TERM_FLAG_SEEN = new FlagTerm(32, false);
    private static final int RADIX = 10;
    private static final long DEFAULT = -1L;

    protected MailMessageStorageLong() {
    }

    @Override
    public String[] appendMessages(String destFolder, MailMessage[] msgs) throws OXException {
        return MailMessageStorageLong.longs2uids(this.appendMessagesLong(destFolder, msgs));
    }

    public abstract long[] appendMessagesLong(String var1, MailMessage[] var2) throws OXException;

    @Override
    public String[] copyMessages(String sourceFolder, String destFolder, String[] mailIds, boolean fast) throws OXException {
        return MailMessageStorageLong.longs2uids(this.copyMessagesLong(sourceFolder, destFolder, MailMessageStorageLong.uids2longs(mailIds), fast));
    }

    public abstract long[] copyMessagesLong(String var1, String var2, long[] var3, boolean var4) throws OXException;

    @Override
    public void deleteMessages(String folder, String[] mailIds, boolean hardDelete) throws OXException {
        this.deleteMessagesLong(folder, MailMessageStorageLong.uids2longs(mailIds), hardDelete);
    }

    public abstract void deleteMessagesLong(String var1, long[] var2, boolean var3) throws OXException;

    @Override
    public MailMessage[] getAllMessages(String folder, IndexRange indexRange, MailSortField sortField, OrderDirection order, MailField[] fields) throws OXException {
        return this.searchMessages(folder, indexRange, sortField, order, null, fields);
    }

    @Override
    public MailPart getAttachment(String folder, String mailId, String sequenceId) throws OXException {
        try {
            return this.getAttachmentLong(folder, MailMessageStorageLong.parseUnsignedLong(mailId), sequenceId);
        }
        catch (NumberFormatException e) {
            LOG.error("UID cannot be parsed to a number: {}", (Object)mailId, (Object)e);
            return null;
        }
    }

    public MailPart getAttachmentLong(String folder, long mailId, String sequenceId) throws OXException {
        MailPartHandler handler = new MailPartHandler(sequenceId);
        MailMessage mail = this.getMessageLong(folder, mailId, false);
        if (null == mail) {
            throw MailExceptionCode.MAIL_NOT_FOUND.create(mailId, folder);
        }
        new MailMessageParser().parseMailMessage(mail, handler);
        if (handler.getMailPart() == null) {
            throw MailExceptionCode.ATTACHMENT_NOT_FOUND.create(sequenceId, mailId, folder);
        }
        return handler.getMailPart();
    }

    @Override
    public MailPart getImageAttachment(String folder, String mailId, String contentId) throws OXException {
        try {
            return this.getImageAttachmentLong(folder, MailMessageStorageLong.parseUnsignedLong(mailId), contentId);
        }
        catch (NumberFormatException e) {
            LOG.error("UID cannot be parsed to a number: {}", (Object)mailId, (Object)e);
            return null;
        }
    }

    public MailPart getImageAttachmentLong(String folder, long mailId, String contentId) throws OXException {
        ImageMessageHandler handler = new ImageMessageHandler(contentId);
        MailMessage mail = this.getMessageLong(folder, mailId, false);
        if (null == mail) {
            throw MailExceptionCode.MAIL_NOT_FOUND.create(mailId, folder);
        }
        new MailMessageParser().parseMailMessage(mail, handler);
        MailPart imagePart = handler.getImagePart();
        if (null == imagePart) {
            throw MailExceptionCode.IMAGE_ATTACHMENT_NOT_FOUND.create(contentId, mailId, folder);
        }
        return imagePart;
    }

    @Override
    public String[] getPrimaryContents(String folder, String[] mailIds) throws OXException {
        return this.getPrimaryContentsLong(folder, MailMessageStorageLong.uids2longs(mailIds));
    }

    public String[] getPrimaryContentsLong(String folder, long[] mailIds) throws OXException {
        TextFinder textFinder = new TextFinder();
        int length = mailIds.length;
        String[] retval = new String[length];
        for (int i = 0; i < length; ++i) {
            String text = null;
            try {
                text = textFinder.getText(this.getMessageLong(folder, mailIds[i], false));
            }
            catch (Throwable t) {
                LOG.warn("Error while getting primary content for mail ''{}'' in folder ''{}''. Returning null.", new Object[]{mailIds[i], folder, t});
            }
            retval[i] = text;
        }
        return retval;
    }

    @Override
    public MailMessage getMessage(String folder, String mailId, boolean markSeen) throws OXException {
        try {
            return this.getMessageLong(folder, MailMessageStorageLong.parseUnsignedLong(mailId), markSeen);
        }
        catch (NumberFormatException e) {
            LOG.error("UID cannot be parsed to a number: {}", (Object)mailId, (Object)e);
            return null;
        }
    }

    public MailMessage getMessageLong(String folder, long mailId, boolean markSeen) throws OXException {
        MailMessage[] mails = this.getMessagesLong(folder, new long[]{mailId}, FIELDS_FULL);
        if (mails == null || mails.length == 0 || mails[0] == null) {
            return null;
        }
        MailMessage mail = mails[0];
        if (!mail.isSeen() && markSeen) {
            mail.setPrevSeen(false);
            this.updateMessageFlagsLong(folder, new long[]{mailId}, 32, true);
            mail.setFlag(32, true);
            mail.setUnreadMessages(mail.getUnreadMessages() <= 0 ? 0 : mail.getUnreadMessages() - 1);
        }
        return mail;
    }

    @Override
    public MailMessage[] getMessages(String folder, String[] mailIds, MailField[] fields) throws OXException {
        return this.getMessagesLong(folder, MailMessageStorageLong.uids2longs(mailIds), fields);
    }

    public abstract MailMessage[] getMessagesLong(String var1, long[] var2, MailField[] var3) throws OXException;

    @Override
    public MailMessage[] getThreadSortedMessages(String folder, IndexRange indexRange, MailSortField sortField, OrderDirection order, SearchTerm<?> searchTerm, MailField[] fields) throws OXException {
        return null;
    }

    @Override
    public MailMessage[] getUnreadMessages(String folder, MailSortField sortField, OrderDirection order, MailField[] fields, int limit) throws OXException {
        if (limit == 0) {
            return EMPTY_RETVAL;
        }
        return this.searchMessages(folder, limit < 0 ? IndexRange.NULL : new IndexRange(0, limit), sortField, order, TERM_FLAG_SEEN, fields);
    }

    @Override
    public String[] moveMessages(String sourceFolder, String destFolder, String[] mailIds, boolean fast) throws OXException {
        return MailMessageStorageLong.longs2uids(this.moveMessagesLong(sourceFolder, destFolder, MailMessageStorageLong.uids2longs(mailIds), fast));
    }

    public long[] moveMessagesLong(String sourceFolder, String destFolder, long[] mailIds, boolean fast) throws OXException {
        long[] ids = this.copyMessagesLong(sourceFolder, destFolder, mailIds, fast);
        this.deleteMessagesLong(sourceFolder, mailIds, true);
        return ids;
    }

    @Override
    public abstract void releaseResources() throws OXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailMessage saveDraft(String draftFullName, ComposedMailMessage draftMail) throws OXException {
        String uid;
        try {
            MailMessage filledMail = MimeMessageConverter.fillComposedMailMessage(draftMail);
            filledMail.setFlag(4, true);
            uid = this.appendMessages(draftFullName, new MailMessage[]{filledMail})[0];
        }
        finally {
            draftMail.cleanUp();
        }
        MailPath msgref = draftMail.getMsgref();
        if (msgref != null && draftFullName.equals(msgref.getFolder())) {
            this.deleteMessages(msgref.getFolder(), new String[]{msgref.getMailID()}, true);
            draftMail.setMsgref(null);
        }
        return this.getMessage(draftFullName, uid, true);
    }

    @Override
    public abstract MailMessage[] searchMessages(String var1, IndexRange var2, MailSortField var3, OrderDirection var4, SearchTerm<?> var5, MailField[] var6) throws OXException;

    @Override
    public void updateMessageColorLabel(String folder, String[] mailIds, int colorLabel) throws OXException {
        this.updateMessageColorLabelLong(folder, MailMessageStorageLong.uids2longs(mailIds), colorLabel);
    }

    public void updateMessageColorLabelLong(String folder, long[] mailIds, int colorLabel) throws OXException {
    }

    @Override
    public void updateMessageFlags(String folder, String[] mailIds, int flags, boolean set) throws OXException {
        this.updateMessageFlagsLong(folder, MailMessageStorageLong.uids2longs(mailIds), flags, set);
    }

    public abstract void updateMessageFlagsLong(String var1, long[] var2, int var3, boolean var4) throws OXException;

    protected static final long[] uids2longs(String[] uids) {
        if (null == uids) {
            return null;
        }
        long[] retval = new long[uids.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = MailMessageStorageLong.parseUnsignedLong(uids[i]);
        }
        return retval;
    }

    protected static final String[] longs2uids(long[] longs) {
        if (null == longs) {
            return null;
        }
        String[] retval = new String[longs.length];
        for (int i = 0; i < retval.length; ++i) {
            long l = longs[i];
            retval[i] = -1L == l ? null : Long.toString(longs[i], 10);
        }
        return retval;
    }

    protected static long parseUnsignedLong(String s) {
        int digit;
        if (s == null) {
            return -1L;
        }
        int max = s.length();
        if (max <= 0) {
            return -1L;
        }
        if (s.charAt(0) == '-') {
            return -1L;
        }
        long result = 0L;
        int i = 0;
        long limit = -9223372036854775807L;
        long multmin = -922337203685477580L;
        if (i < max) {
            if ((digit = MailMessageStorageLong.digit(s.charAt(i++))) < 0) {
                return -1L;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = MailMessageStorageLong.digit(s.charAt(i++))) < 0) {
                return -1L;
            }
            if (result < -922337203685477580L) {
                return -1L;
            }
            if ((result *= 10L) < -9223372036854775807L + (long)digit) {
                return -1L;
            }
            result -= (long)digit;
        }
        return -result;
    }

    private static int digit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }
}

