/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.lock.impl;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.lock.LockService;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockServiceImpl
implements LockService {
    private final String region;

    public LockServiceImpl() {
        this.region = "GenLocks";
    }

    private Cache getCache() throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            throw ServiceExceptionCode.absentService(CacheService.class);
        }
        return cacheService.getCache(this.region);
    }

    public Lock getLockFor(String identifier) throws OXException {
        Cache cache = this.getCache();
        Object object = cache.get((Serializable)((Object)identifier));
        if (object instanceof Lock) {
            return (Lock)object;
        }
        try {
            ReentrantLock newLock = new ReentrantLock();
            cache.putSafe((Serializable)((Object)identifier), (Serializable)newLock);
            return newLock;
        }
        catch (OXException e) {
            object = cache.get((Serializable)((Object)identifier));
            if (object instanceof Lock) {
                return (Lock)object;
            }
            throw OXException.general((String)("Could not create lock for identifier: " + identifier));
        }
    }

    public void removeLockFor(String identifier) {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            try {
                cacheService.getCache(this.region).remove((Serializable)((Object)identifier));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

